/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.core.connection;

import org.jboss.tools.openshift.common.core.connection.AbstractConnectionPersistency;
import org.jboss.tools.openshift.common.core.connection.ConnectionURL;
import org.jboss.tools.openshift.core.LazyCredentialsPrompter;
import org.jboss.tools.openshift.core.OpenShiftCoreUIIntegration;
import org.jboss.tools.openshift.core.connection.Connection;
import org.jboss.tools.openshift.core.connection.ConnectionFactory;
import org.jboss.tools.openshift.core.preferences.OpenShiftCorePreferences;
import org.jboss.tools.openshift.internal.core.OpenShiftCoreActivator;

public class ConnectionPersistency
extends AbstractConnectionPersistency<Connection> {
    protected String[] loadPersisted() {
        return OpenShiftCorePreferences.INSTANCE.loadConnections();
    }

    protected void persist(String[] connections) {
        OpenShiftCorePreferences.INSTANCE.saveConnections(connections);
    }

    protected void logError(String message, Exception e) {
        OpenShiftCoreActivator.pluginLog().logError(message, (Throwable)e);
    }

    protected Connection createConnection(ConnectionURL connectionURL) {
        Connection connection = new ConnectionFactory().create(connectionURL.getHostWithScheme(), new LazyCredentialsPrompter(OpenShiftCoreUIIntegration.getInstance().getCredentialPrompter()));
        if (connection == null) {
            return null;
        }
        connection.setUsername(connectionURL.getUsername());
        connection.setAuthScheme(OpenShiftCorePreferences.INSTANCE.loadScheme(connectionURL.toString()));
        return connection;
    }
}

