/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.core.connection;

import com.openshift.restclient.ClientFactory;
import com.openshift.restclient.IClient;
import com.openshift.restclient.ISSLCertificateCallback;
import com.openshift.restclient.OpenShiftException;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.openshift.common.core.ICredentialsPrompter;
import org.jboss.tools.openshift.common.core.connection.IConnection;
import org.jboss.tools.openshift.common.core.connection.IConnectionFactory;
import org.jboss.tools.openshift.core.LazySSLCertificateCallback;
import org.jboss.tools.openshift.core.OpenShiftCoreUIIntegration;
import org.jboss.tools.openshift.core.connection.Connection;
import org.jboss.tools.openshift.internal.core.OpenShiftCoreActivator;

public class ConnectionFactory
implements IConnectionFactory {
    public String getName() {
        return "OpenShift 3";
    }

    public String getId() {
        return "org.jboss.tools.openshift.core.ConnectionFactory";
    }

    public Connection create(String url) {
        return this.create(url, null);
    }

    public Connection create(String url, ICredentialsPrompter credentialsPrompter) {
        try {
            LazySSLCertificateCallback sslCertCallback = new LazySSLCertificateCallback(OpenShiftCoreUIIntegration.getInstance().getSSLCertificateCallback());
            IClient client = new ClientFactory().create(url, (ISSLCertificateCallback)sslCertCallback);
            return new Connection(client, credentialsPrompter, (ISSLCertificateCallback)sslCertCallback);
        }
        catch (OpenShiftException e) {
            OpenShiftCoreActivator.pluginLog().logInfo(NLS.bind((String)"Could not create OpenShift connection: Malformed url {0}", (Object)url), (Throwable)e);
            return null;
        }
    }

    public String getDefaultHost() {
        return null;
    }

    public boolean hasDefaultHost() {
        return false;
    }

    public <T extends IConnection> boolean canCreate(Class<T> clazz) {
        return Connection.class.isAssignableFrom(clazz);
    }
}

