/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.aesh.core.internal.ansi;

import org.jboss.tools.aesh.core.document.Document;
import org.jboss.tools.aesh.core.internal.ansi.AbstractCommand;
import org.jboss.tools.aesh.core.internal.ansi.CommandType;

public class CursorDown
extends AbstractCommand {
    private int amount = 1;

    public CursorDown(String arguments) {
        if (!"".equals(arguments)) {
            this.amount = Integer.valueOf(arguments);
        }
    }

    @Override
    public CommandType getType() {
        return CommandType.CURSOR_DOWN;
    }

    @Override
    public void handle(Document document) {
        int lastLine;
        int currentOffset = document.getCursorOffset();
        int currentLine = document.getLineOfOffset(currentOffset);
        int newLine = currentLine + this.amount;
        if (newLine <= (lastLine = document.getLineOfOffset(document.getLength()))) {
            int currentColumn = Math.min(currentOffset - document.getLineOffset(currentLine), document.getLineLength(newLine));
            int newOffset = document.getLineOffset(newLine) + currentColumn;
            document.moveCursorTo(newOffset);
        }
    }
}

