/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.preview.editor;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.jboss.tools.jst.web.ui.WebUiPlugin;
import org.jboss.tools.jst.web.ui.internal.editor.bundle.BundleMap;
import org.jboss.tools.jst.web.ui.internal.editor.editor.IVisualEditor;
import org.jboss.tools.jst.web.ui.internal.editor.editor.IVisualEditorFactory;
import org.jboss.tools.vpe.editor.VpeEditorPart;
import org.jboss.tools.vpe.editor.util.VpePlatformUtil;
import org.jboss.tools.vpe.preview.core.util.SuitableFileExtensions;
import org.jboss.tools.vpe.preview.editor.EngineDialog;
import org.jboss.tools.vpe.preview.editor.VpvEditorPart;

public class VpeEditorPartFactory
implements IVisualEditorFactory {
    static {
        WebUiPlugin.getDefault().getPreferenceStore().setValue("Show VPE Toolbar", true);
    }

    public IVisualEditor createVisualEditor(EditorPart multiPageEditor, StructuredTextEditor textEditor, int visualMode, BundleMap bundleMap) {
        EngineDialog d;
        if (VpePlatformUtil.isXulrunnerForced()) {
            return this.getVpeEditor(multiPageEditor, textEditor, visualMode, bundleMap);
        }
        if (VpePlatformUtil.isDefaultBrowserForced()) {
            return this.getPreviewEditor(multiPageEditor, textEditor, visualMode, bundleMap);
        }
        IEditorInput editorInput = multiPageEditor.getEditorInput();
        boolean isHtmlFile = false;
        if (editorInput instanceof IFileEditorInput) {
            String fileExtension = ((IFileEditorInput)editorInput).getFile().getFileExtension();
            isHtmlFile = SuitableFileExtensions.isHTML((String)fileExtension);
        } else if (editorInput instanceof IPathEditorInput) {
            IPath externalFile = ((IPathEditorInput)editorInput).getPath();
            isHtmlFile = SuitableFileExtensions.isHTML((String)externalFile.getFileExtension());
        } else {
            isHtmlFile = true;
        }
        if (isHtmlFile) {
            if (VpePlatformUtil.xulrunnerCanBeLoadedOnLinux() && !WebUiPlugin.getDefault().getPreferenceStore().getBoolean("Use visual editor for html5 editing") && !WebUiPlugin.getDefault().getPreferenceStore().getBoolean("Remember visual editor engine")) {
                d = new EngineDialog(Display.getDefault().getActiveShell());
                d.open();
            }
            return this.getPreviewEditor(multiPageEditor, textEditor, visualMode, bundleMap);
        }
        if (VpePlatformUtil.xulrunnerCanBeLoadedOnLinux() && WebUiPlugin.getDefault().getPreferenceStore().getBoolean("Use visual editor for html5 editing") && !WebUiPlugin.getDefault().getPreferenceStore().getBoolean("Remember visual editor engine")) {
            d = new EngineDialog(Display.getDefault().getActiveShell());
            d.open();
        }
        return this.getVpeEditor(multiPageEditor, textEditor, visualMode, bundleMap);
    }

    private IVisualEditor getVpeEditor(final EditorPart multiPageEditor, StructuredTextEditor textEditor, int visualMode, BundleMap bundleMap) {
        return new VpeEditorPart(multiPageEditor, textEditor, visualMode, bundleMap){

            public void doSave(IProgressMonitor monitor) {
                multiPageEditor.doSave(monitor);
            }
        };
    }

    private IVisualEditor getPreviewEditor(EditorPart multiPageEditor, StructuredTextEditor textEditor, int visualMode, BundleMap bundleMap) {
        return new VpvEditorPart(multiPageEditor, textEditor, visualMode, bundleMap);
    }
}

