/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.core.util;

import com.openshift.client.IApplication;
import com.openshift.client.IDomain;
import com.openshift.client.IGearProfile;
import com.openshift.client.cartridge.ICartridge;
import java.net.URL;
import java.util.List;
import org.jboss.tools.openshift.common.core.utils.StringUtils;
import org.jboss.tools.openshift.express.internal.core.cartridges.CodeAnythingCartridge;
import org.jboss.tools.openshift.express.internal.core.connection.ExpressConnection;

public class ExpressResourceLabelUtils {
    public static String toString(Object object) {
        if (object instanceof IDomain) {
            return ExpressResourceLabelUtils.toString((IDomain)object);
        }
        if (object instanceof ICartridge) {
            return ExpressResourceLabelUtils.toString((ICartridge)object);
        }
        if (object instanceof IApplication) {
            return ExpressResourceLabelUtils.toString((IApplication)object);
        }
        if (object instanceof IGearProfile) {
            return ExpressResourceLabelUtils.toString((IGearProfile)object);
        }
        return null;
    }

    public static String toString(ExpressConnection connection) {
        if (connection == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        builder.append(StringUtils.null2emptyString((String)connection.getUsername()));
        if (!StringUtils.isEmpty((String)connection.getUsername())) {
            builder.append(" at ");
        }
        builder.append(connection.getHost());
        if (connection.isDefaultHost()) {
            builder.append(" (default)");
        }
        return builder.toString();
    }

    public static String toString(IApplication application) {
        if (application == null) {
            return null;
        }
        return application.getName();
    }

    public static String toString(ICartridge cartridge) {
        if (cartridge == null) {
            return null;
        }
        if (cartridge instanceof CodeAnythingCartridge) {
            return ExpressResourceLabelUtils.toCodeAnythingLabel(cartridge.getName(), cartridge.getDisplayName(), cartridge.getUrl());
        }
        if (cartridge.isDownloadable()) {
            return ExpressResourceLabelUtils.toDownloadableCartridgeLabel(cartridge.getName(), cartridge.getDisplayName(), cartridge.getUrl());
        }
        return ExpressResourceLabelUtils.toCatridgeLabel(cartridge.getName(), cartridge.getDisplayName(), cartridge.isObsolete());
    }

    private static String toCatridgeLabel(String name, String displayName, boolean isObsolete) {
        StringBuilder builder = new StringBuilder();
        if (!StringUtils.isEmpty((String)displayName)) {
            builder.append(displayName).append(" (").append(name).append(')');
        } else {
            builder.append(name);
        }
        if (isObsolete) {
            builder.append("[obsolete]");
        }
        return builder.toString();
    }

    private static String toCodeAnythingLabel(String name, String displayName, URL url) {
        StringBuilder builder = new StringBuilder();
        if (url != null) {
            builder.append(StringUtils.shorten((String)url.toString(), (int)50));
        } else {
            builder.append(displayName);
        }
        return builder.append(" (Downloadable Cartridge)").toString();
    }

    private static String toDownloadableCartridgeLabel(String name, String displayName, URL url) {
        String cartridgeName = ExpressResourceLabelUtils.getCartridgeName(name, displayName);
        if (cartridgeName == null && url != null) {
            cartridgeName = StringUtils.shorten((String)url.toString(), (int)50);
        }
        StringBuilder builder = new StringBuilder();
        if (cartridgeName != null) {
            builder.append(cartridgeName);
            builder.append(" (");
        }
        builder.append("Downloadable Cartridge");
        if (cartridgeName != null) {
            builder.append(')');
        }
        return builder.toString();
    }

    private static String getCartridgeName(String name, String displayName) {
        String cartridgeName = null;
        if (!StringUtils.isEmpty((String)displayName)) {
            cartridgeName = displayName;
        } else if (!StringUtils.isEmpty((String)name)) {
            cartridgeName = name;
        }
        return cartridgeName;
    }

    public static String toString(List<IDomain> domains) {
        StringBuilder builder = new StringBuilder();
        if (domains == null || domains.isEmpty()) {
            return builder.toString();
        }
        for (IDomain domain : domains) {
            if (domain == null) continue;
            if (builder.length() > 0) {
                builder.append(", ");
            }
            builder.append(ExpressResourceLabelUtils.toString(domain));
        }
        return builder.toString();
    }

    public static String toString(IDomain domain) {
        if (domain == null) {
            return null;
        }
        return domain.getId() + '.' + domain.getSuffix();
    }

    public static String toString(IGearProfile gear) {
        if (gear == null) {
            return null;
        }
        return gear.getName();
    }
}

