/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.core.util;

public enum DeployFolder {
    JBOSSAS("jbossas", "deployments"),
    JBOSSEAP("jbosseap", "deployments"),
    WILDFLY8("wildfly", "deployments"),
    JBOSSEWS("jbossews", "webapps");

    private String cartridgeName;
    private String deployFolder;

    private DeployFolder(String cartridgeName, String deployFolder) {
        this.cartridgeName = cartridgeName;
        this.deployFolder = deployFolder;
    }

    public String getDeployFolder() {
        return this.deployFolder;
    }

    public static DeployFolder getByCartridgeName(String cartridgeName) {
        if (cartridgeName == null) {
            return null;
        }
        DeployFolder[] deployFolderArray = DeployFolder.values();
        int n = deployFolderArray.length;
        int n2 = 0;
        while (n2 < n) {
            DeployFolder deployFolder = deployFolderArray[n2];
            if (cartridgeName.startsWith(deployFolder.cartridgeName)) {
                return deployFolder;
            }
            ++n2;
        }
        return null;
    }
}

