/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.core.server;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.egit.core.op.AddToIndexOperation;
import org.eclipse.egit.core.op.PushOperationResult;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerAttributes;
import org.eclipse.wst.server.core.internal.Server;
import org.eclipse.wst.server.core.model.IModuleResourceDelta;
import org.jboss.ide.eclipse.as.core.modules.ResourceModuleResourceUtil;
import org.jboss.ide.eclipse.as.core.server.IDeployableServer;
import org.jboss.ide.eclipse.as.core.server.IModulePathFilter;
import org.jboss.ide.eclipse.as.core.server.IModulePathFilterProvider;
import org.jboss.ide.eclipse.as.core.util.ServerConverter;
import org.jboss.ide.eclipse.as.wtp.core.server.publish.LocalZippedModulePublishRunner;
import org.jboss.tools.as.core.internal.modules.ModuleDeploymentPrefsUtil;
import org.jboss.tools.openshift.common.core.utils.ProjectUtils;
import org.jboss.tools.openshift.egit.core.EGitUtils;
import org.jboss.tools.openshift.express.core.ExpressCoreUIIntegration;
import org.jboss.tools.openshift.express.internal.core.ExpressCoreActivator;
import org.jboss.tools.openshift.express.internal.core.server.OpenShiftServerMessages;
import org.jboss.tools.openshift.express.internal.core.server.OpenShiftServerUtils;

public class OpenShiftServerPublishMethod {
    public void publishStart(IServer server, IProgressMonitor monitor) throws CoreException {
        IProject magicProject;
        String destProjName = OpenShiftServerUtils.getDeployProjectName((IServerAttributes)server);
        IProject iProject = magicProject = destProjName == null ? null : ResourcesPlugin.getWorkspace().getRoot().getProject(destProjName);
        if (magicProject == null || !magicProject.isAccessible()) {
            throw new CoreException((IStatus)new Status(4, "org.jboss.tools.openshift.express.core", NLS.bind((String)OpenShiftServerMessages.publishFailMissingProject, (Object)server.getName(), (Object)destProjName)));
        }
    }

    public int publishFinish(IServer server, IProgressMonitor monitor) throws CoreException {
        IProject project = OpenShiftServerUtils.getDeployProject((IServerAttributes)server);
        boolean allSubModulesPublished = this.areAllModulesPublished(server);
        if (ProjectUtils.exists((IProject)project)) {
            IContainer deployFolder = OpenShiftServerUtils.getContainer(OpenShiftServerUtils.getDeployFolder((IServerAttributes)server), project);
            if (allSubModulesPublished || deployFolder != null && deployFolder.isAccessible()) {
                project.refreshLocal(2, monitor);
                this.publish(project, server, monitor);
            }
        }
        return allSubModulesPublished ? 1 : 2;
    }

    private boolean areAllModulesPublished(IServer server) {
        IModule[] modules = server.getModules();
        boolean allpublished = true;
        int i = 0;
        while (i < modules.length) {
            if (server.getModulePublishState(new IModule[]{modules[i]}) != 1) {
                allpublished = false;
            }
            ++i;
        }
        return allpublished;
    }

    public int publishModule(IServer server, int kind, int deltaKind, IModule[] module, IProgressMonitor monitor) throws CoreException {
        if (module.length > 1) {
            return 0;
        }
        String destProjName = OpenShiftServerUtils.getDeployProjectName((IServerAttributes)server);
        if (this.isInDestProjectTree(destProjName, module)) {
            return 1;
        }
        IProject destProj = ResourcesPlugin.getWorkspace().getRoot().getProject(destProjName);
        if (destProj.equals((Object)module[module.length - 1].getProject())) {
            return 1;
        }
        IContainer destFolder = this.getDestination(server, destProj);
        IPath destPath = destFolder.getLocation();
        if (module.length == 0) {
            return 1;
        }
        int modulePublishState = server.getModulePublishState(module);
        this.getPublishType(kind, deltaKind, modulePublishState);
        IModuleResourceDelta[] cfr_ignored_0 = new IModuleResourceDelta[0];
        if (deltaKind != 3) {
            ((Server)server).getPublishedResourceDelta(module);
        }
        try {
            IPath outputFileFullPath = OpenShiftServerPublishMethod.getModuleNestedDeployPath(module, destPath.toOSString(), server);
            String outputFileName = outputFileFullPath.lastSegment();
            IFile changedResource = destFolder.getFile((IPath)new Path(outputFileName));
            IResource[] resource = new IResource[]{changedResource};
            if (deltaKind == 3) {
                changedResource.delete(false, monitor);
            } else {
                LocalZippedModulePublishRunner runner = this.createZippedRunner(server, module[0], outputFileFullPath);
                monitor.beginTask("Moving module to " + destFolder.getName(), 100);
                runner.fullPublishModule((IProgressMonitor)new SubProgressMonitor(monitor, 20));
                destFolder.refreshLocal(2, (IProgressMonitor)new SubProgressMonitor(monitor, 20));
                AddToIndexOperation operation = new AddToIndexOperation(resource);
                try {
                    operation.execute((IProgressMonitor)new SubProgressMonitor(monitor, 60));
                }
                catch (CoreException e) {
                    ExpressCoreActivator.pluginLog().logStatus(e.getStatus());
                }
            }
        }
        catch (Exception e) {
            ExpressCoreActivator.pluginLog().logError(e.getMessage(), (Throwable)e);
        }
        return 1;
    }

    public static IPath getModuleNestedDeployPath(IModule[] moduleTree, String rootFolder, IServer server) {
        return new ModuleDeploymentPrefsUtil().getModuleNestedDeployPath(moduleTree, rootFolder, (IServerAttributes)server);
    }

    private LocalZippedModulePublishRunner createZippedRunner(IServer server, IModule m, IPath p) {
        return new LocalZippedModulePublishRunner(server, m, p, this.getModulePathFilterProvider());
    }

    private IModulePathFilterProvider getModulePathFilterProvider() {
        return new IModulePathFilterProvider(){

            public IModulePathFilter getFilter(IServer server, IModule[] module) {
                return ResourceModuleResourceUtil.findDefaultModuleFilter((IModule)module[module.length - 1]);
            }
        };
    }

    private IContainer getDestination(IServer server, IProject destProj) throws CoreException {
        String destinationFolder = OpenShiftServerUtils.getDeployFolder((IServerAttributes)server);
        IContainer destFolder = OpenShiftServerUtils.getContainer(destinationFolder, destProj);
        if (destFolder == null || !destFolder.isAccessible()) {
            throw new CoreException(ExpressCoreActivator.statusFactory().errorStatus(NLS.bind((String)OpenShiftServerMessages.publishFailMissingFolder, (Object)server.getName(), (Object)this.createMissingPath(destProj, destinationFolder, destFolder))));
        }
        return destFolder;
    }

    private StringBuilder createMissingPath(IProject destProj, String destinationFolder, IContainer destFolder) {
        StringBuilder missingPath = new StringBuilder();
        if (destFolder != null) {
            missingPath.append(destFolder.getName());
        } else {
            missingPath.append(destProj.getName());
            missingPath.append(File.separatorChar);
            missingPath.append(destinationFolder);
        }
        return missingPath;
    }

    private boolean isInDestProjectTree(String magicProject, IModule[] modules) {
        IProject magic = magicProject == null ? null : ResourcesPlugin.getWorkspace().getRoot().getProject(magicProject);
        IProject moduleProject = this.getModuleProject(modules);
        if (magic == null || moduleProject == null) {
            return false;
        }
        IPath moduleProjectRoot = moduleProject.getLocation();
        IPath magicProjectRoot = magic.getLocation();
        return magicProjectRoot.isPrefixOf(moduleProjectRoot);
    }

    private IProject getModuleProject(IModule[] modules) {
        if (modules == null) {
            return null;
        }
        if (modules.length == 0) {
            return null;
        }
        return modules[modules.length - 1].getProject();
    }

    protected PushOperationResult publish(IProject project, IServer server, IProgressMonitor monitor) throws CoreException {
        SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 200);
        try {
            boolean uncommittedChanges;
            boolean bl = uncommittedChanges = EGitUtils.countChanges((Repository)EGitUtils.getRepository((IProject)project), (boolean)true, (IProgressMonitor)new NullProgressMonitor()) > 0;
            if (uncommittedChanges) {
                String remote = OpenShiftServerUtils.getRemoteName((IServerAttributes)server);
                String applicationName = OpenShiftServerUtils.getApplicationName((IServerAttributes)server);
                ExpressCoreUIIntegration.openCommitDialog(project, remote, applicationName, new PublishJob(applicationName, project, server));
            } else if (ExpressCoreUIIntegration.requestApproval(this.getPushQuestion(project, server, (IProgressMonitor)subMonitor), NLS.bind((String)OpenShiftServerMessages.publishTitle, (Object)project.getName()))) {
                PushOperationResult pushOperationResult = this.push(project, server, (IProgressMonitor)subMonitor);
                return pushOperationResult;
            }
        }
        catch (Exception e) {
            IStatus status = ExpressCoreActivator.statusFactory().errorStatus((Throwable)e);
            ExpressCoreActivator.pluginLog().logStatus(status);
            throw new CoreException(status);
        }
        finally {
            subMonitor.done();
        }
        return null;
    }

    private String getPushQuestion(IProject project, IServer server, IProgressMonitor monitor) throws IOException, InvocationTargetException, URISyntaxException {
        String openShiftRemoteName = OpenShiftServerUtils.getRemoteName((IServerAttributes)server);
        if (!EGitUtils.isAhead((IProject)project, (String)openShiftRemoteName, (IProgressMonitor)monitor)) {
            return NLS.bind((String)OpenShiftServerMessages.noChangesPushAnywayMsg, (Object)project.getName());
        }
        return NLS.bind((String)OpenShiftServerMessages.committedChangesNotPushedYet, (Object)project.getName());
    }

    private PushOperationResult push(IProject project, IServer server, IProgressMonitor monitor) throws CoreException {
        SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 100);
        Repository repository = EGitUtils.getRepository((IProject)project);
        ExpressCoreUIIntegration.displayConsoleView(server);
        String remoteName = OpenShiftServerUtils.getRemoteName((IServerAttributes)server.createWorkingCopy());
        try {
            PushOperationResult pushOperationResult = EGitUtils.push((String)remoteName, (Repository)repository, (IProgressMonitor)subMonitor, (OutputStream)ExpressCoreUIIntegration.getConsoleOutputStream(server));
            return pushOperationResult;
        }
        catch (CoreException ce) {
            subMonitor.worked(100);
            if (this.isUpToDateError(ce)) {
                ExpressCoreUIIntegration.appendToConsole(server, "\n\nRepository already uptodate.");
                return null;
            }
            if (ExpressCoreUIIntegration.requestApproval("Error: '" + ce.getMessage() + "' occurred while pushing.\n\nIf the commit history is not correct on the remote repository, " + "a forced push (git push -f) might be the right thing to do. This will though overwrite the remote repository!" + "\n\n Do you want to do a forced push and overwrite any remote changes ? ", "Attempt push force ?", false)) {
                PushOperationResult pushOperationResult = EGitUtils.pushForce((String)remoteName, (Repository)repository, (IProgressMonitor)subMonitor, (OutputStream)ExpressCoreUIIntegration.getConsoleOutputStream(server));
                return pushOperationResult;
            }
            ExpressCoreUIIntegration.appendToConsole(server, "\n\nERROR: " + ce.getLocalizedMessage() + "\n\n" + "To prevent you from losing history, non-fast-forward updates were rejected" + "\nMerge the remote changes (e.g. 'Team > Fetch from Upstream' in Eclipse or 'git pull' on command line ) before pushing again. " + "\nSee the 'Note about fast-forwards' section of 'git push --help' for details.");
            return null;
        }
        finally {
            subMonitor.done();
        }
    }

    private boolean isUpToDateError(CoreException ce) {
        return ce.getMessage() != null && ce.getMessage().contains("UP_TO_DATE");
    }

    protected String getModuleProjectName(IModule[] module) {
        return module[module.length - 1].getProject().getName();
    }

    public String getPublishDefaultRootFolder(IServer server) {
        IDeployableServer s = ServerConverter.getDeployableServer((IServerAttributes)server);
        return s.getDeployFolder();
    }

    public String getPublishDefaultRootTempFolder(IServer server) {
        IDeployableServer s = ServerConverter.getDeployableServer((IServerAttributes)server);
        return s.getTempDeployFolder();
    }

    private int getPublishType(int kind, int deltaKind, int modulePublishState) {
        if (deltaKind == 1) {
            return 2;
        }
        if (deltaKind == 3) {
            return 3;
        }
        if (kind == 2 || modulePublishState == 3 || kind == 4) {
            return 2;
        }
        if ((kind == 1 || modulePublishState == 2 || kind == 3) && 2 == deltaKind) {
            return 1;
        }
        return 0;
    }

    private class PublishJob
    extends Job {
        private IProject project;
        private IServer server;

        PublishJob(String applicationName, IProject project, IServer server) {
            super(NLS.bind((String)"Publishing to {0} on OpenShift...", (Object)applicationName));
            this.project = project;
            this.server = server;
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                OpenShiftServerPublishMethod.this.push(this.project, this.server, monitor);
                return Status.OK_STATUS;
            }
            catch (CoreException e) {
                return e.getStatus();
            }
        }
    }
}

