/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.core.marker;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.openshift.express.internal.core.ExpressCoreActivator;
import org.jboss.tools.openshift.express.internal.core.marker.IOpenShiftMarker;
import org.jboss.tools.openshift.express.internal.core.util.OpenShiftProjectUtils;

public class BaseOpenShiftMarker
implements IOpenShiftMarker {
    private String name;
    private String fileName;
    private String description;

    protected BaseOpenShiftMarker(String fileName, String name, String description) {
        this.name = name;
        this.fileName = fileName;
        this.description = description;
    }

    @Override
    public IFile addTo(IProject project, IProgressMonitor monitor) throws CoreException {
        this.assertProjectIsOpen(project);
        IFile file = this.getMarkerFile(project, monitor);
        if (file.isAccessible()) {
            return null;
        }
        file.create((InputStream)new ByteArrayInputStream(new byte[0]), 0, monitor);
        return file;
    }

    @Override
    public IFile removeFrom(IProject project, IProgressMonitor monitor) throws CoreException {
        this.assertProjectIsOpen(project);
        IFile file = this.getMarkerFile(project, monitor);
        if (!file.isAccessible()) {
            return null;
        }
        file.delete(false, monitor);
        return file;
    }

    private IFile getMarkerFile(IProject project, IProgressMonitor monitor) throws CoreException {
        IFolder markersFolder = OpenShiftProjectUtils.getMarkersFolder(project);
        OpenShiftProjectUtils.ensureMarkersFolderExists(project, monitor);
        return markersFolder.getFile(this.getFileName());
    }

    @Override
    public boolean existsIn(IProject project, IProgressMonitor monitor) throws CoreException {
        IFile file = this.getMarkerFile(project, monitor);
        return file.exists();
    }

    @Override
    public boolean matchesFilename(String fileName) {
        return this.fileName.equals(fileName);
    }

    private void assertProjectIsOpen(IProject project) throws CoreException {
        if (!project.exists()) {
            throw new CoreException(ExpressCoreActivator.statusFactory().errorStatus(NLS.bind((String)"Project {0} does not exist", (Object)project.getName())));
        }
        if (!project.isOpen()) {
            throw new CoreException(ExpressCoreActivator.statusFactory().errorStatus(NLS.bind((String)"Project {0} is not opened", (Object)project.getName())));
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return "BaseOpenShiftMarker [name=" + this.name + ", fileName=" + this.fileName + "]";
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.fileName == null ? 0 : this.fileName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BaseOpenShiftMarker other = (BaseOpenShiftMarker)obj;
        return !(this.fileName == null ? other.fileName != null : !this.fileName.equals(other.fileName));
    }
}

