/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.core.connection;

import com.openshift.client.OpenShiftException;
import com.openshift.client.configuration.OpenShiftConfiguration;
import java.io.IOException;
import org.jboss.tools.openshift.common.core.connection.IConnection;
import org.jboss.tools.openshift.common.core.connection.IConnectionFactory;
import org.jboss.tools.openshift.express.core.ExpressCoreUIIntegration;
import org.jboss.tools.openshift.express.internal.core.ExpressCoreActivator;
import org.jboss.tools.openshift.express.internal.core.connection.ExpressConnection;

public class ExpressConnectionFactory
implements IConnectionFactory {
    public String getName() {
        return "OpenShift 2";
    }

    public String getId() {
        return "org.jboss.tools.openshift.express.core.ConnectionFactory";
    }

    public ExpressConnection create(String url) {
        return new ExpressConnection(url, ExpressCoreUIIntegration.getDefault().getSSLCertificateCallback());
    }

    public String getDefaultHost() {
        try {
            return new OpenShiftConfiguration().getLibraServer();
        }
        catch (OpenShiftException e) {
            ExpressCoreActivator.pluginLog().logError("Could not load default host.", (Throwable)e);
            return null;
        }
        catch (IOException e) {
            ExpressCoreActivator.pluginLog().logError("Could not load default host.", (Throwable)e);
            return null;
        }
    }

    public boolean hasDefaultHost() {
        return true;
    }

    public <T extends IConnection> boolean canCreate(Class<T> clazz) {
        return ExpressConnection.class == clazz;
    }
}

