/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.core.connection;

import com.openshift.client.IApplication;
import com.openshift.client.IDomain;
import com.openshift.client.IUser;
import com.openshift.client.cartridge.IEmbeddedCartridge;
import org.eclipse.core.runtime.IAdapterFactory;
import org.jboss.tools.openshift.common.core.connection.ConnectionsRegistrySingleton;
import org.jboss.tools.openshift.express.core.util.ExpressConnectionUtils;
import org.jboss.tools.openshift.express.internal.core.connection.ExpressConnection;

public class ExpressConnectionAdapterFactory
implements IAdapterFactory {
    public Object getAdapter(Object adaptableObject, Class adapterType) {
        IEmbeddedCartridge embeddedCartridge;
        IApplication application;
        if (adapterType != ExpressConnection.class) {
            return null;
        }
        ExpressConnection connection = null;
        if (adaptableObject instanceof ExpressConnection) {
            connection = (ExpressConnection)((Object)adaptableObject);
        } else if (adaptableObject instanceof IDomain) {
            IDomain domain = (IDomain)adaptableObject;
            connection = ExpressConnectionUtils.getByResource(domain.getUser(), ConnectionsRegistrySingleton.getInstance());
        } else if (adaptableObject instanceof IUser) {
            IUser user = (IUser)adaptableObject;
            connection = ExpressConnectionUtils.getByResource(user, ConnectionsRegistrySingleton.getInstance());
        } else if (adaptableObject instanceof IApplication) {
            IApplication application2 = (IApplication)adaptableObject;
            connection = this.getConnection(application2);
        } else if (adaptableObject instanceof IEmbeddedCartridge && (application = (embeddedCartridge = (IEmbeddedCartridge)adaptableObject).getApplication()) != null) {
            connection = this.getConnection(application);
        }
        return connection;
    }

    private ExpressConnection getConnection(IApplication application) {
        IDomain domain = application.getDomain();
        if (domain == null) {
            return null;
        }
        return ExpressConnectionUtils.getByResource(domain.getUser(), ConnectionsRegistrySingleton.getInstance());
    }

    public Class<?>[] getAdapterList() {
        return new Class[]{ExpressConnection.class};
    }
}

