/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.core.connection;

import com.openshift.client.ApplicationScale;
import com.openshift.client.ConnectionBuilder;
import com.openshift.client.IApplication;
import com.openshift.client.IDomain;
import com.openshift.client.IGearProfile;
import com.openshift.client.IHttpClient;
import com.openshift.client.IOpenShiftSSHKey;
import com.openshift.client.IQuickstart;
import com.openshift.client.ISSHPublicKey;
import com.openshift.client.IUser;
import com.openshift.client.OpenShiftException;
import com.openshift.client.OpenShiftUnknonwSSHKeyTypeException;
import com.openshift.client.cartridge.ICartridge;
import com.openshift.client.cartridge.IEmbeddableCartridge;
import com.openshift.client.cartridge.IStandaloneCartridge;
import com.openshift.internal.client.utils.StreamUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.openshift.common.core.ICredentialsPrompter;
import org.jboss.tools.openshift.common.core.connection.AbstractConnection;
import org.jboss.tools.openshift.common.core.connection.ConnectionType;
import org.jboss.tools.openshift.common.core.connection.IConnection;
import org.jboss.tools.openshift.common.core.utils.StringUtils;
import org.jboss.tools.openshift.common.core.utils.UrlUtils;
import org.jboss.tools.openshift.express.client.ClientSystemProperties;
import org.jboss.tools.openshift.express.core.util.ExpressConnectionUtils;
import org.jboss.tools.openshift.express.internal.core.ExpressCoreActivator;
import org.jboss.tools.openshift.express.internal.core.preferences.ExpressCorePreferences;
import org.jboss.tools.openshift.express.internal.core.util.ExpressResourceLabelUtils;
import org.jboss.tools.openshift.internal.common.core.security.OpenShiftSecureStorageKey;
import org.jboss.tools.openshift.internal.common.core.security.SecureStore;
import org.jboss.tools.openshift.internal.common.core.security.SecureStoreException;

public class ExpressConnection
extends AbstractConnection {
    private static final String SECURE_STORAGE_PASSWORD = "pass";
    private static final String SECURE_STORAGE_BASEKEY = "org.jboss.tools.openshift.express.ui";
    private String username;
    private String password;
    private IUser user;
    private boolean isDomainLoaded;
    private boolean rememberPassword;
    private boolean didPromptForPassword;
    private boolean passwordLoaded;
    private ICredentialsPrompter passwordPrompter;
    private IHttpClient.ISSLCertificateCallback sslCallback;

    public ExpressConnection(String host, IHttpClient.ISSLCertificateCallback callback) {
        this(null, null, UrlUtils.getScheme((String)host), UrlUtils.cutScheme((String)host), false, null, callback);
    }

    public ExpressConnection(String username, String host) {
        this(username, null, host, false, null);
    }

    public ExpressConnection(String username, String host, ICredentialsPrompter prompter, IHttpClient.ISSLCertificateCallback sslCallback) {
        this(username, null, UrlUtils.getScheme((String)host), UrlUtils.cutScheme((String)host), false, null, sslCallback);
        this.passwordPrompter = prompter;
    }

    public ExpressConnection(String username, String password, String host, boolean rememberPassword, IHttpClient.ISSLCertificateCallback sslCallback) {
        this(username, password, UrlUtils.getScheme((String)host), UrlUtils.cutScheme((String)host), rememberPassword, null, sslCallback);
    }

    protected ExpressConnection(String username, String password, String scheme, String host, boolean rememberPassword, IUser user, IHttpClient.ISSLCertificateCallback sslCallback) {
        super(scheme, host);
        this.username = username;
        this.password = password;
        this.rememberPassword = rememberPassword;
        this.sslCallback = sslCallback;
        this.setUser(user);
    }

    protected void setUser(IUser user) {
        this.user = user;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
        this.firePropertyChange("username", this.username, this.username);
        this.clearUser();
    }

    public String getPassword() {
        this.loadPassword();
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
        this.firePropertyChange("password", this.password, this.password);
        this.passwordLoaded = true;
        this.clearUser();
    }

    public String getHost() {
        if (this.isDefaultHost()) {
            return ExpressConnectionUtils.getDefaultHostUrl();
        }
        return super.getHost();
    }

    public String getScheme() {
        if (this.isDefaultHost()) {
            return UrlUtils.getScheme((String)ExpressConnectionUtils.getDefaultHostUrl());
        }
        return UrlUtils.getScheme((String)super.getHost());
    }

    public boolean isDefaultHost() {
        return this.isDefaultHost(super.getHost());
    }

    private boolean isDefaultHost(String host) {
        return host == null || UrlUtils.cutScheme((String)host).isEmpty();
    }

    public boolean isRememberPassword() {
        return this.rememberPassword;
    }

    public final void setRememberPassword(boolean rememberPassword) {
        this.rememberPassword = rememberPassword;
        this.firePropertyChange("rememberPassword", this.rememberPassword, this.rememberPassword);
    }

    public boolean canPromptForPassword() {
        return !this.didPromptForPassword;
    }

    public void setSSLCertificateCallback(IHttpClient.ISSLCertificateCallback callback) {
        this.sslCallback = callback;
    }

    public boolean connect() throws OpenShiftException {
        if (this.isConnected()) {
            this.save();
            return true;
        }
        if (this.createUser()) {
            this.updateUsername(this.user);
            this.save();
            return true;
        }
        return false;
    }

    protected boolean createUser() {
        this.loadPassword();
        if (this.password == null) {
            return this.promptForCredentials();
        }
        this.setClientTimeout();
        IUser user = this.doCreateUser();
        this.setUser(user);
        return true;
    }

    protected IUser doCreateUser() {
        String userId = "org.jboss.tools.openshift.express.core " + ExpressCoreActivator.getDefault().getBundle().getVersion();
        try {
            return new ConnectionBuilder(this.getHost()).credentials(this.username, this.password).clientId(userId).sslCertificateCallback(this.sslCallback).create().getUser();
        }
        catch (IOException iOException) {
            throw new OpenShiftException("Could not connect for user {0} - {1}", new Object[]{this.username, this.getHost()});
        }
    }

    private void setClientTimeout() {
        int timeout = ExpressCorePreferences.INSTANCE.getClientReadTimeout(ClientSystemProperties.getReadTimeoutSeconds());
        ClientSystemProperties.setReadTimeoutSeconds((int)timeout);
    }

    private void loadPassword() {
        if (StringUtils.isEmpty((String)this.password) && !this.passwordLoaded) {
            this.password = this.getPassword(this.getSecureStore(this.getHost(), this.getUsername()));
            this.passwordLoaded = true;
            this.rememberPassword = this.password != null;
        }
    }

    private boolean hasUser() {
        return this.user != null;
    }

    protected void clearUser() {
        this.user = null;
    }

    private String updateUsername(IUser user) {
        if (!user.getRhlogin().equals(this.username)) {
            ExpressCoreActivator.getDefault().getLog().log((IStatus)new Status(2, "org.jboss.tools.openshift.express.core", NLS.bind((String)"User {0} was logged in as {1}", (Object)this.username, (Object)user.getRhlogin())));
        }
        this.username = user.getRhlogin();
        return this.username;
    }

    private boolean promptForCredentials() {
        if (this.passwordPrompter == null) {
            return false;
        }
        try {
            this.passwordPrompter.promptAndAuthenticate((IConnection)this, null);
            this.didPromptForPassword = true;
        }
        catch (Exception e) {
            ExpressCoreActivator.pluginLog().logError("Failed to retrieve User's password", (Throwable)e);
        }
        return this.hasUser();
    }

    public IApplication createApplication(String applicationName, IStandaloneCartridge standaloneCartridge, ApplicationScale scale, IGearProfile gearProfile, IDomain domain) throws OpenShiftException {
        if (this.connect()) {
            return domain.createApplication(applicationName, standaloneCartridge, scale, gearProfile);
        }
        return null;
    }

    public IDomain createDomain(String id) throws OpenShiftException {
        if (this.connect()) {
            return this.user.createDomain(id);
        }
        return null;
    }

    public List<IStandaloneCartridge> getStandaloneCartridges() throws OpenShiftException {
        if (this.connect()) {
            return this.user.getConnection().getStandaloneCartridges();
        }
        return null;
    }

    public List<IEmbeddableCartridge> getEmbeddableCartridges() throws OpenShiftException {
        if (this.connect()) {
            return this.user.getConnection().getEmbeddableCartridges();
        }
        return null;
    }

    public List<ICartridge> getCartridges() throws OpenShiftException {
        if (this.connect()) {
            return this.user.getConnection().getCartridges();
        }
        return null;
    }

    public List<IQuickstart> getQuickstarts() throws OpenShiftException {
        if (this.connect()) {
            return this.user.getConnection().getQuickstarts();
        }
        return null;
    }

    public void load() {
        this.getDomains();
    }

    public IApplication getApplication(String name, IDomain domain) throws OpenShiftException {
        if (domain == null) {
            return null;
        }
        return domain.getApplicationByName(name);
    }

    public boolean hasApplication(String name, IDomain domain) throws OpenShiftException {
        return this.getApplication(name, domain) != null;
    }

    public IDomain getDefaultDomain() throws OpenShiftException {
        if (this.connect()) {
            return this.user.getDefaultDomain();
        }
        return null;
    }

    public IDomain getDomain(String id) throws OpenShiftException {
        if (StringUtils.isEmpty((String)id)) {
            return null;
        }
        this.getDomains();
        return this.user.getDomain(id);
    }

    public IDomain getFirstDomain() throws OpenShiftException {
        if (!this.connect()) {
            return null;
        }
        List<IDomain> domains = this.getDomains();
        if (domains == null || domains.isEmpty()) {
            return null;
        }
        return domains.get(0);
    }

    public List<IDomain> getDomains() throws OpenShiftException {
        if (!this.connect()) {
            return Collections.emptyList();
        }
        List domains = this.user.getDomains();
        this.isDomainLoaded = true;
        return domains;
    }

    public void destroy(IDomain domain, boolean force) {
        if (this.connect()) {
            domain.destroy(force);
        }
    }

    public boolean isLoaded() throws OpenShiftException {
        return this.isDomainLoaded;
    }

    public boolean hasApplicationOfType(IStandaloneCartridge type) throws OpenShiftException {
        if (this.hasDomain()) {
            return this.user.getDefaultDomain().hasApplicationByCartridge(type);
        }
        return false;
    }

    public boolean hasDomain() throws OpenShiftException {
        if (this.connect()) {
            return this.user.hasDomain();
        }
        return false;
    }

    public boolean hasSSHKeys() throws OpenShiftException {
        if (this.connect()) {
            return !this.user.getSSHKeys().isEmpty();
        }
        return false;
    }

    public void refresh() throws OpenShiftException {
        this.isDomainLoaded = false;
        if (this.connect()) {
            this.user.refresh();
        }
    }

    public boolean isConnected() {
        return this.hasUser();
    }

    public List<IOpenShiftSSHKey> getSSHKeys() throws OpenShiftException {
        if (this.connect()) {
            return this.user.getSSHKeys();
        }
        return Collections.emptyList();
    }

    public IOpenShiftSSHKey getSSHKeyByPublicKey(String publicKey) throws OpenShiftUnknonwSSHKeyTypeException, OpenShiftException {
        if (this.connect()) {
            return this.user.getSSHKeyByPublicKey(publicKey);
        }
        return null;
    }

    public IOpenShiftSSHKey putSSHKey(String name, ISSHPublicKey key) throws OpenShiftException {
        if (this.connect()) {
            return this.user.putSSHKey(name, key);
        }
        return null;
    }

    public boolean hasSSHKeyName(String name) throws OpenShiftException {
        if (this.connect()) {
            return this.user.hasSSHKeyName(name);
        }
        return false;
    }

    public boolean hasSSHPublicKey(String publicKey) {
        if (this.connect()) {
            return this.user.hasSSHPublicKey(publicKey);
        }
        return false;
    }

    public void save() {
        String username = this.getUsername();
        if (!StringUtils.isEmpty((String)username)) {
            ExpressCorePreferences.INSTANCE.saveLastUsername(username);
            this.saveOrClearPassword(username, this.getHost(), this.getPassword());
        }
    }

    private void saveOrClearPassword(String username, String host, String password) {
        SecureStore store = this.getSecureStore(host, username);
        if (store != null && !StringUtils.isEmpty((String)username)) {
            try {
                if (this.isRememberPassword() && !StringUtils.isEmpty((String)password)) {
                    store.put(SECURE_STORAGE_PASSWORD, password);
                } else {
                    store.remove(SECURE_STORAGE_PASSWORD);
                }
            }
            catch (SecureStoreException secureStoreException) {}
        }
    }

    private String getPassword(SecureStore store) {
        String password = null;
        if (store != null && !StringUtils.isEmpty((String)this.getUsername())) {
            try {
                password = store.get(SECURE_STORAGE_PASSWORD);
            }
            catch (SecureStoreException e) {
                ExpressCoreActivator.pluginLog().logError(e.getMessage(), (Throwable)e);
            }
        }
        return password;
    }

    private SecureStore getSecureStore(String host, String username) {
        return new SecureStore((SecureStore.IStoreKey)new OpenShiftSecureStorageKey(SECURE_STORAGE_BASEKEY, host, username));
    }

    public String getId() {
        StringBuilder builder = new StringBuilder(this.username);
        builder.append(" at ").append(this.getHost());
        if (this.isDefaultHost()) {
            builder.append(" (default)");
        }
        return builder.toString();
    }

    public boolean canConnect() throws IOException {
        HttpURLConnection connection = null;
        try {
            connection = (HttpURLConnection)new URL(String.valueOf(this.getHost()) + "/broker/rest/api").openConnection();
            connection.setConnectTimeout(2000);
            connection.setInstanceFollowRedirects(true);
            connection.setRequestProperty("Accept", "application/json");
            InputStream in = connection.getInputStream();
            StreamUtils.readToString((InputStream)in);
            boolean bl = connection.getResponseCode() == 200;
            return bl;
        }
        catch (MalformedURLException malformedURLException) {
            return false;
        }
        catch (SocketTimeoutException e) {
            throw e;
        }
        catch (IOException e) {
            if (connection != null && connection.getResponseCode() != -1) {
                return false;
            }
            throw e;
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    public IConnection clone() {
        return new ExpressConnection(this.getUsername(), this.getPassword(), this.getScheme(), this.getHost(), this.isRememberPassword(), null, this.sslCallback);
    }

    public void update(IConnection connection) {
        Assert.isLegal((boolean)(connection instanceof ExpressConnection));
        ExpressConnection otherConnection = (ExpressConnection)connection;
        this.setUsername(otherConnection.getUsername());
        this.setPassword(otherConnection.getPassword());
        this.setRememberPassword(otherConnection.isRememberPassword());
        this.setUser(otherConnection.user);
        this.sslCallback = otherConnection.sslCallback;
    }

    public ConnectionType getType() {
        return ConnectionType.Express;
    }

    public String toString() {
        return ExpressResourceLabelUtils.toString(this);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof ExpressConnection)) {
            return false;
        }
        ExpressConnection other = (ExpressConnection)((Object)obj);
        if (this.password == null ? other.password != null : !this.password.equals(other.password)) {
            return false;
        }
        return !(this.username == null ? other.username != null : !this.username.equals(other.username));
    }
}

