/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.core.cartridges;

import com.openshift.client.ApplicationScale;
import com.openshift.client.IApplication;
import com.openshift.client.OpenShiftException;
import com.openshift.client.cartridge.ICartridge;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.openshift.common.core.utils.StringUtils;
import org.jboss.tools.openshift.express.internal.core.util.CartridgeToStringConverter;

public class EmbedCartridgeStrategy {
    private final ApplicationRequirement[] applicationRequirements = new ApplicationRequirement[]{new JBossApplicationRequirement(new EmbeddableCartridgeSelector("switchyard")), new NonScalableApplicationRequirement(new EmbeddableCartridgeSelector("phpmyadmin"))};
    private final EmbeddableCartridgeRelations[] cartridgeDependencies = new EmbeddableCartridgeRelations[]{new EmbeddableCartridgeRelations(new EmbeddableCartridgeSelector("jenkins-client"), null, null, new CartridgeSelector("jenkins")), new EmbeddableCartridgeRelations(new EmbeddableCartridgeSelector("phpmyadmin"), null, new EmbeddableCartridgeSelector("mysql"), null), new EmbeddableCartridgeRelations(new EmbeddableCartridgeSelector("rockmongo"), null, new EmbeddableCartridgeSelector("mongodb"), null), new EmbeddableCartridgeRelations(new EmbeddableCartridgeSelector("10gen-mms-agent"), null, new EmbeddableCartridgeSelector("mongodb"), null)};
    private Map<ICartridge, EmbeddableCartridgeRelations> dependenciesByCartridge;
    private HashMap<ICartridge, Set<ICartridge>> dependantsByCartridge;
    private Collection<ICartridge> allEmbeddableCartridges;
    private Collection<ICartridge> allStandaloneCartridges;
    private Collection<IApplication> allApplications;

    public EmbedCartridgeStrategy(Collection<ICartridge> allEmbeddableCartridges, Collection<ICartridge> allStandaloneCartridges, Collection<IApplication> allApplications) {
        this.allEmbeddableCartridges = allEmbeddableCartridges;
        this.allStandaloneCartridges = allStandaloneCartridges;
        this.allApplications = allApplications;
        this.initDependencyMaps(allEmbeddableCartridges, allStandaloneCartridges, this.cartridgeDependencies);
    }

    private void initDependencyMaps(Collection<ICartridge> allEmbeddableCartridges, Collection<ICartridge> allCartridges, EmbeddableCartridgeRelations ... dependencies) {
        this.dependenciesByCartridge = new HashMap<ICartridge, EmbeddableCartridgeRelations>();
        this.dependantsByCartridge = new HashMap();
        EmbeddableCartridgeRelations[] embeddableCartridgeRelationsArray = dependencies;
        int n = dependencies.length;
        int n2 = 0;
        while (n2 < n) {
            EmbeddableCartridgeRelations dependency = embeddableCartridgeRelationsArray[n2];
            this.createDependency(allEmbeddableCartridges, dependency);
            this.createDependants(allEmbeddableCartridges, dependency);
            ++n2;
        }
    }

    protected void createDependants(Collection<ICartridge> allEmbeddableCartridges, EmbeddableCartridgeRelations dependency) {
        ICartridge dependantCartridge;
        Set<ICartridge> dependants = this.dependantsByCartridge.get(dependency.getRequired(allEmbeddableCartridges));
        if (dependants == null && (dependantCartridge = dependency.getRequired(allEmbeddableCartridges)) != null) {
            dependants = new HashSet<ICartridge>();
            this.dependantsByCartridge.put(dependantCartridge, dependants);
        }
        if (dependants != null) {
            dependants.add(dependency.getSubject(allEmbeddableCartridges));
        }
    }

    protected void createDependency(Collection<ICartridge> allEmbeddableCartridges, EmbeddableCartridgeRelations dependency) {
        ICartridge requiringCartridge = dependency.getSubject(allEmbeddableCartridges);
        this.dependenciesByCartridge.put(requiringCartridge, dependency);
    }

    public ApplicationRequirement getMissingRequirement(ICartridge requestedCartridge, IApplicationProperties application) {
        ApplicationRequirement[] applicationRequirementArray = this.applicationRequirements;
        int n = this.applicationRequirements.length;
        int n2 = 0;
        while (n2 < n) {
            ApplicationRequirement requirement = applicationRequirementArray[n2];
            if (requirement.isForCartridge(requestedCartridge) && !requirement.meetsRequirements(application)) {
                return requirement;
            }
            ++n2;
        }
        return null;
    }

    public EmbeddableCartridgeDiff add(ICartridge cartridge, Set<ICartridge> currentCartridges) throws OpenShiftException {
        EmbeddableCartridgeDiff cartridgeDiff = new EmbeddableCartridgeDiff(cartridge);
        this.add(cartridge, currentCartridges, cartridgeDiff, this.allEmbeddableCartridges, this.allStandaloneCartridges, this.allApplications);
        return cartridgeDiff;
    }

    private void add(ICartridge cartridge, Set<ICartridge> currentCartridges, EmbeddableCartridgeDiff diff, Collection<ICartridge> allEmbeddableCartridges, Collection<ICartridge> allStandaloneCartridges, Collection<IApplication> allApplications) throws OpenShiftException {
        EmbeddableCartridgeRelations relation = this.dependenciesByCartridge.get(cartridge);
        if (relation == null) {
            return;
        }
        this.removeConflicting(currentCartridges, diff, relation, allEmbeddableCartridges);
        this.addRequired(currentCartridges, diff, relation.getRequired(allEmbeddableCartridges), allEmbeddableCartridges);
        this.addRequiredApplication(diff, relation, allStandaloneCartridges, allApplications);
    }

    private void addRequired(Set<ICartridge> currentCartridges, EmbeddableCartridgeDiff diff, ICartridge requiredCartridge, Collection<ICartridge> allEmbeddableCartridges) throws OpenShiftException {
        if (requiredCartridge != null && !currentCartridges.contains(requiredCartridge)) {
            this.add(requiredCartridge, currentCartridges, diff, allEmbeddableCartridges, this.allStandaloneCartridges, this.allApplications);
            diff.addAddition(requiredCartridge);
        }
    }

    private void addRequiredApplication(EmbeddableCartridgeDiff diff, EmbeddableCartridgeRelations relation, Collection<ICartridge> allStandaloneCartridges, Collection<IApplication> allApplications) throws OpenShiftException {
        ICartridge requiredCartridge = relation.getRequiredApplication(allStandaloneCartridges);
        if (requiredCartridge != null && !this.containsApplicationByCartridge(requiredCartridge, allApplications)) {
            diff.addApplicationAddition(requiredCartridge);
        }
    }

    private boolean containsApplicationByCartridge(ICartridge cartridge, Collection<IApplication> applications) {
        for (IApplication application : applications) {
            if (!cartridge.equals(application.getCartridge())) continue;
            return true;
        }
        return false;
    }

    private void removeConflicting(Set<ICartridge> currentCartridges, EmbeddableCartridgeDiff cartridgeDiff, EmbeddableCartridgeRelations relation, Collection<ICartridge> allEmbeddableCartridges) throws OpenShiftException {
        ICartridge conflictingCartridge = relation.getConflicting(allEmbeddableCartridges);
        if (conflictingCartridge != null) {
            this.remove(conflictingCartridge, currentCartridges, cartridgeDiff);
            if (currentCartridges.contains(conflictingCartridge)) {
                cartridgeDiff.addRemoval(conflictingCartridge);
            }
        }
    }

    public EmbeddableCartridgeDiff remove(ICartridge cartridge, Set<ICartridge> currentCartridges) throws OpenShiftException {
        EmbeddableCartridgeDiff cartridgeDiff = new EmbeddableCartridgeDiff(cartridge);
        this.remove(cartridge, currentCartridges, cartridgeDiff);
        return cartridgeDiff;
    }

    private void remove(ICartridge cartridge, Set<ICartridge> currentCartridges, EmbeddableCartridgeDiff cartridgeDiff) throws OpenShiftException {
        Set<ICartridge> dependantCartridges = this.dependantsByCartridge.get(cartridge);
        if (dependantCartridges == null) {
            return;
        }
        for (ICartridge dependantCartridge : dependantCartridges) {
            if (!currentCartridges.contains(dependantCartridge)) continue;
            this.remove(dependantCartridge, currentCartridges, cartridgeDiff);
            cartridgeDiff.addRemoval(dependantCartridge);
        }
    }

    public static abstract class ApplicationRequirement {
        private EmbeddableCartridgeSelector cartridge;

        protected ApplicationRequirement(EmbeddableCartridgeSelector cartridgeSelector) {
            this.cartridge = cartridgeSelector;
        }

        public boolean isForCartridge(ICartridge requestedCartridge) {
            return this.cartridge.matches(requestedCartridge);
        }

        public String getCartridgeName() {
            return this.cartridge.getName();
        }

        protected abstract boolean meetsRequirements(IApplicationProperties var1);

        public abstract String getMessage(ICartridge var1, IApplicationProperties var2);
    }

    private static class CartridgeSelector {
        private String nameStartsWith;

        private CartridgeSelector(String nameStartsWith) {
            this.nameStartsWith = nameStartsWith;
        }

        public ICartridge getCartridge(Collection<ICartridge> cartridges) {
            if (cartridges == null || cartridges.isEmpty()) {
                return null;
            }
            for (ICartridge cartridge : cartridges) {
                if (!this.isMatching(cartridge)) continue;
                return cartridge;
            }
            return null;
        }

        public boolean isMatching(ICartridge cartridge) {
            return cartridge != null && cartridge.getName() != null && cartridge.getName().startsWith(this.nameStartsWith);
        }

        public String getName() {
            return this.nameStartsWith;
        }
    }

    public static class EmbeddableCartridgeDiff {
        private List<ICartridge> removals;
        private List<ICartridge> additions;
        private List<ICartridge> applicationAdditions;
        private ICartridge cartridge;

        protected EmbeddableCartridgeDiff(ICartridge cartridge) {
            this.cartridge = cartridge;
            this.removals = new ArrayList<ICartridge>();
            this.additions = new ArrayList<ICartridge>();
            this.applicationAdditions = new ArrayList<ICartridge>();
        }

        public ICartridge getCartridge() {
            return this.cartridge;
        }

        public List<ICartridge> getAdditions() {
            return this.additions;
        }

        public boolean hasAdditions() {
            return this.getAdditions().size() > 0;
        }

        protected void addAddition(ICartridge cartridge) {
            this.additions.add(cartridge);
        }

        public List<ICartridge> getRemovals() {
            return this.removals;
        }

        public boolean hasRemovals() {
            return this.getRemovals().size() > 0;
        }

        protected void addRemoval(ICartridge cartridge) {
            this.removals.add(cartridge);
        }

        protected void addApplicationAddition(ICartridge standaloneCartridge) {
            this.applicationAdditions.add(standaloneCartridge);
        }

        public List<ICartridge> getApplicationAdditions() {
            return this.applicationAdditions;
        }

        public boolean hasApplicationAdditions() {
            return this.getApplicationAdditions().size() > 0;
        }

        public boolean hasChanges() {
            return this.hasApplicationAdditions() || this.hasRemovals() || this.hasAdditions();
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            if (this.hasApplicationAdditions()) {
                builder.append(NLS.bind((String)"- Create {0}", (Object)StringUtils.toString(this.getApplicationAdditions(), (StringUtils.ToStringConverter)new CartridgeToStringConverter())));
            }
            if (this.hasRemovals()) {
                builder.append(NLS.bind((String)"\n- Remove {0}", (Object)StringUtils.toString(this.getRemovals(), (StringUtils.ToStringConverter)new CartridgeToStringConverter())));
            }
            if (this.hasAdditions()) {
                builder.append(NLS.bind((String)"\n- Add {0}", (Object)StringUtils.toString(this.getAdditions(), (StringUtils.ToStringConverter)new CartridgeToStringConverter())));
            }
            return builder.toString();
        }
    }

    private static class EmbeddableCartridgeRelations {
        private EmbeddableCartridgeSelector subject;
        private EmbeddableCartridgeSelector conflicting;
        private EmbeddableCartridgeSelector required;
        private CartridgeSelector requiredApplication;

        protected EmbeddableCartridgeRelations(EmbeddableCartridgeSelector cartridgeSelector, EmbeddableCartridgeSelector conflicting, EmbeddableCartridgeSelector required, CartridgeSelector requiredApplication) {
            this.subject = cartridgeSelector;
            this.conflicting = conflicting;
            this.required = required;
            this.requiredApplication = requiredApplication;
        }

        protected ICartridge getSubject(Collection<ICartridge> allEmbeddableCartridges) {
            return this.subject.getCartridge(allEmbeddableCartridges);
        }

        protected ICartridge getConflicting(Collection<ICartridge> allEmbeddableCartridges) {
            if (this.conflicting == null) {
                return null;
            }
            return this.conflicting.getCartridge(allEmbeddableCartridges);
        }

        protected ICartridge getRequired(Collection<ICartridge> allEmbeddableCartridges) {
            if (this.required == null) {
                return null;
            }
            return this.required.getCartridge(allEmbeddableCartridges);
        }

        protected ICartridge getRequiredApplication(Collection<ICartridge> allCartridges) {
            if (this.requiredApplication == null) {
                return null;
            }
            return this.requiredApplication.getCartridge(allCartridges);
        }
    }

    private static class EmbeddableCartridgeSelector {
        private String nameStartsWith;

        private EmbeddableCartridgeSelector(String nameStartsWith) {
            this.nameStartsWith = nameStartsWith;
        }

        public ICartridge getCartridge(Collection<ICartridge> embeddableCartridges) {
            if (embeddableCartridges == null || embeddableCartridges.isEmpty()) {
                return null;
            }
            for (ICartridge cartridge : embeddableCartridges) {
                if (!this.matches(cartridge)) continue;
                return cartridge;
            }
            return null;
        }

        private boolean matches(ICartridge cartridge) {
            return cartridge.getName() != null && cartridge.getName().startsWith(this.nameStartsWith);
        }

        public String getName() {
            return this.nameStartsWith;
        }
    }

    public static interface IApplicationProperties {
        public ApplicationScale getApplicationScale();

        public ICartridge getStandaloneCartridge();

        public String getApplicationName();
    }

    private static class JBossApplicationRequirement
    extends ApplicationRequirement {
        private CartridgeSelector eapSelector = new CartridgeSelector("jbosseap");
        private CartridgeSelector asSelector = new CartridgeSelector("jbossas");

        protected JBossApplicationRequirement(EmbeddableCartridgeSelector cartridgeSelector) {
            super(cartridgeSelector);
        }

        @Override
        protected boolean meetsRequirements(IApplicationProperties application) {
            ICartridge standaloneCartridge = application.getStandaloneCartridge();
            return this.eapSelector.isMatching(standaloneCartridge) || this.asSelector.isMatching(standaloneCartridge);
        }

        @Override
        public String getMessage(ICartridge requestedCartridge, IApplicationProperties application) {
            ICartridge standaloneCartridge = application.getStandaloneCartridge();
            return NLS.bind((String)"It is not recommended to add cartridge {0} to your application {1}. The cartridge requires a {3} or {4} application and your application is a {2}.", (Object[])new String[]{requestedCartridge.getName(), application.getApplicationName(), standaloneCartridge == null ? "'unknwon'" : standaloneCartridge.getName(), this.eapSelector.getName(), this.asSelector.getName()});
        }
    }

    private static class NonScalableApplicationRequirement
    extends ApplicationRequirement {
        protected NonScalableApplicationRequirement(EmbeddableCartridgeSelector cartridgeSelector) {
            super(cartridgeSelector);
        }

        @Override
        protected boolean meetsRequirements(IApplicationProperties application) {
            ApplicationScale scale = application.getApplicationScale();
            return scale == ApplicationScale.NO_SCALE || scale == null;
        }

        @Override
        public String getMessage(ICartridge requestedCartridge, IApplicationProperties application) {
            return NLS.bind((String)"It is not recommended to add cartridge {0} to your application {1}. The cartridge cannot scale and requires a non-scalable application. Your application is scalable.", (Object)requestedCartridge.getName(), (Object)application.getApplicationName());
        }
    }
}

