/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.core;

import com.openshift.client.IHttpClient;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLSession;
import org.jboss.tools.openshift.express.core.ExpressCoreUIIntegration;

public class LazySSLCertificateCallback
implements IHttpClient.ISSLCertificateCallback {
    private IHttpClient.ISSLCertificateCallback callback;

    public LazySSLCertificateCallback(IHttpClient.ISSLCertificateCallback callback) {
        if (callback instanceof LazySSLCertificateCallback) {
            throw new IllegalArgumentException("Unable to initialize a LazySSLCertificateCallback with instance of the same type");
        }
        this.callback = callback;
    }

    public boolean allowCertificate(X509Certificate[] certs) {
        if (!this.loadCallback()) {
            return false;
        }
        return this.callback.allowCertificate(certs);
    }

    public boolean allowHostname(String hostname, SSLSession session) {
        if (!this.loadCallback()) {
            return false;
        }
        return this.callback.allowHostname(hostname, session);
    }

    private boolean loadCallback() {
        if (this.callback == null) {
            this.callback = ExpressCoreUIIntegration.getDefault().getSSLCertificateCallback();
            if (this.callback == null) {
                return false;
            }
        }
        return true;
    }
}

