/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.text.xml;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextHoverExtension;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.information.IInformationProvider;
import org.eclipse.jface.text.quickassist.IQuickAssistAssistant;
import org.eclipse.jface.text.quickassist.IQuickAssistProcessor;
import org.eclipse.jface.text.quickassist.QuickAssistAssistant;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.sse.ui.StructuredTextViewerConfiguration;
import org.eclipse.wst.sse.ui.contentassist.CompletionProposalInvocationContext;
import org.eclipse.wst.sse.ui.internal.ExtendedConfigurationBuilder;
import org.eclipse.wst.sse.ui.internal.SSEUIPlugin;
import org.eclipse.wst.sse.ui.internal.derived.HTMLTextPresenter;
import org.eclipse.wst.sse.ui.internal.taginfo.AnnotationHoverProcessor;
import org.eclipse.wst.sse.ui.internal.taginfo.TextHoverManager;
import org.eclipse.wst.sse.ui.internal.util.EditorUtility;
import org.eclipse.wst.xml.ui.StructuredTextViewerConfigurationXML;
import org.eclipse.wst.xml.ui.internal.contentassist.XMLStructuredContentAssistProcessor;
import org.jboss.tools.common.text.xml.BaseQuickAssistProcessor;
import org.jboss.tools.common.text.xml.XmlEditorPlugin;
import org.jboss.tools.common.text.xml.contentassist.ProposalSorter;
import org.jboss.tools.common.text.xml.info.ChainTextHover;
import org.jboss.tools.common.text.xml.info.TextHoverInformationProvider;
import org.jboss.tools.common.text.xml.xpl.MarkerProblemAnnotationHoverProcessor;

public class XMLTextViewerConfiguration
extends StructuredTextViewerConfigurationXML {
    private static final char[] PROPOSAL_AUTO_ACTIVATION_CHARS = new char[]{'<', '=', '\"', '\'', '.', '{', '['};
    SourceViewerConfiguration initial = null;
    private IQuickAssistAssistant fQuickAssistant = null;

    public void setInitialConfiguration(SourceViewerConfiguration initial) {
        this.initial = initial;
    }

    protected IContentAssistProcessor[] getContentAssistProcessors(ISourceViewer sourceViewer, String partitionType) {
        XMLStructuredContentAssistProcessor superProcessor = new XMLStructuredContentAssistProcessor((ContentAssistant)this.getContentAssistant(), partitionType, (ITextViewer)sourceViewer){

            protected List filterAndSortProposals(List proposals, IProgressMonitor monitor, CompletionProposalInvocationContext context) {
                return ProposalSorter.filterAndSortProposals(proposals, monitor, context);
            }

            public char[] getCompletionProposalAutoActivationCharacters() {
                char[] superAutoActivationCharacters = super.getCompletionProposalAutoActivationCharacters();
                if (superAutoActivationCharacters == null) {
                    return PROPOSAL_AUTO_ACTIVATION_CHARS;
                }
                String chars = new String(superAutoActivationCharacters);
                char[] cArray = PROPOSAL_AUTO_ACTIVATION_CHARS;
                int n = cArray.length;
                int n2 = 0;
                while (n2 < n) {
                    char ch = cArray[n2];
                    if (chars.indexOf(ch) == -1) {
                        chars = String.valueOf(chars) + ch;
                    }
                    ++n2;
                }
                return chars.toCharArray();
            }
        };
        ArrayList<1> processors = new ArrayList<1>();
        processors.add(superProcessor);
        return processors.toArray(new IContentAssistProcessor[0]);
    }

    public IHyperlinkDetector[] getHyperlinkDetectors(ISourceViewer sourceViewer) {
        IHyperlinkDetector[] superDetectors;
        if (!this.fPreferenceStore.getBoolean("hyperlinksEnabled")) {
            return null;
        }
        ArrayList<IHyperlinkDetector> allDetectors = new ArrayList<IHyperlinkDetector>(0);
        IHyperlinkDetector extHyperlinkDetector = this.getTextEditorsExtensionsHyperlinkDetector();
        if (extHyperlinkDetector != null) {
            allDetectors.add(extHyperlinkDetector);
        }
        if ((superDetectors = super.getHyperlinkDetectors(sourceViewer)) != null) {
            IHyperlinkDetector[] iHyperlinkDetectorArray = superDetectors;
            int n = superDetectors.length;
            int n2 = 0;
            while (n2 < n) {
                IHyperlinkDetector detector = iHyperlinkDetectorArray[n2];
                if (!allDetectors.contains(detector)) {
                    allDetectors.add(detector);
                }
                ++n2;
            }
        }
        return allDetectors.toArray(new IHyperlinkDetector[0]);
    }

    private IHyperlinkDetector getTextEditorsExtensionsHyperlinkDetector() {
        Plugin plugin = Platform.getPlugin((String)"org.jboss.tools.common.text.ext");
        return plugin != null && plugin instanceof IAdaptable ? (IHyperlinkDetector)((IAdaptable)plugin).getAdapter(IHyperlinkDetector.class) : null;
    }

    IContentAssistProcessor[] getInitialProcessors(ISourceViewer sourceViewer, String partitionType) {
        Method m;
        block7: {
            if (this.initial == null) {
                return null;
            }
            if (!(this.initial instanceof StructuredTextViewerConfiguration)) {
                return null;
            }
            m = this.findDeclaredMethod(this.initial.getClass(), "getContentAssistProcessors", new Class[]{ISourceViewer.class, String.class});
            if (m != null) break block7;
            return null;
        }
        try {
            m.setAccessible(true);
            return (IContentAssistProcessor[])m.invoke((Object)this.initial, sourceViewer, partitionType);
        }
        catch (IllegalArgumentException e) {
            XmlEditorPlugin.getPluginLog().logError((Throwable)e);
        }
        catch (IllegalAccessException e) {
            XmlEditorPlugin.getPluginLog().logError((Throwable)e);
        }
        catch (InvocationTargetException e) {
            XmlEditorPlugin.getPluginLog().logError((Throwable)e);
        }
        return null;
    }

    private Method findDeclaredMethod(Class cls, String name, Class[] paramTypes) {
        Class sc;
        Method[] ms = cls.getDeclaredMethods();
        if (ms != null) {
            int i = 0;
            while (i < ms.length) {
                Class<?>[] ps;
                if (ms[i].getName().equals(name) && (ps = ms[i].getParameterTypes()) != null && ps.length == paramTypes.length) {
                    boolean equal = true;
                    int j = 0;
                    while (j < ps.length && equal) {
                        if (!ps[j].getName().equals(paramTypes[j].getName())) {
                            equal = false;
                        }
                        ++j;
                    }
                    if (equal) {
                        return ms[i];
                    }
                }
                ++i;
            }
        }
        if ((sc = cls.getSuperclass()) == null || sc == Object.class) {
            return null;
        }
        return this.findDeclaredMethod(sc, name, paramTypes);
    }

    private ITextHover[] createDocumentationHovers(String partitionType) {
        List extendedTextHover = ExtendedConfigurationBuilder.getInstance().getConfigurations("documentationTextHover", partitionType);
        return extendedTextHover.toArray(new ITextHover[extendedTextHover.size()]);
    }

    protected IInformationProvider getInformationProvider(ISourceViewer sourceViewer, String partitionType) {
        ITextHover[] hovers = this.createDocumentationHovers(partitionType);
        return new TextHoverInformationProvider(new ChainTextHover(hovers));
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType, int stateMask) {
        ITextHoverExtension textHover = null;
        TextHoverManager.TextHoverDescriptor[] hoverDescs = SSEUIPlugin.getDefault().getTextHoverManager().getTextHovers();
        int i = 0;
        while (i < hoverDescs.length && textHover == null) {
            if (hoverDescs[i].isEnabled() && XMLTextViewerConfiguration.computeStateMask((String)hoverDescs[i].getModifierString()) == stateMask) {
                ITextHover[] hovers;
                String hoverType = hoverDescs[i].getId();
                if ("problemHover".equalsIgnoreCase(hoverType)) {
                    textHover = new MarkerProblemAnnotationHoverProcessor();
                } else if ("annotationHover".equalsIgnoreCase(hoverType)) {
                    textHover = new AnnotationHoverProcessor();
                } else if ("combinationHover".equalsIgnoreCase(hoverType)) {
                    textHover = new ChainTextHover(this.createDocumentationHovers(contentType));
                } else if ("documentationHover".equalsIgnoreCase(hoverType) && (hovers = this.createDocumentationHovers(contentType)).length > 0) {
                    textHover = hovers[0];
                }
            }
            ++i;
        }
        return textHover;
    }

    private Color getColor(String key) {
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)this.fPreferenceStore, (String)key);
        return EditorUtility.getColor((RGB)rgb);
    }

    public IQuickAssistAssistant getQuickAssistAssistant(ISourceViewer sourceViewer) {
        if (this.fQuickAssistant == null) {
            QuickAssistAssistant assistant = new QuickAssistAssistant();
            assistant.setQuickAssistProcessor((IQuickAssistProcessor)new BaseQuickAssistProcessor());
            assistant.setInformationControlCreator(this.getQuickAssistAssistantInformationControlCreator());
            if (this.fPreferenceStore != null) {
                Color color = this.getColor("content_assist_proposals_background");
                assistant.setProposalSelectorBackground(color);
                color = this.getColor("content_assist_proposals_foreground");
                assistant.setProposalSelectorForeground(color);
            }
            this.fQuickAssistant = assistant;
        }
        return this.fQuickAssistant;
    }

    private IInformationControlCreator getQuickAssistAssistantInformationControlCreator() {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                return new DefaultInformationControl(parent, (DefaultInformationControl.IInformationPresenter)new HTMLTextPresenter(true));
            }
        };
    }
}

