/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.util;

import java.util.IdentityHashMap;
import java.util.Map;

public final class IdentityCache<K, V> {
    private Map<K, V> map = new IdentityHashMap();
    private Map<K, V> next = null;

    public synchronized V get(K key) {
        V value = this.map.get(key);
        if (this.next != null && value != null) {
            this.next.put(key, value);
        }
        return value;
    }

    public synchronized void put(K key, V value) {
        if (value == null) {
            throw new IllegalArgumentException();
        }
        if (this.next != null) {
            this.next.put(key, value);
        }
        this.map.put(key, value);
    }

    public synchronized void track() {
        this.next = new IdentityHashMap();
    }

    public synchronized void purge() {
        if (this.next == null) {
            throw new IllegalStateException();
        }
        this.map = this.next;
        this.next = null;
    }
}

