/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.services.internal;

import java.util.List;
import java.util.SortedSet;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.PropertyDef;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.annotations.Documentation;
import org.eclipse.sapphire.modeling.annotations.DocumentationMergeStrategy;
import org.eclipse.sapphire.modeling.localization.LocalizationService;
import org.eclipse.sapphire.services.DocumentationService;
import org.eclipse.sapphire.services.FactsAggregationService;
import org.eclipse.sapphire.services.ServiceCondition;
import org.eclipse.sapphire.services.ServiceContext;
import org.eclipse.sapphire.services.internal.StandardDocumentationService;

public final class StandardPropertyDocumentationService
extends StandardDocumentationService {
    @Override
    protected void initStandardDocumentationService(StringBuilder content, List<DocumentationService.Topic> topics) {
        Property property = this.context(Property.class);
        StandardPropertyDocumentationService.init(property.definition(), content, topics);
        SortedSet<String> facts = property.service(FactsAggregationService.class).facts();
        if (!facts.isEmpty()) {
            if (content.length() > 0) {
                content.append("[pbr/]");
            }
            boolean first = true;
            for (String item : facts) {
                if (first) {
                    first = false;
                } else {
                    content.append("[br/]");
                }
                content.append(item);
            }
        }
    }

    private static void init(PropertyDef property, StringBuilder content, List<DocumentationService.Topic> topics) {
        if (property == null) {
            return;
        }
        Documentation docAnnotation = property.getAnnotation(Documentation.class);
        if (docAnnotation == null || docAnnotation.mergeStrategy() != DocumentationMergeStrategy.REPLACE) {
            StandardPropertyDocumentationService.init(property.getBase(), content, topics);
        }
        if (docAnnotation != null) {
            List<DocumentationService.Topic> docAnnotationTopics;
            LocalizationService localization = property.getLocalizationService();
            DocumentationMergeStrategy docMergeStrategy = docAnnotation.mergeStrategy();
            String docAnnotationContent = localization.text(docAnnotation.content().trim(), CapitalizationType.NO_CAPS, false);
            if (docAnnotationContent.length() > 0) {
                if (docMergeStrategy == DocumentationMergeStrategy.REPLACE || content.length() == 0) {
                    content.append(docAnnotationContent);
                } else if (docMergeStrategy == DocumentationMergeStrategy.APPEND) {
                    content.append("[pbr/]");
                    content.append(docAnnotationContent);
                } else {
                    content.insert(0, "[pbr/]");
                    content.insert(0, docAnnotationContent);
                }
            }
            if (!(docAnnotationTopics = StandardPropertyDocumentationService.convert(docAnnotation.topics(), localization)).isEmpty()) {
                if (docMergeStrategy != DocumentationMergeStrategy.PREPEND || topics.isEmpty()) {
                    topics.addAll(docAnnotationTopics);
                } else {
                    topics.addAll(0, docAnnotationTopics);
                }
            }
        }
    }

    public static final class Condition
    extends ServiceCondition {
        @Override
        public boolean applicable(ServiceContext context) {
            Property property = context.find(Property.class);
            PropertyDef p = property.definition();
            while (p != null) {
                if (p.hasAnnotation(Documentation.class)) {
                    return true;
                }
                p = p.getBase();
            }
            return !property.service(FactsAggregationService.class).facts().isEmpty();
        }
    }
}

