/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.internal;

import java.io.InputStream;
import java.io.StringReader;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.sapphire.Context;
import org.eclipse.sapphire.LoggingService;
import org.eclipse.sapphire.Result;
import org.eclipse.sapphire.Sapphire;
import org.eclipse.sapphire.modeling.ExtensionsLocator;
import org.eclipse.sapphire.modeling.el.Function;
import org.eclipse.sapphire.services.Service;
import org.eclipse.sapphire.services.ServiceCondition;
import org.eclipse.sapphire.util.ListFactory;
import org.eclipse.sapphire.util.SetFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public final class SapphireModelingExtensionSystem {
    private static final String EL_CONDITION = "condition";
    private static final String EL_CONTEXT = "context";
    private static final String EL_FUNCTION = "function";
    private static final String EL_ID = "id";
    private static final String EL_IMPL = "impl";
    private static final String EL_IMPLEMENTATION = "implementation";
    private static final String EL_NAME = "name";
    private static final String EL_OVERRIDES = "overrides";
    private static final String EL_PARAMETER = "parameter";
    private static final String EL_SERVICE = "service";
    private static final String EL_SIGNATURE = "signature";
    private static boolean initialized = false;
    private static List<ServiceExtension> serviceExtensions;
    private static Map<String, List<FunctionFactory>> functionFactories;

    public static List<ServiceExtension> services() {
        SapphireModelingExtensionSystem.initialize();
        return serviceExtensions;
    }

    public static List<Function> functions(String name, int arity) {
        SapphireModelingExtensionSystem.initialize();
        List<FunctionFactory> factories = functionFactories.get(name.toLowerCase());
        ListFactory<Function> functions = ListFactory.start();
        if (factories != null) {
            for (FunctionFactory factory : factories) {
                if (factory.signature() != null && factory.signature().size() != arity) continue;
                functions.add(factory.create());
            }
        }
        return functions.result();
    }

    private static synchronized void initialize() {
        if (!initialized) {
            initialized = true;
            functionFactories = new HashMap<String, List<FunctionFactory>>();
            ListFactory<ServiceExtension> serviceExtensionsFactory = ListFactory.start();
            for (ExtensionsLocator.Handle handle : ExtensionsLocator.instance().find()) {
                Element root = SapphireModelingExtensionSystem.parse(handle.extension());
                if (root == null) continue;
                NodeList nodes = root.getChildNodes();
                Context context = handle.context();
                int i = 0;
                int n = nodes.getLength();
                while (i < n) {
                    block15: {
                        Node node = nodes.item(i);
                        if (node instanceof Element) {
                            Element el = (Element)node;
                            String elname = el.getLocalName();
                            try {
                                List<Class<?>> signature;
                                if (elname.equals(EL_SERVICE)) {
                                    String id = SapphireModelingExtensionSystem.value(el, EL_ID).required();
                                    Set<String> contexts = SetFactory.unmodifiable(SapphireModelingExtensionSystem.values(el, EL_CONTEXT));
                                    Set<String> overrides = SetFactory.unmodifiable(SapphireModelingExtensionSystem.values(el, EL_OVERRIDES));
                                    Class implementation = context.findClass(SapphireModelingExtensionSystem.value(el, EL_IMPLEMENTATION).required());
                                    String conditionClassName = SapphireModelingExtensionSystem.value(el, EL_CONDITION).optional();
                                    Class condition = null;
                                    if (conditionClassName != null) {
                                        condition = context.findClass(conditionClassName);
                                    }
                                    if (implementation != null) {
                                        serviceExtensionsFactory.add(new ServiceExtension(id, implementation, condition, contexts, overrides));
                                    }
                                    break block15;
                                }
                                if (!elname.equals(EL_FUNCTION)) break block15;
                                String name = SapphireModelingExtensionSystem.value(el, EL_NAME).required().toLowerCase();
                                Class impl = context.findClass(SapphireModelingExtensionSystem.value(el, EL_IMPL).required());
                                Element signatureElement = SapphireModelingExtensionSystem.element(el, EL_SIGNATURE).optional();
                                if (signatureElement == null) {
                                    signature = null;
                                } else {
                                    ListFactory parameters = ListFactory.start();
                                    for (String string : SapphireModelingExtensionSystem.values(signatureElement, EL_PARAMETER)) {
                                        Class parameter;
                                        try {
                                            parameter = context.findClass(string);
                                        }
                                        catch (IllegalArgumentException illegalArgumentException) {
                                            throw new InvalidExtensionException();
                                        }
                                        if (parameter == null) {
                                            throw new InvalidExtensionException();
                                        }
                                        parameters.add(parameter);
                                    }
                                    signature = parameters.result();
                                }
                                ListFactory<FunctionFactory> factories = ListFactory.start();
                                factories.add((Collection)functionFactories.get(name));
                                factories.add(new FunctionFactory(impl, signature));
                                functionFactories.put(name, factories.result());
                            }
                            catch (InvalidExtensionException invalidExtensionException) {}
                        }
                    }
                    ++i;
                }
            }
            serviceExtensions = serviceExtensionsFactory.result();
        }
    }

    private static Element parse(URL url) {
        try {
            Throwable throwable = null;
            Object var2_3 = null;
            try (InputStream in = url.openStream();){
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                factory.setValidating(false);
                factory.setNamespaceAware(true);
                factory.setIgnoringComments(false);
                DocumentBuilder docbuilder = factory.newDocumentBuilder();
                docbuilder.setEntityResolver(new EntityResolver(){

                    @Override
                    public InputSource resolveEntity(String publicID, String systemID) {
                        return new InputSource(new StringReader(""));
                    }
                });
                Document document = docbuilder.parse(in);
                return document.getDocumentElement();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static String value(Element element) {
        StringBuilder buf = new StringBuilder();
        NodeList nodes = element.getChildNodes();
        int i = 0;
        int n = nodes.getLength();
        while (i < n) {
            Node node = nodes.item(i);
            if (node instanceof Text) {
                buf.append(((Text)node).getData());
            }
            ++i;
        }
        return buf.toString().trim();
    }

    private static Result<String> value(Element element, String valueElementName) {
        Element el = SapphireModelingExtensionSystem.element(element, valueElementName).optional();
        if (el != null) {
            return Result.success(SapphireModelingExtensionSystem.value(el));
        }
        return Result.failure(new InvalidExtensionException());
    }

    private static List<String> values(Element root, String entryElementName) {
        ListFactory<String> factory = ListFactory.start();
        NodeList nodes = root.getChildNodes();
        int i = 0;
        int n = nodes.getLength();
        while (i < n) {
            String text;
            Node node = nodes.item(i);
            if (node instanceof Element && node.getLocalName().equals(entryElementName) && (text = SapphireModelingExtensionSystem.value((Element)node)).length() > 0) {
                factory.add(text);
            }
            ++i;
        }
        return factory.result();
    }

    private static Result<Element> element(Element element, String childElementName) {
        NodeList nodes = element.getChildNodes();
        int i = 0;
        int n = nodes.getLength();
        while (i < n) {
            Element el;
            Node node = nodes.item(i);
            if (node instanceof Element && childElementName.equals((el = (Element)node).getLocalName())) {
                return Result.success(el);
            }
            ++i;
        }
        return Result.failure(new InvalidExtensionException());
    }

    private static final class FunctionFactory {
        private final Class<? extends Function> functionClass;
        private boolean functionInstantiationFailed;
        private final List<Class<?>> signature;

        public FunctionFactory(Class<? extends Function> functionClass, List<Class<?>> signature) {
            this.functionClass = functionClass;
            this.signature = signature;
        }

        public List<Class<?>> signature() {
            return this.signature;
        }

        public Function create() {
            Function function = null;
            if (!this.functionInstantiationFailed) {
                try {
                    function = this.functionClass.newInstance();
                    function.initSignature(this.signature);
                }
                catch (Exception e) {
                    Sapphire.service(LoggingService.class).log(e);
                    function = null;
                    this.functionInstantiationFailed = true;
                }
            }
            return function;
        }
    }

    public static final class InvalidExtensionException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
    }

    public static final class ServiceExtension {
        private final String id;
        private final Class<? extends Service> implementation;
        private final Class<? extends ServiceCondition> condition;
        private final Set<String> contexts;
        private final Set<String> overrides;

        public ServiceExtension(String id, Class<? extends Service> implementation, Class<? extends ServiceCondition> condition, Set<String> contexts, Set<String> overrides) {
            this.id = id;
            this.implementation = implementation;
            this.condition = condition;
            this.contexts = contexts;
            this.overrides = overrides;
        }

        public String id() {
            return this.id;
        }

        public Class<? extends Service> implementation() {
            return this.implementation;
        }

        public Class<? extends ServiceCondition> condition() {
            return this.condition;
        }

        public Set<String> contexts() {
            return this.contexts;
        }

        public Set<String> overrides() {
            return this.overrides;
        }
    }
}

