/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.internal;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.eclipse.sapphire.ConversionException;
import org.eclipse.sapphire.ConversionService;
import org.eclipse.sapphire.Serialization;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.services.ServiceCondition;
import org.eclipse.sapphire.services.ServiceContext;
import org.eclipse.sapphire.util.ListFactory;

public final class StringToDateConversionServiceForProperty
extends ConversionService<String, Date> {
    private List<DateFormat> formats;

    public StringToDateConversionServiceForProperty() {
        super(String.class, Date.class);
    }

    @Override
    protected void init() {
        Serialization serialization = this.context(ValueProperty.class).getAnnotation(Serialization.class);
        ListFactory<SimpleDateFormat> formatsListFactory = ListFactory.start();
        formatsListFactory.add(new SimpleDateFormat(serialization.primary()));
        String[] stringArray = serialization.alternative();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String alternative = stringArray[n2];
            formatsListFactory.add(new SimpleDateFormat(alternative));
            ++n2;
        }
        this.formats = formatsListFactory.result();
    }

    @Override
    public synchronized Date convert(String string) {
        for (DateFormat format : this.formats) {
            try {
                return format.parse(string);
            }
            catch (ParseException parseException) {}
        }
        throw new ConversionException();
    }

    public static final class Condition
    extends ServiceCondition {
        @Override
        public boolean applicable(ServiceContext context) {
            ValueProperty property = context.find(ValueProperty.class);
            return property != null && property.getTypeClass() == Date.class && property.hasAnnotation(Serialization.class);
        }
    }
}

