/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire;

import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.EventDeliveryJob;
import org.eclipse.sapphire.Filter;
import org.eclipse.sapphire.JobQueue;
import org.eclipse.sapphire.Listener;

public final class ListenerContext {
    private static final boolean TRACE = false;
    private final Set<Listener> listeners = new LinkedHashSet<Listener>();
    private final JobQueue<EventDeliveryJob> queue;

    public ListenerContext() {
        this(null);
    }

    public ListenerContext(JobQueue<EventDeliveryJob> queue) {
        this.queue = queue == null ? new JobQueue() : queue;
    }

    public JobQueue<EventDeliveryJob> queue() {
        return this.queue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean attach(Listener listener) {
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        ListenerContext listenerContext = this;
        synchronized (listenerContext) {
            return this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean detach(final Listener listener) {
        boolean removed;
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        ListenerContext listenerContext = this;
        synchronized (listenerContext) {
            removed = this.listeners.remove(listener);
        }
        if (removed) {
            this.queue.prune(new Filter<EventDeliveryJob>(){

                @Override
                public boolean allows(EventDeliveryJob job) {
                    return !job.listener().equals(listener);
                }
            });
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void post(final Event event) {
        if (event == null) {
            throw new IllegalArgumentException();
        }
        this.queue.prune(new Filter<EventDeliveryJob>(){

            @Override
            public boolean allows(EventDeliveryJob job) {
                return !event.supersedes(job.event());
            }
        });
        ListenerContext listenerContext = this;
        synchronized (listenerContext) {
            for (Listener listener : this.listeners) {
                this.queue.add(new EventDeliveryJob(listener, event));
            }
        }
    }

    public void broadcast() {
        this.queue.process();
    }

    public void broadcast(Event event) {
        this.post(event);
        this.broadcast();
    }
}

