/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementProperty;
import org.eclipse.sapphire.ImageData;
import org.eclipse.sapphire.ListProperty;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.LocalizableText;
import org.eclipse.sapphire.LoggingService;
import org.eclipse.sapphire.MasterConversionService;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.PropertyDef;
import org.eclipse.sapphire.Resource;
import org.eclipse.sapphire.Sapphire;
import org.eclipse.sapphire.Text;
import org.eclipse.sapphire.internal.ElementClassLoaders;
import org.eclipse.sapphire.modeling.ModelMetadataItem;
import org.eclipse.sapphire.modeling.ModelPath;
import org.eclipse.sapphire.modeling.annotations.Image;
import org.eclipse.sapphire.modeling.annotations.Listeners;
import org.eclipse.sapphire.modeling.internal.MemoryResource;
import org.eclipse.sapphire.modeling.localization.LocalizationService;
import org.eclipse.sapphire.modeling.localization.LocalizationSystem;
import org.eclipse.sapphire.modeling.localization.LocalizationUtil;
import org.eclipse.sapphire.services.Service;
import org.eclipse.sapphire.services.ServiceContext;
import org.eclipse.sapphire.services.internal.ElementMetaModelServiceContext;
import org.eclipse.sapphire.util.ListFactory;
import org.eclipse.sapphire.util.MapFactory;
import org.eclipse.sapphire.util.SortedSetFactory;

public final class ElementType
extends ModelMetadataItem {
    @Text(value="{0} : Could not instantiate implementation class.")
    private static LocalizableText cannotInstantiate;
    private static final Comparator<PropertyDef> PROPERTY_COMPARATOR;
    private final Class<?> typeClass;
    private Class<?> implClass = null;
    private Constructor<?> implClassConstructor = null;
    private boolean implClassLoaded = false;
    private final List<ElementType> baseTypes;
    private SortedSet<PropertyDef> properties;
    private Map<String, PropertyDef> propertiesByName;
    private final LocalizationService localizationService;
    private ImageData image;
    private boolean imageInitialized;
    private List<Listener> listeners;
    private ServiceContext serviceContext;

    static {
        LocalizableText.init(ElementType.class);
        PROPERTY_COMPARATOR = new Comparator<PropertyDef>(){

            @Override
            public int compare(PropertyDef x, PropertyDef y) {
                return x.name().compareToIgnoreCase(y.name());
            }
        };
    }

    public ElementType(Class<?> typeClass) {
        this.typeClass = typeClass;
        this.localizationService = LocalizationSystem.service(this.typeClass);
        ListFactory<ElementType> baseTypesFactory = ListFactory.start();
        Class<?>[] classArray = this.typeClass.getInterfaces();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> baseInterface = classArray[n2];
            ElementType baseType = ElementType.read(baseInterface, false);
            if (baseType != null) {
                baseTypesFactory.add(baseType);
            }
            ++n2;
        }
        this.baseTypes = baseTypesFactory.result();
    }

    public static ElementType read(ClassLoader classLoader, String qualifiedTypeName) {
        try {
            return ElementType.read(classLoader.loadClass(qualifiedTypeName));
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static ElementType read(Class<?> modelElementClass) {
        return ElementType.read(modelElementClass, true);
    }

    public static ElementType read(Class<?> modelElementClass, boolean throwExceptionIfNotFound) {
        if (modelElementClass == null) {
            throw new IllegalArgumentException();
        }
        Field[] fieldArray = modelElementClass.getFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            if (field.getName().equals("TYPE")) {
                try {
                    Object fieldValue = field.get(null);
                    if (!(fieldValue instanceof ElementType)) break;
                    return (ElementType)fieldValue;
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }
            ++n2;
        }
        if (throwExceptionIfNotFound) {
            throw new IllegalArgumentException("Did not find TYPE field on " + modelElementClass.getName());
        }
        return null;
    }

    public Class<?> getModelElementClass() {
        return this.typeClass;
    }

    public String getSimpleName() {
        return this.typeClass.getSimpleName();
    }

    public String getQualifiedName() {
        return this.typeClass.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends Element> T instantiate(Property property, Resource resource) {
        ElementType elementType = this;
        synchronized (elementType) {
            if (!this.implClassLoaded) {
                this.implClassLoaded = true;
                this.implClass = ElementClassLoaders.loadImplementationClass(this);
                try {
                    this.implClassConstructor = this.implClass.getConstructor(Property.class, Resource.class);
                }
                catch (NoSuchMethodException e) {
                    Sapphire.service(LoggingService.class).log(e);
                    this.implClass = null;
                }
            }
        }
        if (this.implClassConstructor != null) {
            Element element;
            try {
                element = (Element)this.implClassConstructor.newInstance(property, resource);
            }
            catch (Exception e) {
                String msg = cannotInstantiate.format(this.getSimpleName());
                throw new RuntimeException(msg, e);
            }
            return (T)element;
        }
        String msg = cannotInstantiate.format(this.getSimpleName());
        throw new RuntimeException(msg);
    }

    public <T extends Element> T instantiate(Resource resource) {
        if (resource == null) {
            throw new IllegalArgumentException();
        }
        return this.instantiate(null, resource);
    }

    public <T extends Element> T instantiate(Object input) {
        return this.instantiate(this.service(MasterConversionService.class).convert(input, Resource.class));
    }

    public <T extends Element> T instantiate() {
        T element = this.instantiate(new MemoryResource(this));
        element.initialize();
        return element;
    }

    public synchronized SortedSet<PropertyDef> properties() {
        if (this.properties == null) {
            SortedSetFactory<PropertyDef> propertiesSetFactory = SortedSetFactory.start(PROPERTY_COMPARATOR);
            Field[] fieldArray = this.typeClass.getDeclaredFields();
            int n = fieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                if (field.getName().startsWith("PROP_")) {
                    Object value = null;
                    try {
                        value = field.get(null);
                    }
                    catch (IllegalAccessException e) {
                        Sapphire.service(LoggingService.class).log(e);
                    }
                    if (value instanceof PropertyDef) {
                        propertiesSetFactory.add((PropertyDef)value);
                    }
                }
                ++n2;
            }
            for (ElementType t : this.baseTypes) {
                propertiesSetFactory.add((Collection<PropertyDef>)t.properties());
            }
            this.properties = propertiesSetFactory.result();
            MapFactory<String, PropertyDef> propertiesByNameMapFactory = MapFactory.start();
            for (PropertyDef property : this.properties) {
                propertiesByNameMapFactory.add(property.name().toLowerCase(), property);
            }
            this.propertiesByName = propertiesByNameMapFactory.result();
        }
        return this.properties;
    }

    public <T extends PropertyDef> T property(String path) {
        if (path == null) {
            throw new IllegalArgumentException();
        }
        return this.property(new ModelPath(path));
    }

    public <T extends PropertyDef> T property(ModelPath path) {
        if (path == null) {
            throw new IllegalArgumentException();
        }
        this.properties();
        ModelPath.Segment head = path.head();
        if (head instanceof ModelPath.PropertySegment) {
            String name = ((ModelPath.PropertySegment)head).getPropertyName();
            PropertyDef property = this.propertiesByName.get(name.toLowerCase());
            if (property != null) {
                if (path.length() == 1) {
                    return (T)property;
                }
                if (property instanceof ElementProperty || property instanceof ListProperty) {
                    return property.getType().property(path.tail());
                }
            }
            return null;
        }
        throw new IllegalArgumentException(path.toString());
    }

    @Override
    protected void initAnnotations(ListFactory<Annotation> annotations) {
        annotations.add((Annotation[])this.typeClass.getDeclaredAnnotations());
    }

    @Override
    public <A extends Annotation> List<A> getAnnotations(Class<A> type) {
        ListFactory<A> annotationsListFactory = ListFactory.start();
        annotationsListFactory.add((Collection<A>)super.getAnnotations(type));
        for (ElementType baseType : this.baseTypes) {
            annotationsListFactory.add((Collection<A>)baseType.getAnnotations(type));
        }
        return annotationsListFactory.result();
    }

    @Override
    public <A extends Annotation> A getAnnotation(Class<A> type) {
        A annotation = super.getAnnotation(type);
        if (annotation == null) {
            for (ElementType baseType : this.baseTypes) {
                annotation = baseType.getAnnotation(type);
                if (annotation != null) break;
            }
        }
        return annotation;
    }

    public Class<?> findAnnotationHostClass(Annotation annotation) {
        if (this.typeClass.getAnnotation(annotation.annotationType()) == annotation) {
            return this.typeClass;
        }
        for (ElementType baseType : this.baseTypes) {
            Class<?> cl = baseType.findAnnotationHostClass(annotation);
            if (cl == null) continue;
            return cl;
        }
        return null;
    }

    @Override
    protected String getDefaultLabel() {
        int lastDollarSign;
        String label = this.typeClass.getName();
        int start = label.lastIndexOf(46) + 1;
        int startPlusOne = start + 1;
        if (label.charAt(start) == 'I' && startPlusOne < label.length() && Character.isUpperCase(label.charAt(startPlusOne))) {
            start = startPlusOne;
        }
        if (start > 0) {
            label = label.substring(start);
        }
        if ((lastDollarSign = label.lastIndexOf(36)) != -1) {
            label = label.substring(lastDollarSign + 1);
        }
        return LocalizationUtil.transformCamelCaseToLabel(label);
    }

    @Override
    public LocalizationService getLocalizationService() {
        return this.localizationService;
    }

    public ImageData image() {
        if (!this.imageInitialized) {
            Image imageAnnotation = this.getAnnotation(Image.class);
            if (imageAnnotation != null) {
                try {
                    this.image = ImageData.readFromClassLoader(this.findAnnotationHostClass(imageAnnotation), imageAnnotation.path()).optional();
                }
                catch (Exception e) {
                    Sapphire.service(LoggingService.class).log(e);
                }
            }
            this.imageInitialized = true;
        }
        return this.image;
    }

    synchronized List<Listener> listeners() {
        if (this.listeners == null) {
            ListFactory<Listener> listenersListFactory = ListFactory.start();
            Listeners listenersAnnotation = this.getAnnotation(Listeners.class);
            if (listenersAnnotation != null) {
                Class<? extends Listener>[] classArray = listenersAnnotation.value();
                int n = classArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Class<? extends Listener> cl = classArray[n2];
                    try {
                        listenersListFactory.add(cl.newInstance());
                    }
                    catch (Exception e) {
                        Sapphire.service(LoggingService.class).log(e);
                    }
                    ++n2;
                }
            }
            this.listeners = listenersListFactory.result();
        }
        return this.listeners;
    }

    public <S extends Service> S service(Class<S> type) {
        return this.services().service(type);
    }

    public <S extends Service> List<S> services(Class<S> type) {
        return this.services().services(type);
    }

    public synchronized ServiceContext services() {
        if (this.serviceContext == null) {
            this.serviceContext = new ElementMetaModelServiceContext(this);
        }
        return this.serviceContext;
    }

    protected static abstract class ModelPropertyInitListener {
        protected ModelPropertyInitListener() {
        }

        public abstract void propertyInitialized(PropertyDef var1);
    }
}

