/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.archives.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.jboss.ide.eclipse.archives.core.ArchivesCore;
import org.jboss.ide.eclipse.archives.core.model.ArchivesModel;
import org.jboss.ide.eclipse.archives.core.model.ArchivesModelException;
import org.jboss.ide.eclipse.archives.core.model.IArchiveNode;
import org.jboss.ide.eclipse.archives.core.model.IArchiveStandardFileSet;
import org.jboss.ide.eclipse.archives.ui.ArchivesUIMessages;
import org.jboss.ide.eclipse.archives.ui.PackagesUIPlugin;
import org.jboss.ide.eclipse.archives.ui.wizards.pages.FilesetInfoWizardPage;

public class FilesetWizard
extends Wizard {
    private FilesetInfoWizardPage page1;
    private IArchiveStandardFileSet fileset;
    private IArchiveNode parentNode;

    public FilesetWizard(IArchiveStandardFileSet fileset, IArchiveNode parentNode) {
        this.fileset = fileset;
        this.parentNode = parentNode;
        this.setWindowTitle(ArchivesUIMessages.FilesetWizard);
    }

    public boolean performFinish() {
        boolean createFileset;
        boolean bl = createFileset = this.fileset == null;
        if (createFileset) {
            this.fileset = ArchivesCore.getInstance().getNodeFactory().createFileset();
        }
        this.fillFilesetFromPage(this.fileset);
        try {
            this.getContainer().run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    if (createFileset) {
                        FilesetWizard.this.parentNode.addChild((IArchiveNode)FilesetWizard.this.fileset);
                    }
                    try {
                        ArchivesModel.instance().getRoot(FilesetWizard.this.fileset.getProjectPath()).save(monitor);
                    }
                    catch (ArchivesModelException ame) {
                        Status status = new Status(4, "org.jboss.ide.eclipse.archives.ui", ArchivesUIMessages.ErrorCompletingWizard, (Throwable)ame);
                        PackagesUIPlugin.getDefault().getLog().log((IStatus)status);
                    }
                }
            });
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (InterruptedException interruptedException) {}
        return true;
    }

    private void fillFilesetFromPage(IArchiveStandardFileSet fileset) {
        fileset.setExcludesPattern(this.page1.getExcludes());
        fileset.setIncludesPattern(this.page1.getIncludes());
        fileset.setFlattened(this.page1.isFlattened());
        fileset.setRawSourcePath(this.page1.getRawPath());
        fileset.setInWorkspace(this.page1.isRootDirWorkspaceRelative());
    }

    public void addPages() {
        this.page1 = new FilesetInfoWizardPage(this.getShell(), this.fileset, this.parentNode);
        this.addPage((IWizardPage)this.page1);
    }
}

