/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.asciidoc.core;

import java.util.List;
import org.eclipse.mylyn.internal.wikitext.asciidoc.core.block.HeadingBlock;
import org.eclipse.mylyn.internal.wikitext.asciidoc.core.block.ParagraphBlock;
import org.eclipse.mylyn.internal.wikitext.asciidoc.core.block.PreformattedBlock;
import org.eclipse.mylyn.internal.wikitext.asciidoc.core.block.UnderlinedHeadingBlock;
import org.eclipse.mylyn.internal.wikitext.asciidoc.core.phrase.BackslashEscapePhraseModifier;
import org.eclipse.mylyn.internal.wikitext.asciidoc.core.phrase.SimplePhraseModifier;
import org.eclipse.mylyn.internal.wikitext.asciidoc.core.token.EmailLinkReplacementToken;
import org.eclipse.mylyn.internal.wikitext.asciidoc.core.token.ExplicitLinkReplacementToken;
import org.eclipse.mylyn.internal.wikitext.asciidoc.core.token.ImplicitFormattedLinkReplacementToken;
import org.eclipse.mylyn.internal.wikitext.asciidoc.core.token.ImplicitLinkReplacementToken;
import org.eclipse.mylyn.internal.wikitext.asciidoc.core.token.PreserverHtmlEntityToken;
import org.eclipse.mylyn.internal.wikitext.asciidoc.core.util.ReadAheadDispatcher;
import org.eclipse.mylyn.wikitext.core.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.core.parser.markup.AbstractMarkupLanguage;
import org.eclipse.mylyn.wikitext.core.parser.markup.Block;
import org.eclipse.mylyn.wikitext.core.parser.markup.PatternBasedElement;
import org.eclipse.mylyn.wikitext.core.parser.markup.token.PatternLineBreakReplacementToken;

public class AsciiDocLanguage
extends AbstractMarkupLanguage {
    public AsciiDocLanguage() {
        this.setName("AsciiDoc");
    }

    protected void addStandardTokens(AbstractMarkupLanguage.PatternBasedSyntax tokenSyntax) {
        tokenSyntax.add((PatternBasedElement)new PreserverHtmlEntityToken());
        tokenSyntax.add((PatternBasedElement)new PatternLineBreakReplacementToken("(\\s\\+)\\s*"));
    }

    protected void addStandardPhraseModifiers(AbstractMarkupLanguage.PatternBasedSyntax phraseModifierSyntax) {
        phraseModifierSyntax.add((PatternBasedElement)new EmailLinkReplacementToken());
        phraseModifierSyntax.add((PatternBasedElement)new ExplicitLinkReplacementToken());
        phraseModifierSyntax.add((PatternBasedElement)new ImplicitFormattedLinkReplacementToken());
        phraseModifierSyntax.add((PatternBasedElement)new ImplicitLinkReplacementToken());
        phraseModifierSyntax.add((PatternBasedElement)new BackslashEscapePhraseModifier("+"));
        phraseModifierSyntax.add((PatternBasedElement)new BackslashEscapePhraseModifier("*"));
        phraseModifierSyntax.add((PatternBasedElement)new BackslashEscapePhraseModifier("_"));
        phraseModifierSyntax.add((PatternBasedElement)new SimplePhraseModifier("`", DocumentBuilder.SpanType.CODE));
        phraseModifierSyntax.add((PatternBasedElement)new SimplePhraseModifier("+", DocumentBuilder.SpanType.CODE));
        phraseModifierSyntax.add((PatternBasedElement)new SimplePhraseModifier("*", DocumentBuilder.SpanType.STRONG));
        phraseModifierSyntax.add((PatternBasedElement)new SimplePhraseModifier("_", DocumentBuilder.SpanType.EMPHASIS));
    }

    protected void addStandardBlocks(List<Block> blocks, List<Block> paragraphBreakingBlocks) {
        blocks.add(new PreformattedBlock());
        blocks.add(new HeadingBlock());
    }

    protected Block createParagraphBlock() {
        ParagraphBlock paragraphBlock = new ParagraphBlock();
        UnderlinedHeadingBlock headingBlock = new UnderlinedHeadingBlock();
        ReadAheadDispatcher readAheadBlock = new ReadAheadDispatcher(headingBlock, paragraphBlock);
        return readAheadBlock;
    }
}

