/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.asciidoc.core.block;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.mylyn.wikitext.core.parser.Attributes;
import org.eclipse.mylyn.wikitext.core.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.core.parser.markup.Block;

public class PreformattedBlock
extends Block {
    private static final Pattern startPattern = Pattern.compile("(?: {4}|\\t)((?: {4}|\\t)*)(.*)");
    private int blockLineCount = 0;

    public boolean canStart(String line, int lineOffset) {
        if (lineOffset == 0) {
            return startPattern.matcher(line).matches();
        }
        return false;
    }

    protected int processLineContent(String line, int offset) {
        Matcher matcher;
        if (this.blockLineCount == 0) {
            this.builder.beginBlock(DocumentBuilder.BlockType.PREFORMATTED, new Attributes());
        }
        if (!(matcher = startPattern.matcher(line)).matches()) {
            this.setClosed(true);
            return 0;
        }
        String intent = matcher.group(1);
        String content = matcher.group(2);
        if (content.length() == 0) {
            this.setClosed(true);
            return 0;
        }
        if (this.blockLineCount > 0) {
            this.builder.characters("\n");
        }
        if (intent != null) {
            this.builder.characters(intent);
        }
        this.builder.characters(content);
        ++this.blockLineCount;
        return -1;
    }

    public void setClosed(boolean closed) {
        if (closed && !this.isClosed()) {
            this.builder.endBlock();
        }
        super.setClosed(closed);
    }
}

