/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.jaxrs.ui.internal.validation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsBaseElement;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsJavaElement;
import org.jboss.tools.ws.jaxrs.core.jdt.RangeUtils;
import org.jboss.tools.ws.jaxrs.ui.internal.validation.IJaxrsElementValidator;
import org.jboss.tools.ws.jaxrs.ui.internal.validation.IMarkerManager;

public abstract class AbstractJaxrsElementValidatorDelegate<T extends JaxrsBaseElement>
implements IJaxrsElementValidator<T> {
    protected static final List<String> CONTEXT_TYPE_NAMES = new ArrayList<String>(Arrays.asList("javax.ws.rs.core.HttpHeaders", "javax.ws.rs.core.UriInfo", "javax.ws.rs.core.Request", "javax.servlet.http.HttpServletRequest", "javax.servlet.http.HttpServletResponse", "javax.servlet.ServletConfig", "javax.servlet.ServletContext", "javax.ws.rs.core.SecurityContext"));
    protected static final Pattern alphaNumPattern = Pattern.compile("[a-zA-Z1-9]([a-zA-Z1-9]|\\.|-|_)*");
    final IMarkerManager markerManager;

    public AbstractJaxrsElementValidatorDelegate(IMarkerManager markerManager) {
        this.markerManager = markerManager;
    }

    @Override
    public void validate(T element, CompilationUnit ast) throws CoreException {
        if (!element.exists()) {
            return;
        }
        this.internalValidate(element, ast);
    }

    abstract void internalValidate(T var1, CompilationUnit var2) throws CoreException;

    void removeMarkers(T element) throws CoreException {
        switch (element.getElementKind().getCategory()) {
            case RESOURCE_FIELD: 
            case RESOURCE_METHOD: {
                IMarker[] markers;
                ISourceRange sourceRange = ((JaxrsJavaElement)element).getJavaElement().getSourceRange();
                IMarker[] iMarkerArray = markers = element.getResource().findMarkers("org.jboss.tools.ws.jaxrs.metamodelMarker", true, 1);
                int n = markers.length;
                int n2 = 0;
                while (n2 < n) {
                    IMarker marker = iMarkerArray[n2];
                    int markerStartPosition = marker.getAttribute("charStart", 0);
                    if (RangeUtils.matches((ISourceRange)sourceRange, (int)markerStartPosition)) {
                        marker.delete();
                    }
                    ++n2;
                }
                break;
            }
            default: {
                element.getResource().deleteMarkers("org.jboss.tools.ws.jaxrs.metamodelMarker", true, 1);
            }
        }
    }
}

