/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.jaxrs.ui.contentassist;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.ui.text.java.ContentAssistInvocationContext;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposalComputer;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsMetamodel;
import org.jboss.tools.ws.jaxrs.core.jdt.Annotation;
import org.jboss.tools.ws.jaxrs.core.jdt.JdtUtils;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.IJaxrsResourceMethod;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.JaxrsMetamodelLocator;
import org.jboss.tools.ws.jaxrs.ui.JBossJaxrsUIPlugin;
import org.jboss.tools.ws.jaxrs.ui.internal.text.ContentAssistCompletionProposal;
import org.jboss.tools.ws.jaxrs.ui.internal.utils.Logger;

public class PathParamAnnotationValueCompletionProposalComputer
implements IJavaCompletionProposalComputer {
    private final Image icon = JBossJaxrsUIPlugin.getDefault().getImage("url_mapping.gif");

    public void sessionStarted() {
    }

    public void sessionEnded() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List<ICompletionProposal> computeCompletionProposals(ContentAssistInvocationContext context, IProgressMonitor monitor) {
        if (context instanceof JavaContentAssistInvocationContext) {
            JavaContentAssistInvocationContext javaContext = (JavaContentAssistInvocationContext)context;
            try {
                IJavaProject project = javaContext.getProject();
                JaxrsMetamodel metamodel = JaxrsMetamodelLocator.get((IJavaProject)project);
                if (metamodel == null) {
                    return Collections.emptyList();
                }
                JaxrsMetamodel jaxrsMetamodel = metamodel;
                synchronized (jaxrsMetamodel) {
                    IJavaElement javaMethod;
                    IJaxrsResourceMethod resourceMethod;
                    int invocationOffset = context.getInvocationOffset();
                    ICompilationUnit compilationUnit = javaContext.getCompilationUnit();
                    Annotation annotation = JdtUtils.resolveAnnotationAt((int)invocationOffset, (ICompilationUnit)compilationUnit);
                    if (annotation != null && annotation.getFullyQualifiedName().equals("javax.ws.rs.PathParam") && (resourceMethod = (IJaxrsResourceMethod)metamodel.findElement(javaMethod = annotation.getJavaAnnotation().getAncestor(9))) != null) {
                        return this.internalComputePathParamProposals(javaContext, resourceMethod);
                    }
                }
            }
            catch (Exception e) {
                Logger.error("Failed to compute completion proposal", e);
            }
        }
        return Collections.emptyList();
    }

    private List<ICompletionProposal> internalComputePathParamProposals(JavaContentAssistInvocationContext javaContext, IJaxrsResourceMethod resourceMethod) throws CoreException, BadLocationException {
        ArrayList<ICompletionProposal> completionProposals = new ArrayList<ICompletionProposal>();
        ITypedRegion region = this.getRegion(javaContext);
        String matchValue = javaContext.getDocument().get(region.getOffset(), javaContext.getInvocationOffset() - region.getOffset());
        if (!matchValue.isEmpty() && matchValue.charAt(0) == '\"') {
            matchValue = matchValue.substring(1);
        }
        ArrayList proposals = new ArrayList(resourceMethod.getPathTemplateParameters().keySet());
        proposals.addAll(resourceMethod.getParentResource().getPathTemplateParameters().keySet());
        Collections.sort(proposals);
        for (String proposal : proposals) {
            if (!proposal.startsWith(matchValue)) continue;
            completionProposals.add(this.generateCompletionProposal((IMember)resourceMethod.getJavaElement(), region, proposal));
        }
        return completionProposals;
    }

    private ICompletionProposal generateCompletionProposal(IMember member, ITypedRegion region, String proposalValue) throws CoreException {
        String replacementValue = "\"" + proposalValue + "\"";
        String displayString = String.valueOf(proposalValue) + " - JAX-RS Mapping";
        StyledString displayStyledString = new StyledString(displayString);
        displayStyledString.setStyle(proposalValue.length(), displayString.length() - proposalValue.length(), StyledString.QUALIFIER_STYLER);
        return new ContentAssistCompletionProposal(member.getCompilationUnit(), replacementValue, displayStyledString, region, this.icon, member);
    }

    private ITypedRegion getRegion(JavaContentAssistInvocationContext javaContext) {
        IDocument document = javaContext.getDocument();
        IDocumentPartitioner documentPartitioner = ((IDocumentExtension3)document).getDocumentPartitioner("___java_partitioning");
        return documentPartitioner.getPartition(javaContext.getInvocationOffset());
    }

    public final List<IContextInformation> computeContextInformation(ContentAssistInvocationContext context, IProgressMonitor monitor) {
        return Collections.emptyList();
    }

    public final String getErrorMessage() {
        return null;
    }
}

