/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.jaxrs.ui.cnf.action;

import java.lang.reflect.Method;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerUtil;
import org.jboss.tools.ws.jaxrs.ui.cnf.UriPathTemplateElement;
import org.jboss.tools.ws.jaxrs.ui.internal.utils.Logger;

public class OpenInWSTesterAction
extends Action
implements ISelectionChangedListener {
    private ISelection selection = null;

    public OpenInWSTesterAction() {
        super("Open in JBoss WS Tester");
    }

    public void run() {
        block6: {
            ITreeSelection treeSelection = (ITreeSelection)this.selection;
            List selections = treeSelection.toList();
            if (selections.isEmpty()) {
                return;
            }
            Object selectedObject = selections.get(0);
            try {
                if (!(selectedObject instanceof UriPathTemplateElement)) break block6;
                UriPathTemplateElement element = (UriPathTemplateElement)selectedObject;
                String endpointUri = this.computeEndpointURI(element);
                IWorkbench wb = PlatformUI.getWorkbench();
                IWorkbenchWindow win = wb.getActiveWorkbenchWindow();
                IWorkbenchPage page = win.getActivePage();
                String id = "org.jboss.tools.ws.ui.tester.views.TestWSView";
                try {
                    Class[] parmtypes;
                    Class<?> c;
                    Method setURL;
                    IViewPart part = page.showView(id);
                    if (part != null && part.getClass().getName().equalsIgnoreCase("org.jboss.tools.ws.ui.views.JAXRSWSTestView2") && (setURL = (c = part.getClass()).getDeclaredMethod("setJAXRS", parmtypes = new Class[]{String.class, String.class})) != null) {
                        Object[] arglist = new Object[]{endpointUri, element.getEndpoint().getHttpMethod().getHttpVerb()};
                        setURL.invoke((Object)part, arglist);
                    }
                }
                catch (PartInitException e) {
                    e.printStackTrace();
                    Logger.error("Failed to open WS Tester", e);
                }
            }
            catch (Exception e) {
                Logger.error("Failed to open WS Tester", e);
            }
        }
    }

    private String computeEndpointURI(UriPathTemplateElement element) {
        String uriPathTemplate = element.getEndpoint().getUriPathTemplate();
        IProject project = element.getEndpoint().getJavaProject().getProject();
        IModule module = ServerUtil.getModule((IProject)project);
        IPath path = new Path(module.getName()).append(uriPathTemplate);
        IServer[] servers = ServerUtil.getServersByModule((IModule)module, null);
        if (servers == null || servers.length == 0) {
            return "http://[domain]:[port]/" + path.toPortableString();
        }
        String domain = servers[0].getHost();
        String webport = servers[0].getAttribute("org.jboss.ide.eclipse.as.core.server.webPort", "8080");
        return "http://" + domain + ':' + webport + "/" + path.toPortableString();
    }

    public void selectionChanged(SelectionChangedEvent event) {
        Object source = event.getSource();
        if (source instanceof CommonViewer) {
            this.selection = ((CommonViewer)source).getSelection();
        }
    }

    public void setSelection(ISelection selection) {
        this.selection = selection;
    }
}

