/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.jaxrs.ui.cnf;

import java.util.ArrayList;
import org.eclipse.debug.ui.actions.ILaunchable;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.IJaxrsEndpoint;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.IJaxrsResourceMethod;
import org.jboss.tools.ws.jaxrs.ui.cnf.UriPathTemplateCategory;
import org.jboss.tools.ws.jaxrs.ui.cnf.UriPathTemplateMediaTypeMappingElement;
import org.jboss.tools.ws.jaxrs.ui.cnf.UriPathTemplateMethodMappingElement;
import org.jboss.tools.ws.jaxrs.ui.internal.utils.Logger;

public class UriPathTemplateElement
implements ITreeContentProvider,
ILaunchable {
    private IJaxrsEndpoint endpoint;
    private final UriPathTemplateCategory uriPathTemplateCategory;

    public UriPathTemplateElement(IJaxrsEndpoint endpoint, UriPathTemplateCategory uriPathTemplateCategory) {
        this.endpoint = endpoint;
        this.uriPathTemplateCategory = uriPathTemplateCategory;
    }

    public Object[] getChildren(Object parentElement) {
        ArrayList<Object> elements = new ArrayList<Object>(3);
        elements.add(new UriPathTemplateMediaTypeMappingElement(this.endpoint.getConsumedMediaTypes(), UriPathTemplateMediaTypeMappingElement.EnumCapabilityType.CONSUMES, (IJavaElement)((IJaxrsResourceMethod)this.endpoint.getResourceMethods().getLast()).getJavaElement()));
        elements.add(new UriPathTemplateMediaTypeMappingElement(this.endpoint.getProducedMediaTypes(), UriPathTemplateMediaTypeMappingElement.EnumCapabilityType.PRODUCES, (IJavaElement)((IJaxrsResourceMethod)this.endpoint.getResourceMethods().getLast()).getJavaElement()));
        elements.add(new UriPathTemplateMethodMappingElement(this.endpoint.getResourceMethods()));
        return elements.toArray();
    }

    public Object getParent(Object element) {
        return this.uriPathTemplateCategory;
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        Logger.trace("Input changed: {} -> {}", oldInput, newInput);
    }

    public int getProblemLevel() {
        return this.endpoint.getProblemLevel();
    }

    public void setEndpoint(IJaxrsEndpoint endpoint) {
        this.endpoint = endpoint;
    }

    public IJaxrsEndpoint getEndpoint() {
        return this.endpoint;
    }

    public IJaxrsResourceMethod getLastMethod() {
        return (IJaxrsResourceMethod)this.endpoint.getResourceMethods().getLast();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.endpoint == null ? 0 : this.endpoint.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UriPathTemplateElement other = (UriPathTemplateElement)obj;
        return !(this.endpoint == null ? other.endpoint != null : !this.endpoint.equals(other.endpoint));
    }

    public String toString() {
        return "UriPathTemplateElement [endpoint=" + this.endpoint + "]";
    }
}

