/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.discovery.core.internal;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.jboss.tools.discovery.core.internal.Messages;
import org.jboss.tools.foundation.core.properties.IPropertiesProvider;
import org.jboss.tools.foundation.core.properties.PropertiesHelper;
import org.jboss.tools.usage.event.UsageEventType;
import org.jboss.tools.usage.event.UsageReporter;
import org.osgi.framework.BundleContext;

public class DiscoveryActivator
extends AbstractUIPlugin {
    private static final String SEPARATOR = "/";
    public static final String PROPERTY_PROJECT_NAME = "projectName";
    public static final String PROPERTY_LOCATION_PATH = "locationPath";
    public static final String PROPERTY_ARTIFACT_ID = "artifactId";
    public static final String PLUGIN_ID = "org.jboss.tools.discovery.core";
    public static final String JBOSS_DISCOVERY_DIRECTORY = "jboss.discovery.directory.url";
    private static DiscoveryActivator plugin;
    private static final String CENTRAL_COMPONENT_NAME = "central";
    private static final String INSTALL_ACTION = "install";
    private UsageEventType installSoftwareEventType;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        String version = UsageEventType.getVersion((Plugin)this);
        this.installSoftwareEventType = new UsageEventType(CENTRAL_COMPONENT_NAME, version, null, INSTALL_ACTION, Messages.UsageEventTypeInstallLabelDescription);
        UsageReporter.getInstance().registerEvent(this.installSoftwareEventType);
    }

    public UsageEventType getInstallSoftwareEventType() {
        return this.installSoftwareEventType;
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        plugin = null;
    }

    public static DiscoveryActivator getDefault() {
        return plugin;
    }

    public static void log(Throwable e) {
        Status status = new Status(4, PLUGIN_ID, e.getLocalizedMessage(), e);
        DiscoveryActivator.getDefault().getLog().log((IStatus)status);
    }

    public static void log(String message) {
        DiscoveryActivator.log(2, message);
    }

    public static void logError(String message) {
        DiscoveryActivator.log(4, message);
    }

    public static void log(int severity, String message) {
        Status status = new Status(severity, PLUGIN_ID, message);
        DiscoveryActivator.getDefault().getLog().log((IStatus)status);
    }

    public Image getImage(ImageDescriptor imageDescriptor) {
        String id;
        ImageRegistry imageRegistry = this.getImageRegistry();
        Image image = imageRegistry.get(id = this.getImageId(imageDescriptor));
        if (image == null) {
            image = imageDescriptor.createImage(true);
            imageRegistry.put(id, image);
        }
        return image;
    }

    private String getImageId(ImageDescriptor imageDescriptor) {
        return "org.jboss.tools.discovery.core/" + imageDescriptor.hashCode();
    }

    public Image getImage(String imagePath) {
        ImageRegistry registry = this.getImageRegistry();
        Image image = registry.get(imagePath);
        if (image != null) {
            return image;
        }
        ImageDescriptor imageDescriptor = DiscoveryActivator.getImageDescriptor(imagePath);
        image = imageDescriptor.createImage();
        registry.put(imagePath, image);
        return image;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return DiscoveryActivator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public String getJBossDiscoveryDirectory() {
        String directory = System.getProperty(JBOSS_DISCOVERY_DIRECTORY, null);
        if (directory == null) {
            IPropertiesProvider pp = PropertiesHelper.getPropertiesProvider();
            directory = pp.getValue(JBOSS_DISCOVERY_DIRECTORY);
        }
        if (directory == null) {
            DiscoveryActivator.logError(String.format("No URL set for discovery catalog. Property %s is missing!", JBOSS_DISCOVERY_DIRECTORY));
        }
        return directory;
    }
}

