/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cdi.seam.config.core.scanner;

import java.io.ByteArrayInputStream;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.cdi.core.CDICoreNature;
import org.jboss.tools.cdi.internal.core.impl.definition.AnnotationDefinition;
import org.jboss.tools.cdi.seam.config.core.CDISeamConfigCorePlugin;
import org.jboss.tools.cdi.seam.config.core.ConfigDefinitionContext;
import org.jboss.tools.cdi.seam.config.core.definition.AbstractSeamFieldDefinition;
import org.jboss.tools.cdi.seam.config.core.definition.SeamBeanDefinition;
import org.jboss.tools.cdi.seam.config.core.definition.SeamBeansDefinition;
import org.jboss.tools.cdi.seam.config.core.definition.SeamFieldDefinition;
import org.jboss.tools.cdi.seam.config.core.definition.SeamFieldValueDefinition;
import org.jboss.tools.cdi.seam.config.core.definition.SeamMethodDefinition;
import org.jboss.tools.cdi.seam.config.core.definition.SeamParameterDefinition;
import org.jboss.tools.cdi.seam.config.core.definition.SeamVirtualFieldDefinition;
import org.jboss.tools.cdi.seam.config.core.util.Util;
import org.jboss.tools.cdi.seam.config.core.validation.SeamConfigValidationMessages;
import org.jboss.tools.cdi.seam.config.core.xml.SAXAttribute;
import org.jboss.tools.cdi.seam.config.core.xml.SAXElement;
import org.jboss.tools.cdi.seam.config.core.xml.SAXParser;
import org.jboss.tools.cdi.seam.config.core.xml.SAXText;
import org.jboss.tools.common.java.IJavaAnnotation;
import org.jboss.tools.common.java.impl.AnnotationLiteral;

public class SeamDefinitionBuilder {
    static int IN_ANNOTATION_TYPE = 1;
    CDICoreNature project;
    ConfigDefinitionContext context;
    IResource resource;
    SeamBeansDefinition result;
    SAXElement root;
    static long inlineBeanCount = 0L;

    public SeamBeansDefinition createDefinition(IResource resource, IDocument document, CDICoreNature project, ConfigDefinitionContext context) {
        this.project = project;
        this.context = context;
        this.resource = resource;
        this.result = new SeamBeansDefinition();
        this.result.setResource(resource);
        if (document.get().indexOf("<") >= 0) {
            SAXParser parser = new SAXParser();
            String text = document.get();
            ByteArrayInputStream s = new ByteArrayInputStream(text.getBytes());
            this.root = parser.parse(s, document);
            this.scanRoot();
        }
        return this.result;
    }

    private void scanRoot() {
        if (this.root == null) {
            return;
        }
        List<SAXElement> es = this.root.getChildElements();
        for (SAXElement element : es) {
            this.scanElement(element);
        }
    }

    private void scanElement(SAXElement element) {
        if (!Util.isConfigRelevant(element)) {
            return;
        }
        IType type = Util.resolveType(element, this.project);
        if (type == null) {
            this.reportUnresolvedType(element);
            this.result.addPossibleTypeNames(Util.getPossibleTypeNames(element));
            return;
        }
        TypeCheck typeCheck = new TypeCheck(type, element);
        if (typeCheck.isCorrupted) {
            return;
        }
        if (typeCheck.isAnnotation) {
            this.scanAnnotation(element, type);
        } else if (Util.hasProducesChild(element)) {
            SeamVirtualFieldDefinition f = this.scanVirtualProducerField(element);
            if (f != null) {
                this.result.addVirtualField(f);
            }
        } else {
            this.scanBean(element, type, false);
        }
    }

    private void reportUnresolvedType(SAXElement element) {
        Set<String> ps = Util.getPossibleTypeNames(element);
        if (ps.size() == 1) {
            String type = ps.iterator().next();
            String message = NLS.bind((String)SeamConfigValidationMessages.UNRESOLVED_TYPE, (Object)type);
            this.result.addUnresolvedNode(element, "Unresolved type", message);
        } else {
            String type = element.getLocalName();
            String message = NLS.bind((String)SeamConfigValidationMessages.UNRESOLVED_TYPE, (Object)type);
            this.result.addUnresolvedNode(element, "Unresolved type", message);
        }
    }

    private void scanAnnotation(SAXElement element, IType type) {
        this.context.getRootContext().getAnnotationKind(type);
        AnnotationDefinition def = new AnnotationDefinition();
        def.setType(type, this.context.getRootContext(), 0);
        List<SAXElement> es = element.getChildElements();
        for (SAXElement c : es) {
            IJavaAnnotation a = this.loadAnnotationDeclaration(c, IN_ANNOTATION_TYPE);
            if (a == null) continue;
            def.addAnnotation(a, this.context.getRootContext());
        }
        def.revalidateKind(this.context.getRootContext());
        this.context.addAnnotation(type.getFullyQualifiedName(), def);
    }

    private SeamBeanDefinition scanBean(SAXElement element, IType type, boolean inline) {
        SAXAttribute a;
        this.addDependency(type);
        SeamBeanDefinition def = new SeamBeanDefinition();
        def.setResource(this.resource);
        def.setInline(inline);
        def.setNode(element);
        def.setType(type);
        this.result.addBeanDefinition(def);
        List<SAXElement> es = element.getChildElements();
        for (SAXElement c : es) {
            IType t;
            if (!Util.isConfigRelevant(c)) continue;
            if (Util.containsEEPackage(c)) {
                if ("replaces".equals(c.getLocalName())) {
                    def.setReplaces(c);
                    continue;
                }
                if ("modifies".equals(c.getLocalName())) {
                    def.setModifies(c);
                    continue;
                }
                if (Util.isParameters(c)) {
                    SeamMethodDefinition md = this.scanConstructor(c, type);
                    if (md == null) continue;
                    def.addMethod(md);
                    continue;
                }
            }
            if ((t = Util.resolveType(c, this.project)) != null) {
                a = this.loadAnnotationDeclaration(c, IN_ANNOTATION_TYPE);
                if (a == null) continue;
                def.addAnnotation((IJavaAnnotation)a);
                continue;
            }
            IMember m = null;
            if (c.getURI() != null && c.getURI().equals(element.getURI())) {
                try {
                    m = Util.resolveMember(type, c);
                }
                catch (JavaModelException e) {
                    CDISeamConfigCorePlugin.getDefault().logError(e);
                }
            }
            if (m instanceof IField) {
                def.addField(this.scanField(c, (IField)m));
                continue;
            }
            if (m instanceof IMethod) {
                SeamMethodDefinition md = this.scanMethod(c, type);
                if (md == null) continue;
                def.addMethod(md);
                continue;
            }
            this.reportUnresolvedMember(c, type);
        }
        Set<String> as = element.getAttributeNames();
        for (String name : as) {
            a = element.getAttribute(name);
            IField f = type.getField(name);
            if (f == null || !f.exists()) {
                this.reportUnresolvedField(a, type);
                continue;
            }
            def.addField(this.scanField(a, f));
        }
        return def;
    }

    void reportUnresolvedMember(SAXElement c, IType type) {
        String message = NLS.bind((String)SeamConfigValidationMessages.UNRESOLVED_MEMBER, (Object)c.getLocalName(), (Object)type.getElementName());
        this.result.addUnresolvedNode(c, "Unresolved member", message);
    }

    void reportUnresolvedMethod(SAXElement c, IType type, String params) {
        String message = NLS.bind((String)SeamConfigValidationMessages.UNRESOLVED_METHOD, (Object)(String.valueOf(c.getLocalName()) + "(" + params + ")"), (Object)type.getElementName());
        this.result.addUnresolvedNode(c, "Unresolved method", message);
    }

    void reportUnresolvedConstructor(SAXElement c, IType type, String params) {
        String message = NLS.bind((String)SeamConfigValidationMessages.UNRESOLVED_CONSTRUCTOR, (Object)(String.valueOf(type.getElementName()) + "(" + params + ")"));
        this.result.addUnresolvedNode(c, "Unresolved constructor", message);
    }

    void reportUnresolvedField(SAXAttribute c, IType type) {
        String message = NLS.bind((String)SeamConfigValidationMessages.UNRESOLVED_FIELD, (Object)c.getName(), (Object)type.getElementName());
        this.result.addUnresolvedNode(c, "Unresolved member", message);
    }

    void reportUnresolvedMethod(SAXAttribute c, IType type) {
        String message = NLS.bind((String)SeamConfigValidationMessages.UNRESOLVED_METHOD, (Object)(String.valueOf(c.getName()) + "()"), (Object)type.getElementName());
        this.result.addUnresolvedNode(c, "Unresolved method", message);
    }

    private SeamVirtualFieldDefinition scanVirtualProducerField(SAXElement element) {
        SeamVirtualFieldDefinition def = new SeamVirtualFieldDefinition();
        def.setResource(this.resource);
        def.setNode(element);
        IType type = Util.resolveType(element, this.project);
        if (type == null) {
            this.reportUnresolvedType(element);
            return null;
        }
        def.setType(type);
        this.scanFieldContent(def, element);
        return def;
    }

    private SeamFieldDefinition scanField(SAXElement element, IField field) {
        SeamFieldDefinition def = new SeamFieldDefinition();
        def.setResource(this.resource);
        def.setNode(element);
        def.setField(field);
        this.scanFieldContent(def, element);
        return def;
    }

    private void scanFieldContent(AbstractSeamFieldDefinition def, SAXElement element) {
        if (Util.hasText(element)) {
            def.addValue(element.getTextNode());
        }
        List<SAXElement> es = element.getChildElements();
        for (SAXElement c : es) {
            if (!Util.isConfigRelevant(c)) continue;
            if (Util.isValue(c)) {
                if (Util.hasText(c)) {
                    def.addValue(c.getTextNode());
                    continue;
                }
                this.scanFieldValue(def, c);
                continue;
            }
            if (Util.isEntry(c)) {
                this.scanEntry(def, c);
                continue;
            }
            IType t = Util.resolveType(c, this.project);
            if (t != null) {
                IJavaAnnotation a = this.loadAnnotationDeclaration(c, IN_ANNOTATION_TYPE);
                if (a == null) continue;
                def.addAnnotation(a);
                continue;
            }
            this.reportUnresolvedType(c);
        }
    }

    private SeamFieldDefinition scanField(SAXAttribute a, IField field) {
        SeamFieldDefinition def = new SeamFieldDefinition();
        def.setResource(this.resource);
        def.setNode(a);
        def.setField(field);
        def.addValue(a);
        return def;
    }

    private void scanFieldValue(AbstractSeamFieldDefinition def, SAXElement element) {
        if (!Util.isConfigRelevant(element)) {
            return;
        }
        List<SAXElement> es = element.getChildElements();
        for (SAXElement c : es) {
            IType type;
            if (!Util.isConfigRelevant(c) || (type = Util.resolveType(c, this.project)) == null) continue;
            TypeCheck typeCheck = new TypeCheck(type, c);
            if (typeCheck.isCorrupted) {
                return;
            }
            if (typeCheck.isAnnotation) continue;
            SeamBeanDefinition inline = this.scanBean(c, type, true);
            IJavaAnnotation q = this.createInlineBeanQualifier();
            if (q == null) continue;
            SeamFieldValueDefinition vdef = new SeamFieldValueDefinition();
            vdef.setResource(this.resource);
            vdef.setNode(element);
            inline.addAnnotation(q);
            vdef.addAnnotation(q);
            vdef.setInlineBean(inline);
            IJavaAnnotation inject = this.createInject(element);
            if (inject != null) {
                vdef.addAnnotation(inject);
            }
            def.addValueDefinition(vdef);
        }
    }

    private void scanEntry(AbstractSeamFieldDefinition def, SAXElement element) {
        List<SAXElement> es = element.getChildElements();
        SAXText key = null;
        SAXText value = null;
        for (SAXElement c : es) {
            if (!Util.isConfigRelevant(c)) continue;
            if (Util.isKey(c)) {
                if (Util.hasText(c)) {
                    key = c.getTextNode();
                } else {
                    this.scanFieldValue(def, c);
                }
            }
            if (!Util.isValue(c)) continue;
            if (Util.hasText(c)) {
                value = c.getTextNode();
                continue;
            }
            this.scanFieldValue(def, c);
        }
        if (key != null && value != null) {
            def.addValue(key, value);
        }
    }

    private SeamMethodDefinition scanMethod(SAXElement element, IType type) {
        SeamMethodDefinition def = new SeamMethodDefinition();
        def.setResource(this.resource);
        def.setNode(element);
        StringBuilder paramPresentation = new StringBuilder();
        List<SAXElement> es = element.getChildElements();
        for (SAXElement c : es) {
            if (!Util.isConfigRelevant(c)) continue;
            if (Util.isParameters(c)) {
                List<SAXElement> ps = c.getChildElements();
                for (SAXElement p : ps) {
                    SeamParameterDefinition pd = this.scanParameter(p, paramPresentation);
                    if (pd == null) continue;
                    def.addParameter(pd);
                }
                continue;
            }
            if (Util.isArray(c)) {
                SeamParameterDefinition pd = this.scanParameter(c, paramPresentation);
                if (pd == null) continue;
                def.addParameter(pd);
                continue;
            }
            IType t = Util.resolveType(c, this.project);
            if (t != null) {
                IJavaAnnotation a = this.loadAnnotationDeclaration(c, IN_ANNOTATION_TYPE);
                if (a == null) continue;
                def.addAnnotation(a);
                continue;
            }
            this.reportUnresolvedType(c);
        }
        IMethod method = null;
        try {
            method = Util.findMethod(def, type, element.getLocalName(), this.context.getRootContext());
        }
        catch (JavaModelException e) {
            CDISeamConfigCorePlugin.getDefault().logError(e);
        }
        if (method != null) {
            def.setMethod(method);
        } else {
            this.reportUnresolvedMethod(element, type, paramPresentation.toString());
            def = null;
        }
        return def;
    }

    private SeamMethodDefinition scanConstructor(SAXElement element, IType type) {
        SeamParameterDefinition pd;
        SeamMethodDefinition def = new SeamMethodDefinition();
        def.setResource(this.resource);
        def.setNode(element);
        StringBuilder paramPresentation = new StringBuilder();
        if (Util.isParameters(element)) {
            List<SAXElement> ps = element.getChildElements();
            for (SAXElement p : ps) {
                SeamParameterDefinition pd2 = this.scanParameter(p, paramPresentation);
                if (pd2 == null) continue;
                def.addParameter(pd2);
            }
        } else if (Util.isArray(element) && (pd = this.scanParameter(element, paramPresentation)) != null) {
            def.addParameter(pd);
        }
        IJavaAnnotation inject = this.createInject(element);
        if (inject != null) {
            def.addAnnotation(inject);
        }
        IMethod method = null;
        try {
            method = Util.findMethod(def, type, null, this.context.getRootContext());
        }
        catch (JavaModelException e) {
            CDISeamConfigCorePlugin.getDefault().logError(e);
        }
        if (method != null) {
            def.setMethod(method);
        } else {
            this.reportUnresolvedConstructor(element, type, paramPresentation.toString());
            def = null;
        }
        return def;
    }

    private SeamParameterDefinition scanParameter(SAXElement element, StringBuilder paramPresentation) {
        if (!Util.isConfigRelevant(element)) {
            return null;
        }
        SeamParameterDefinition def = new SeamParameterDefinition();
        def.setResource(this.resource);
        def.setNode(element);
        if (Util.isArray(element)) {
            if (element.hasAttribute("dimensions")) {
                def.setDimensions(element.getAttribute("dimensions").getValue());
            } else {
                def.setDimensions("1");
            }
            List<SAXElement> es = element.getChildElements();
            for (SAXElement c : es) {
                if (!Util.isConfigRelevant(c)) continue;
                if (paramPresentation.length() > 0) {
                    paramPresentation.append(",");
                }
                paramPresentation.append(c.getLocalName());
                int q = 0;
                while (q < def.getDimensions()) {
                    paramPresentation.append("[]");
                    ++q;
                }
                IType type = Util.resolveType(c, this.project);
                if (type == null) {
                    this.reportUnresolvedType(c);
                    continue;
                }
                TypeCheck typeCheck = new TypeCheck(type, c);
                if (typeCheck.isCorrupted) continue;
                if (typeCheck.isAnnotation) {
                    IJavaAnnotation a = this.loadAnnotationDeclaration(c, IN_ANNOTATION_TYPE);
                    if (a == null) continue;
                    def.addAnnotation(a);
                    continue;
                }
                def.setType(type);
            }
        } else {
            if (paramPresentation.length() > 0) {
                paramPresentation.append(",");
            }
            paramPresentation.append(element.getLocalName());
            IType type = Util.resolveType(element, this.project);
            if (type == null) {
                this.reportUnresolvedType(element);
                return null;
            }
            def.setType(type);
            List<SAXElement> es = element.getChildElements();
            for (SAXElement c : es) {
                IJavaAnnotation a;
                IType t;
                if (!Util.isConfigRelevant(c) || Util.containsEEPackage(c) || (t = Util.resolveType(c, this.project)) == null || (a = this.loadAnnotationDeclaration(c, IN_ANNOTATION_TYPE)) == null) continue;
                def.addAnnotation(a);
            }
        }
        return def;
    }

    private IJavaAnnotation loadAnnotationDeclaration(SAXElement element, int contextKind) {
        if (!Util.isConfigRelevant(element)) {
            return null;
        }
        IType type = Util.resolveType(element, this.project);
        if (type == null) {
            if (contextKind == IN_ANNOTATION_TYPE) {
                this.reportUnresolvedType(element);
            }
            return null;
        }
        TypeCheck typeCheck = new TypeCheck(type, element);
        if (typeCheck.isCorrupted) {
            return null;
        }
        if (typeCheck.isAnnotation) {
            this.addDependency(type);
            this.context.getRootContext().getAnnotationKind(type);
            String value = null;
            SAXText text = element.getTextNode();
            if (text != null && text.getValue() != null && text.getValue().trim().length() > 0) {
                value = text.getValue();
            }
            AnnotationLiteral literal = new AnnotationLiteral(this.resource, element.getLocation().getStartPosition(), element.getLocation().getLength(), (Object)value, 9, type);
            Set<String> ns = element.getAttributeNames();
            for (String n : ns) {
                SAXAttribute attr = element.getAttribute(n);
                String v = attr.getValue();
                literal.addMemberValuePair(n, (Object)v, 9);
                IMethod m = type.getMethod(n, new String[0]);
                if (m.exists()) continue;
                this.reportUnresolvedMethod(attr, type);
            }
            return literal;
        }
        if (contextKind == IN_ANNOTATION_TYPE) {
            this.result.addUnresolvedNode(element, "Annotation expected", SeamConfigValidationMessages.ANNOTATION_EXPECTED);
        }
        return null;
    }

    IJavaAnnotation createInlineBeanQualifier() {
        IType type = this.project.getType("org.jboss.solder.config.xml.fieldset.InlineBeanQualifier");
        if (type == null) {
            type = this.project.getType("org.jboss.seam.config.xml.fieldset.InlineBeanQualifier");
        }
        if (type == null) {
            return null;
        }
        long id = inlineBeanCount++;
        return new AnnotationLiteral(this.resource, 0, 0, (Object)("" + id), 9, type);
    }

    IJavaAnnotation createInject(SAXElement forElement) {
        IType type = this.project.getType("javax.inject.Inject");
        return type == null ? null : new AnnotationLiteral(this.resource, forElement.getLocation().getStartPosition(), forElement.getLocation().getLength(), null, 0, type);
    }

    private void addDependency(IType type) {
        if (!type.exists() || type.isBinary()) {
            return;
        }
        if (!this.resource.exists() || this.resource.getName().endsWith(".jar")) {
            return;
        }
        this.context.getRootContext().addDependency(type.getResource().getFullPath(), this.resource.getFullPath());
        this.context.getRootContext().addDependency(this.resource.getFullPath(), type.getResource().getFullPath());
    }

    class TypeCheck {
        boolean isCorrupted = false;
        boolean isAnnotation = false;

        TypeCheck(IType type, SAXElement element) {
            try {
                this.isAnnotation = type.isAnnotation();
            }
            catch (JavaModelException e) {
                CDISeamConfigCorePlugin.getDefault().logError(e);
                SeamDefinitionBuilder.this.reportUnresolvedType(element);
                this.isCorrupted = true;
            }
        }
    }
}

