/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.ui.xpl;

import java.util.HashMap;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class ImageDescriptorRegistry {
    private HashMap<ImageDescriptor, Image> fRegistry = new HashMap(10);
    private Display fDisplay = PlatformUI.getWorkbench().getDisplay();

    public ImageDescriptorRegistry() {
        Assert.isNotNull((Object)this.fDisplay);
        this.hookDisplay();
    }

    public Image get(ImageDescriptor descriptor) {
        Image result;
        if (descriptor == null) {
            descriptor = ImageDescriptor.getMissingImageDescriptor();
        }
        if ((result = this.fRegistry.get(descriptor)) != null) {
            return result;
        }
        result = descriptor.createImage();
        if (result != null) {
            this.fRegistry.put(descriptor, result);
        }
        return result;
    }

    public void dispose() {
        for (Image image : this.fRegistry.values()) {
            image.dispose();
        }
        this.fRegistry.clear();
    }

    private void hookDisplay() {
        this.fDisplay.disposeExec(new Runnable(){

            @Override
            public void run() {
                ImageDescriptorRegistry.this.dispose();
            }
        });
    }
}

