/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.ui.wizard.service;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IType;
import org.jboss.tools.common.EclipseUtil;
import org.jboss.tools.common.ui.CommonUIPlugin;
import org.jboss.tools.common.util.FileUtil;

public class RegisterServiceUtil {
    static final String META_INF_FOLDER_NAME = "META-INF";
    static final String SERVICES_FOLDER_NAME = "services";

    public static boolean isServiceRegistered(IProject project, String typeName, String serviceType) {
        IFolder f;
        block3: {
            try {
                f = RegisterServiceUtil.getServiceFolder(project, false);
                if (f != null && f.exists()) break block3;
                return false;
            }
            catch (CoreException e) {
                CommonUIPlugin.getDefault().logError(e);
                return false;
            }
        }
        IFile file = f.getFile((IPath)new Path(serviceType));
        return file.exists() && RegisterServiceUtil.contains(FileUtil.readStream((IFile)file), typeName);
    }

    private static boolean contains(String content, String typeName) {
        int p = content.indexOf(typeName);
        while (p >= 0) {
            int p0 = p;
            if (((p += typeName.length()) == content.length() || Character.isWhitespace(content.charAt(p))) && (p0 == 0 || Character.isWhitespace(content.charAt(p0 - 1)))) {
                return true;
            }
            p = content.indexOf(typeName, p);
        }
        return false;
    }

    public static void registerService(IProject project, String typeName, String serviceType) throws CoreException {
        IFolder f = RegisterServiceUtil.getServiceFolder(project, true);
        if (f != null) {
            IFile file = f.getFile((IPath)new Path(serviceType));
            if (file.exists()) {
                String content = FileUtil.readStream((IFile)file);
                if (RegisterServiceUtil.contains(content, typeName)) {
                    return;
                }
                if (content.length() > 0 && !content.endsWith("\n")) {
                    content = String.valueOf(content) + "\n";
                }
                content = String.valueOf(content) + typeName;
                file.setContents((InputStream)new ByteArrayInputStream(content.getBytes()), true, true, (IProgressMonitor)new NullProgressMonitor());
            } else {
                String content = typeName;
                file.create((InputStream)new ByteArrayInputStream(content.getBytes()), true, (IProgressMonitor)new NullProgressMonitor());
            }
        }
    }

    public static void registerService(IType type, String serviceType) throws CoreException {
        IProject project = type.getJavaProject().getProject();
        String typeName = type.getFullyQualifiedName();
        RegisterServiceUtil.registerService(project, typeName, serviceType);
    }

    private static IFolder getServiceFolder(IProject project, boolean create) throws CoreException {
        IContainer m = RegisterServiceUtil.getMetaInf(project, create);
        if (m != null) {
            IFolder ss = m.getFolder((IPath)new Path(SERVICES_FOLDER_NAME));
            if (!ss.exists()) {
                if (!create) {
                    return null;
                }
                ss.create(true, true, (IProgressMonitor)new NullProgressMonitor());
            }
            return ss;
        }
        return null;
    }

    private static IContainer getMetaInf(IProject project, boolean create) throws CoreException {
        IResource[] rs = EclipseUtil.getJavaSourceRoots((IProject)project);
        if (rs == null || rs.length == 0) {
            return null;
        }
        IResource[] iResourceArray = rs;
        int n = rs.length;
        int n2 = 0;
        while (n2 < n) {
            IResource r = iResourceArray[n2];
            IFolder f = ((IContainer)r).getFolder((IPath)new Path(META_INF_FOLDER_NAME));
            if (f.exists()) {
                return f;
            }
            ++n2;
        }
        if (!create) {
            return null;
        }
        IFolder f = ((IContainer)rs[0]).getFolder((IPath)new Path(META_INF_FOLDER_NAME));
        f.create(true, true, (IProgressMonitor)new NullProgressMonitor());
        return f;
    }
}

