/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.ui.databinding;

import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;

public class ValueBindingBuilder {
    public static TargetDefinition bind(IObservableValue target) {
        return new TargetDefinition(target);
    }

    private static Binding bind(TargetDefinition targetDefinition, ModelDefinition modelDefinition, DataBindingContext dbc) {
        return dbc.bindValue(targetDefinition.getObservable(), modelDefinition.getObservable(), targetDefinition.getStrategy(), modelDefinition.getStrategy());
    }

    private static abstract class BindingParticipantDefinition<PARTICIPANT> {
        private IObservableValue observable;
        private UpdateValueStrategy strategy;

        public BindingParticipantDefinition(IObservableValue observable) {
            this.observable = observable;
        }

        public PARTICIPANT notUpdatingParticipant() {
            return this.withStrategy(new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER));
        }

        public PARTICIPANT withStrategy(UpdateValueStrategy strategy) {
            this.strategy = strategy;
            return (PARTICIPANT)this;
        }

        public PARTICIPANT validatingAfterGet(IValidator validator) {
            this.ensureHasStrategy();
            this.strategy.setAfterGetValidator(validator);
            return (PARTICIPANT)this;
        }

        public PARTICIPANT validatingAfterConvert(IValidator validator) {
            this.ensureHasStrategy();
            this.strategy.setAfterConvertValidator(validator);
            return (PARTICIPANT)this;
        }

        public PARTICIPANT validatingBeforeSet(IValidator validator) {
            this.ensureHasStrategy();
            this.strategy.setBeforeSetValidator(validator);
            return (PARTICIPANT)this;
        }

        public PARTICIPANT converting(IConverter converter) {
            this.ensureHasStrategy();
            this.strategy.setConverter(converter);
            return (PARTICIPANT)this;
        }

        private UpdateValueStrategy ensureHasStrategy() {
            if (this.strategy == null) {
                this.strategy = new UpdateValueStrategy();
            }
            return this.strategy;
        }

        IObservableValue getObservable() {
            return this.observable;
        }

        UpdateValueStrategy getStrategy() {
            return this.strategy;
        }
    }

    public static class ModelDefinition
    extends BindingParticipantDefinition<ModelDefinition> {
        private TargetDefinition targetDefinition;

        public ModelDefinition(IObservableValue model, TargetDefinition targetDefinition) {
            super(model);
            this.targetDefinition = targetDefinition;
        }

        public Binding in(DataBindingContext dbc) {
            return ValueBindingBuilder.bind(this.targetDefinition, this, dbc);
        }
    }

    public static class TargetDefinition
    extends BindingParticipantDefinition<TargetDefinition> {
        public TargetDefinition(IObservableValue target) {
            super(target);
        }

        public ModelDefinition to(IObservableValue model) {
            return new ModelDefinition(model, this);
        }

        public ModelDefinition notUpdating(IObservableValue model) {
            this.notUpdatingParticipant();
            return this.to(model);
        }
    }
}

