/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.ui.databinding;

import org.eclipse.core.databinding.AggregateValidationStatus;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.IObservableCollection;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationSupport;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.jboss.tools.common.ui.CommonUIMessages;
import org.jboss.tools.common.ui.databinding.MandatoryStringValidator;
import org.jboss.tools.common.ui.databinding.StatusSeverity2BooleanConverter;

public class DataBindingUtils {
    public static void bindEnablementToValidationStatus(Control control, DataBindingContext dbc, Binding ... bindings) {
        DataBindingUtils.bindEnablementToValidationStatus(control, 0, dbc, bindings);
    }

    public static void bindEnablementToValidationStatus(Control control, int enabledSeverityMask, DataBindingContext dbc, Binding ... bindings) {
        dbc.bindValue((IObservableValue)WidgetProperties.enabled().observe((Widget)control), (IObservableValue)DataBindingUtils.createAggregateValidationStatus(dbc, bindings), new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), new UpdateValueStrategy().setConverter((IConverter)new StatusSeverity2BooleanConverter(enabledSeverityMask)));
    }

    protected static AggregateValidationStatus createAggregateValidationStatus(DataBindingContext dbc, Binding ... bindings) {
        AggregateValidationStatus aggregatedValidationStatus = bindings.length == 0 ? new AggregateValidationStatus(dbc, 2) : new AggregateValidationStatus(DataBindingUtils.toObservableCollection((ValidationStatusProvider[])bindings), 2);
        return aggregatedValidationStatus;
    }

    private static IObservableCollection toObservableCollection(ValidationStatusProvider ... validationStatusProviders) {
        WritableList observableCollection = new WritableList();
        ValidationStatusProvider[] validationStatusProviderArray = validationStatusProviders;
        int n = validationStatusProviders.length;
        int n2 = 0;
        while (n2 < n) {
            ValidationStatusProvider validationStatusProvider = validationStatusProviderArray[n2];
            observableCollection.add((Object)validationStatusProvider);
            ++n2;
        }
        return observableCollection;
    }

    public static Binding bindMandatoryTextField(Text text, String fieldName, String modelProperty, Object model, DataBindingContext dbc) {
        Binding binding = dbc.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)text), BeanProperties.value((String)modelProperty).observe(model), new UpdateValueStrategy().setAfterGetValidator((IValidator)new MandatoryStringValidator(NLS.bind((String)CommonUIMessages.MANDATORYSTRING_VALIDATOR_MUST_PROVIDE_VALUE, (Object)fieldName))), null);
        ControlDecorationSupport.create((ValidationStatusProvider)binding, (int)16512);
        return binding;
    }

    public static void observeAndPrintValidationState(final String label, DataBindingContext dbc) {
        AggregateValidationStatus status = new AggregateValidationStatus(dbc, 2);
        status.addValueChangeListener(new IValueChangeListener(){

            public void handleValueChange(ValueChangeEvent event) {
                System.err.println("========================");
                System.err.println(label);
                System.err.println("------------------------");
                System.err.println(event.diff.getNewValue());
                System.err.println("========================");
            }
        });
    }

    public static void observeAndPrintValidationState(IWizardPage wizardPage, DataBindingContext dbc) {
        DataBindingUtils.observeAndPrintValidationState(wizardPage.getName(), dbc);
    }

    public static void addDisposableValueChangeListener(final IValueChangeListener listener, final IObservableValue observable, Control control) {
        Assert.isLegal((listener != null ? 1 : 0) != 0);
        Assert.isLegal((observable != null ? 1 : 0) != 0);
        Assert.isLegal((control != null ? 1 : 0) != 0);
        if (control.isDisposed()) {
            return;
        }
        observable.addValueChangeListener(listener);
        control.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                observable.removeValueChangeListener(listener);
            }
        });
    }
}

