/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.annotate.util;

import java.math.BigDecimal;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jpt.common.utility.internal.ClassNameTools;
import org.eclipse.jpt.common.utility.internal.NameTools;
import org.eclipse.jpt.common.utility.internal.StringTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotateMappingUtil {
    public static final String[] REPEATING_TYPES = new String[]{Collection.class.getName(), Enumeration.class.getName(), Iterator.class.getName(), Map.class.getName()};
    public static String[] PRIMITIVE_TYPES = new String[]{"int", "double", "long", "short", "byte", "float", "boolean", "char", "void"};
    public static String[] PRIMITIVE_WRAPPERS = new String[]{Integer.class.getName(), Double.class.getName(), Long.class.getName(), Short.class.getName(), Byte.class.getName(), Float.class.getName(), Boolean.class.getName(), Character.class.getName()};
    public static final String GET_PREFIX = "get";
    public static final String IS_PREFIX = "is";
    public static final String BOOLEAN = "boolean";

    public static boolean isRepeatingType(String type, IProject project) throws JavaModelException {
        if (AnnotateMappingUtil.isArrayType(type)) {
            return true;
        }
        String strippedType = AnnotateMappingUtil.stripTypeParameters(type);
        String[] stringArray = REPEATING_TYPES;
        int n = REPEATING_TYPES.length;
        int n2 = 0;
        while (n2 < n) {
            String repeatingType = stringArray[n2];
            if (strippedType.equals(repeatingType) || AnnotateMappingUtil.isAssignableFrom(strippedType, repeatingType, project)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static Set<String> getMappedByList(String entityClass, IType refType, boolean isManyToMany) throws JavaModelException {
        IField[] fields;
        HashSet<String> propNames = new HashSet<String>();
        IField[] iFieldArray = fields = refType.getFields();
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            IField field = iFieldArray[n2];
            if (!Flags.isStatic((int)field.getFlags()) && !Flags.isSuper((int)field.getFlags())) {
                String fieldType = AnnotateMappingUtil.getFieldType(field, refType);
                String dt = null;
                if (fieldType != null) {
                    if (isManyToMany) {
                        dt = AnnotateMappingUtil.getGenericsComponentTypeName(fieldType);
                        if (dt != null) {
                            dt = AnnotateMappingUtil.resolveType(dt, refType);
                        }
                    } else {
                        dt = fieldType;
                    }
                }
                if (dt != null && dt.equals(entityClass)) {
                    propNames.add(field.getElementName());
                }
            }
            ++n2;
        }
        return propNames;
    }

    public static String getGenericsComponentTypeName(String s) {
        int i1 = s.indexOf(60);
        if (i1 < 0) {
            return null;
        }
        int i2 = s.indexOf(62, i1);
        if (i2 < 0) {
            return null;
        }
        String typeName = s.substring(i1 + 1, i2);
        if (typeName.indexOf(44) >= 0) {
            return null;
        }
        return typeName;
    }

    public static String getFieldType(IField field, IType containingType) throws JavaModelException {
        String shortType = field.getTypeSignature();
        if (ClassNameTools.isPrimitive((String)(shortType = Signature.toString((String)shortType)))) {
            return shortType;
        }
        String type = AnnotateMappingUtil.resolveType(shortType, containingType);
        return type;
    }

    public static boolean isNumeric(String type) {
        return type.equals(Integer.class.getName()) || type.equals(Integer.TYPE.getName()) || type.equals(Float.class.getName()) || type.equals(Float.TYPE.getName()) || type.equals(Double.class.getName()) || type.equals(Double.TYPE.getName()) || type.equals(Short.class.getName()) || type.equals(Short.TYPE.getName()) || type.equals(Long.class.getName()) || type.equals(Long.TYPE.getName()) || type.equals(Byte.class.getName()) || type.equals(Byte.TYPE.getName()) || type.equals(Number.class.getName()) || type.equals(BigDecimal.class.getName());
    }

    public static boolean isString(String type) {
        return type.equals(String.class.getName());
    }

    public static boolean isDate(String type, IProject proj) throws JavaModelException {
        return AnnotateMappingUtil.isAssignableFrom(type, Date.class.getName(), proj) || AnnotateMappingUtil.isAssignableFrom(type, Calendar.class.getName(), proj);
    }

    public static boolean isTime(String type) {
        return type.equals(Time.class.getName()) || type.equals(Timestamp.class.getName());
    }

    public static boolean isBoolean(String type) {
        return type.equals(Boolean.class.getName()) || type.equals(Boolean.TYPE.getName());
    }

    public static boolean isArrayType(String type) {
        return type.endsWith("[]");
    }

    public static boolean hasMatchingTypeParameterBraces(String type) {
        assert (type != null) : "Type was null.";
        char[] chars = type.toCharArray();
        int openCount = 0;
        int closeCount = 0;
        int i = 0;
        while (i < chars.length) {
            if (chars[i] == '<') {
                ++openCount;
            }
            if (chars[i] == '>') {
                ++closeCount;
            }
            if (closeCount > openCount) {
                return false;
            }
            ++i;
        }
        return openCount == closeCount;
    }

    public static boolean hasMatchingArrayBrackets(String type) {
        int firstBracket = type.indexOf("[");
        int nextBracket = type.indexOf("]");
        if (firstBracket == -1 && nextBracket == -1) {
            return true;
        }
        String tempType = type;
        while (tempType.length() > 0) {
            nextBracket = tempType.indexOf("]");
            if (nextBracket < firstBracket || firstBracket == -1 || nextBracket != firstBracket + 1) {
                return false;
            }
            tempType = tempType.substring(nextBracket + 1);
            firstBracket = tempType.indexOf("[");
        }
        return true;
    }

    public static String stripTypeParameters(String typeName) {
        int index;
        assert (typeName != null) : "Type name was null.";
        if (AnnotateMappingUtil.hasMatchingTypeParameterBraces(typeName) && (index = typeName.indexOf(60)) > -1) {
            typeName = typeName.substring(0, index).trim();
        }
        assert (typeName != null) : "Returning null type.";
        return typeName;
    }

    public static String stripArrayDimensions(String typeName) {
        int index;
        assert (typeName != null) : "Type name was null.";
        if (AnnotateMappingUtil.hasMatchingArrayBrackets(typeName) && (index = (typeName = AnnotateMappingUtil.stripTypeParameters(typeName)).indexOf(91)) > -1) {
            typeName = typeName.substring(0, index).trim();
        }
        assert (typeName != null) : "Returning null type.";
        return typeName;
    }

    public static IType getType(String fullyQualifiedType, IProject project) throws JavaModelException {
        assert (fullyQualifiedType != null) : "Fully qualified type should not be null.";
        if (fullyQualifiedType.trim().length() == 0 || fullyQualifiedType.startsWith(".") || fullyQualifiedType.endsWith(".")) {
            return null;
        }
        int ltIndex = fullyQualifiedType.indexOf(60);
        int gtIndex = fullyQualifiedType.lastIndexOf(62);
        if (ltIndex != -1 && gtIndex != -1 && gtIndex > ltIndex) assert (false) : "Type should have type parameter info stripped before calling this method: " + fullyQualifiedType;
        assert (!AnnotateMappingUtil.isArrayType(fullyQualifiedType)) : "Type should have array brackets stripped before calling: " + fullyQualifiedType;
        assert (project != null) : "Project should not be null.";
        if (!project.isAccessible()) {
            return null;
        }
        IJavaProject javaProject = JavaCore.create((IProject)project);
        if (javaProject == null || !javaProject.exists()) {
            return null;
        }
        IType type = null;
        type = javaProject.findType(fullyQualifiedType);
        if (type != null && (!type.exists() || type.isAnonymous())) {
            type = null;
        }
        return type;
    }

    public static boolean isAssignableFrom(String fullyQualifiedSubTypeName, String fullyQualifiedSuperTypeName, IProject project) throws JavaModelException {
        assert (fullyQualifiedSubTypeName != null) : "Sub type name was null.";
        assert (fullyQualifiedSuperTypeName != null) : "Super type name was null.";
        assert (fullyQualifiedSubTypeName.indexOf(60) == -1) : "Subtype should have type parameter info stripped before calling this method: " + fullyQualifiedSubTypeName;
        assert (fullyQualifiedSuperTypeName.indexOf(60) == -1) : "Supertype should have type parameter info stripped before calling this method: " + fullyQualifiedSuperTypeName;
        boolean assignableFrom = false;
        if (project != null) {
            IType subType = AnnotateMappingUtil.getType(fullyQualifiedSubTypeName, project);
            IType superType = AnnotateMappingUtil.getType(fullyQualifiedSuperTypeName, project);
            if (subType != null && superType != null) {
                ITypeHierarchy th = subType.newSupertypeHierarchy(null);
                assert (th != null) : "Type hierarchy was null.";
                assignableFrom = th.contains(superType);
            }
        }
        return assignableFrom;
    }

    public static String resolveType(String typeName, IType type) throws JavaModelException {
        assert (typeName != null) : "Type name was null.";
        assert (type != null) : "Type was null.";
        int bracketIndex = typeName.indexOf(91);
        int typeParamIndex = typeName.indexOf(60);
        int suffixIndex = -1;
        String typeSuffix = null;
        if (bracketIndex > -1 && typeParamIndex > -1) {
            suffixIndex = bracketIndex <= typeParamIndex ? bracketIndex : typeParamIndex;
        } else if (bracketIndex > -1) {
            suffixIndex = bracketIndex;
        } else if (typeParamIndex > -1) {
            suffixIndex = typeParamIndex;
        }
        if (suffixIndex > -1) {
            typeSuffix = typeName.substring(suffixIndex);
            typeName = typeName.substring(0, suffixIndex).trim();
        }
        String value = null;
        String[][] typeMatches = type.resolveType(typeName);
        if (typeMatches != null && typeMatches.length == 1) {
            String string = value = typeMatches[0][0].length() == 0 ? typeMatches[0][1] : String.valueOf(typeMatches[0][0]) + "." + typeMatches[0][1];
        }
        if (value == null && type.isBinary()) {
            IProject project = type.getJavaProject().getProject();
            assert (project != null) : "Project was null.";
            IType resolvedType = AnnotateMappingUtil.getType(typeName, project);
            if (resolvedType != null) {
                value = resolvedType.getFullyQualifiedName('.');
            }
        }
        if (value != null && typeSuffix != null) {
            value = String.valueOf(value) + typeSuffix;
        }
        return value;
    }

    public static String getClassName(String fullClassName) {
        if (fullClassName == null) {
            return null;
        }
        int endBracket = fullClassName.lastIndexOf(62);
        if (endBracket >= 0) {
            int beginBracket = fullClassName.indexOf(60);
            assert (beginBracket >= 0) : "no matching '<' for '>' in " + fullClassName;
            assert (beginBracket < endBracket) : "bad class syntax in " + fullClassName;
            return String.valueOf(AnnotateMappingUtil.getClassName(fullClassName.substring(0, beginBracket))) + "<" + AnnotateMappingUtil.getClassName(fullClassName.substring(beginBracket + 1, endBracket)) + ">" + fullClassName.substring(endBracket + 1);
        }
        int dotpos = fullClassName.lastIndexOf(46);
        return dotpos < 0 ? fullClassName : fullClassName.substring(dotpos + 1);
    }

    public static final boolean areEqual(Object o1, Object o2) {
        boolean objectsAreEqual = false;
        if (o1 == o2) {
            objectsAreEqual = true;
        } else if (o1 != null && o2 != null) {
            objectsAreEqual = o1.getClass().isArray() && o2.getClass().isArray() ? Arrays.equals((Object[])o1, (Object[])o2) : o1.equals(o2);
        }
        return objectsAreEqual;
    }

    public static String dbNameToJavaName(String dbName) {
        String result = dbName;
        if (StringTools.isUppercase((String)result) || StringTools.isLowercase((String)result)) {
            result = StringTools.convertAllCapsToCamelCase((String)result, (boolean)false);
        }
        result = NameTools.convertToJavaIdentifier((String)result);
        return result;
    }

    public static String pluralise(String name) {
        String lower;
        String result = name;
        if (name.length() == 1) {
            result = String.valueOf(result) + 's';
        } else if (!AnnotateMappingUtil.seemsPluralised(name) && !(lower = name.toLowerCase()).endsWith("data")) {
            char secondLast = lower.charAt(name.length() - 2);
            result = !AnnotateMappingUtil.isVowel(secondLast) && lower.endsWith("y") ? String.valueOf(name.substring(0, name.length() - 1)) + "ies" : (lower.endsWith("ch") || lower.endsWith("s") ? String.valueOf(name) + "es" : String.valueOf(name) + "s");
        }
        return result;
    }

    public static String singularise(String name) {
        String result = name;
        if (AnnotateMappingUtil.seemsPluralised(name)) {
            String lower = name.toLowerCase();
            if (lower.endsWith("ies")) {
                result = String.valueOf(name.substring(0, name.length() - 3)) + "y";
            } else if (lower.endsWith("ches") || lower.endsWith("ses")) {
                result = name.substring(0, name.length() - 2);
            } else if (lower.endsWith("s")) {
                result = name.substring(0, name.length() - 1);
            }
        }
        return result;
    }

    private static final boolean isVowel(char c) {
        boolean vowel = false;
        vowel |= c == 'a';
        vowel |= c == 'e';
        vowel |= c == 'i';
        vowel |= c == 'o';
        vowel |= c == 'u';
        return vowel |= c == 'y';
    }

    private static boolean seemsPluralised(String name) {
        name = name.toLowerCase();
        boolean pluralised = false;
        pluralised |= name.endsWith("es");
        pluralised |= name.endsWith("s");
        return pluralised &= !name.endsWith("ss") && !name.endsWith("us");
    }
}

