/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt.gef.presentation;

import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.ui.PartVisibilityEvent;
import org.eclipse.sapphire.ui.SapphirePart;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodePart;
import org.eclipse.sapphire.ui.diagram.editor.ShapePart;
import org.eclipse.sapphire.ui.diagram.editor.ShapeUpdateEvent;
import org.eclipse.sapphire.ui.swt.gef.DiagramConfigurationManager;
import org.eclipse.sapphire.ui.swt.gef.model.DiagramNodeModel;
import org.eclipse.sapphire.ui.swt.gef.model.DiagramResourceCache;
import org.eclipse.sapphire.ui.swt.gef.model.ShapeModelUtil;
import org.eclipse.sapphire.ui.swt.gef.parts.ShapeUtil;
import org.eclipse.sapphire.ui.swt.gef.presentation.DiagramPresentation;
import org.eclipse.sapphire.ui.swt.gef.presentation.ShapePresentation;
import org.eclipse.swt.widgets.Shell;

public class DiagramNodePresentation
extends DiagramPresentation {
    private DiagramResourceCache resourceCache;
    private ShapePresentation shapePresentation;
    private Listener partVisibilityListener;
    private Listener shapeUpdateListener;

    public DiagramNodePresentation(DiagramNodePart nodePart, DiagramPresentation parent, Shell shell, DiagramConfigurationManager configManager, DiagramResourceCache resourceCache) {
        super((SapphirePart)nodePart, parent, configManager, shell);
        this.resourceCache = resourceCache;
        this.shapePresentation = ShapePresentation.ShapePresentationFactory.createShapePresentation(this, nodePart.getShapePart(), this.resourceCache);
    }

    public void init(final DiagramNodeModel model) {
        this.partVisibilityListener = new FilteredListener<PartVisibilityEvent>(){

            protected void handleTypedEvent(PartVisibilityEvent event) {
                ShapePart shapePart = (ShapePart)event.part();
                model.handleVisibilityChange(shapePart);
            }
        };
        this.getShapePresentation().part().attach(this.partVisibilityListener);
        this.shapeUpdateListener = new FilteredListener<ShapeUpdateEvent>(){

            protected void handleTypedEvent(ShapeUpdateEvent event) {
                ShapePart shapePart = event.getPart();
                ShapePresentation shapePresentation = ShapeModelUtil.getChildShapePresentation(DiagramNodePresentation.this.getShapePresentation(), shapePart);
                ShapeUtil.updateFigureForShape(shapePresentation, DiagramNodePresentation.this.resourceCache, DiagramNodePresentation.this.getConfigurationManager());
            }
        };
        this.getShapePresentation().part().attach(this.shapeUpdateListener);
    }

    public void dispose() {
        super.dispose();
        this.getShapePresentation().part().detach(this.partVisibilityListener);
        this.getShapePresentation().part().detach(this.shapeUpdateListener);
    }

    public ShapePresentation getShapePresentation() {
        return this.shapePresentation;
    }

    public DiagramNodePart part() {
        return (DiagramNodePart)super.part();
    }

    @Override
    public void render() {
        this.shapePresentation.render();
        this.setFigure(this.shapePresentation.getFigure());
    }
}

