/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt.gef.policies;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.editpolicies.NonResizableEditPolicy;
import org.eclipse.sapphire.Color;
import org.eclipse.sapphire.ui.LineStyle;
import org.eclipse.sapphire.ui.diagram.shape.def.SelectionPresentation;
import org.eclipse.sapphire.ui.swt.gef.figures.FigureUtil;
import org.eclipse.sapphire.ui.swt.gef.figures.IShapeFigure;
import org.eclipse.sapphire.ui.swt.gef.model.DiagramResourceCache;
import org.eclipse.sapphire.ui.swt.gef.parts.DiagramNodeEditPart;
import org.eclipse.sapphire.ui.swt.gef.utils.SapphireSurroundingHandle;

public class DiagramNodeSelectionEditPolicy
extends NonResizableEditPolicy {
    private IShapeFigure getNodeFigure() {
        DiagramNodeEditPart part = (DiagramNodeEditPart)this.getHost();
        if (part.getFigure() instanceof IShapeFigure) {
            return (IShapeFigure)part.getFigure();
        }
        return null;
    }

    protected List<?> createSelectionHandles() {
        ArrayList<SapphireSurroundingHandle> list = new ArrayList<SapphireSurroundingHandle>();
        GraphicalEditPart owner = (GraphicalEditPart)this.getHost();
        DiagramResourceCache resourceCache = ((DiagramNodeEditPart)owner).getCastedModel().getDiagramModel().getResourceCache();
        SelectionPresentation selectionPresentation = ((DiagramNodeEditPart)owner).getCastedModel().getShapeModel().getShapePresentation().getSelectionPresentation();
        SapphireSurroundingHandle selectionHandle = new SapphireSurroundingHandle(owner, ((DiagramNodeEditPart)owner).getConfigurationManager(), resourceCache, this.isDragAllowed());
        if (selectionPresentation != null) {
            selectionHandle.setLineOffset((Integer)selectionPresentation.getOffset().content());
            selectionHandle.setLineWidth((Integer)selectionPresentation.getWeight().content());
            selectionHandle.setLineStyle(FigureUtil.convertLineStyle((LineStyle)selectionPresentation.getStyle().content()));
            selectionHandle.setLineColor((Color)selectionPresentation.getColor().content());
        }
        list.add(selectionHandle);
        return list;
    }

    protected void hideFocus() {
        IShapeFigure shapeFigure = this.getNodeFigure();
        if (shapeFigure != null) {
            shapeFigure.setFocus(false);
        }
    }

    protected void showFocus() {
        IShapeFigure shapeFigure = this.getNodeFigure();
        if (shapeFigure != null) {
            shapeFigure.setFocus(true);
        }
    }

    protected void hideSelection() {
        IShapeFigure shapeFigure = this.getNodeFigure();
        if (shapeFigure != null) {
            shapeFigure.setSelected(false);
            shapeFigure.setFocus(false);
            this.removeSelectionHandles();
        }
    }

    protected void showPrimarySelection() {
        IShapeFigure shapeFigure = this.getNodeFigure();
        if (shapeFigure != null) {
            shapeFigure.setSelected(true);
            shapeFigure.setFocus(true);
            this.addSelectionHandles();
        }
    }

    protected void showSelection() {
        IShapeFigure shapeFigure = this.getNodeFigure();
        if (shapeFigure != null) {
            shapeFigure.setSelected(true);
            shapeFigure.setFocus(false);
            this.addSelectionHandles();
        }
    }
}

