/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt.gef.parts;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.ImageFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.sapphire.ui.Presentation;
import org.eclipse.sapphire.ui.SapphireActionHandler;
import org.eclipse.sapphire.ui.SapphirePart;
import org.eclipse.sapphire.ui.diagram.editor.ImagePart;
import org.eclipse.sapphire.ui.diagram.editor.ShapePart;
import org.eclipse.sapphire.ui.diagram.editor.TextPart;
import org.eclipse.sapphire.ui.swt.gef.DiagramConfigurationManager;
import org.eclipse.sapphire.ui.swt.gef.figures.TextFigure;
import org.eclipse.sapphire.ui.swt.gef.model.ShapeModel;
import org.eclipse.sapphire.ui.swt.gef.model.ShapeModelUtil;
import org.eclipse.sapphire.ui.swt.gef.parts.DiagramNodeEditPart;
import org.eclipse.sapphire.ui.swt.gef.parts.IConfigurationManagerHolder;
import org.eclipse.sapphire.ui.swt.gef.presentation.ContainerShapePresentation;
import org.eclipse.sapphire.ui.swt.gef.presentation.DiagramPresentation;
import org.eclipse.sapphire.ui.swt.gef.presentation.ShapePresentation;

public class ShapeEditPart
extends AbstractGraphicalEditPart
implements IConfigurationManagerHolder,
PropertyChangeListener {
    protected static final String DOUBLE_TAB_ACTION = "Sapphire.DoubleTap";
    private DiagramConfigurationManager configManager;

    public ShapeEditPart(DiagramConfigurationManager configManager) {
        this.configManager = configManager;
    }

    @Override
    public DiagramConfigurationManager getConfigurationManager() {
        return this.configManager;
    }

    public boolean isSelectable() {
        ShapePresentation shapePresentation = this.getShapePresentation();
        if (shapePresentation != null && shapePresentation.isSeparator()) {
            return false;
        }
        return super.isSelectable();
    }

    public void activate() {
        if (!this.isActive()) {
            super.activate();
            if (this.getModel() instanceof ShapeModel) {
                ShapeModel shapeModel = (ShapeModel)this.getModel();
                shapeModel.addPropertyChangeListener(this);
            }
        }
    }

    public void deactivate() {
        if (this.isActive() && this.getModel() instanceof ShapeModel) {
            ShapeModel shapeModel = (ShapeModel)this.getModel();
            shapeModel.removePropertyChangeListener(this);
            super.deactivate();
        }
    }

    protected IFigure createFigure() {
        ShapeModel shapeModel = (ShapeModel)this.getModel();
        ShapePresentation shapePresentation = shapeModel.getShapePresentation();
        shapePresentation.render();
        return shapePresentation.getFigure();
    }

    protected void createEditPolicies() {
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
    }

    public DiagramNodeEditPart getNodeEditPart() {
        ShapeEditPart parent = this;
        while (parent != null && !(parent instanceof DiagramNodeEditPart)) {
            parent = parent.getParent();
        }
        return (DiagramNodeEditPart)parent;
    }

    public SapphirePart getSapphirePart() {
        if (this.getModel() instanceof ShapeModel) {
            ShapeModel shapeModel = (ShapeModel)this.getModel();
            return shapeModel.getSapphirePart();
        }
        return null;
    }

    public ShapePresentation getShapePresentation() {
        if (this.getModel() instanceof ShapeModel) {
            ShapeModel shapeModel = (ShapeModel)this.getModel();
            ShapePresentation shapePresentation = shapeModel.getShapePresentation();
            return shapePresentation;
        }
        return null;
    }

    protected ContainerShapePresentation getParentContainer(ShapePresentation shapePresentation) {
        DiagramPresentation parentPresentation = shapePresentation.parent();
        while (!(parentPresentation instanceof ContainerShapePresentation) && parentPresentation != null) {
            parentPresentation = parentPresentation.parent();
        }
        return (ContainerShapePresentation)parentPresentation;
    }

    protected IFigure getPartFigure(ShapePart shapePart) {
        ShapePresentation shapePresentation = ShapeModelUtil.getChildShapePresentation(this.getNodeEditPart().getCastedModel().getShapePresentation(), shapePart);
        return shapePresentation != null ? shapePresentation.getFigure() : null;
    }

    protected void invokeDoubleTapAction(ShapePart shapePart) {
        List actionHandlers = shapePart.getAction(DOUBLE_TAB_ACTION).getActiveHandlers();
        if (!actionHandlers.isEmpty()) {
            final SapphireActionHandler firstHandler = (SapphireActionHandler)actionHandlers.get(0);
            this.getShapePresentation().display().asyncExec(new Runnable(){

                @Override
                public void run() {
                    firstHandler.execute((Presentation)ShapeEditPart.this.getShapePresentation());
                }
            });
        }
    }

    protected List<TextPart> getContainedTextParts() {
        return Collections.emptyList();
    }

    protected List<ImagePart> getContainedImageParts() {
        return Collections.emptyList();
    }

    protected TextPart getTextPart(Point mouseLocation) {
        Point realLocation = this.getConfigurationManager().getDiagramEditor().calculateRealMouseLocation(mouseLocation);
        List<TextPart> textParts = this.getContainedTextParts();
        for (TextPart textPart : textParts) {
            TextFigure textFigure = (TextFigure)this.getPartFigure((ShapePart)textPart);
            if (textFigure == null || !textFigure.getBounds().contains(realLocation)) continue;
            return textPart;
        }
        return null;
    }

    protected ImagePart getImagePart(Point mouseLocation) {
        Point realLocation = this.getConfigurationManager().getDiagramEditor().calculateRealMouseLocation(mouseLocation);
        List<ImagePart> imageParts = this.getContainedImageParts();
        for (ImagePart imagePart : imageParts) {
            ImageFigure imageFigure = (ImageFigure)this.getPartFigure((ShapePart)imagePart);
            if (imageFigure == null || !imageFigure.getBounds().contains(realLocation)) continue;
            return imagePart;
        }
        return null;
    }
}

