/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt.gef.internal;

import java.util.List;
import java.util.Set;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.sapphire.PossibleValuesService;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.services.ValueNormalizationService;
import org.eclipse.sapphire.ui.ISapphirePart;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodePart;
import org.eclipse.sapphire.ui.diagram.editor.SapphireDiagramEditorPagePart;
import org.eclipse.sapphire.ui.diagram.editor.TextPart;
import org.eclipse.sapphire.ui.swt.gef.internal.TraverseUtil;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class DiagramComboBoxCellEditor
extends ComboBoxCellEditor {
    private Property property;
    private CCombo combo;
    private TextPart textPart;
    private DiagramNodePart nodePart;
    private SapphireDiagramEditorPagePart pagePart;
    private List<DiagramNodePart> sortedNodes = null;

    public DiagramComboBoxCellEditor(TextPart textPart, Composite parent, Property property) {
        this.textPart = textPart;
        this.nodePart = (DiagramNodePart)textPart.nearest(DiagramNodePart.class);
        this.pagePart = (SapphireDiagramEditorPagePart)textPart.nearest(SapphireDiagramEditorPagePart.class);
        this.property = property;
        this.create(parent);
        this.combo = (CCombo)this.getControl();
        PossibleValuesService possibleValuesService = (PossibleValuesService)this.property.service(PossibleValuesService.class);
        Set possibleValues = possibleValuesService.values();
        String[] contentForCombo = new String[possibleValues.size()];
        possibleValues.toArray(contentForCombo);
        this.setItems(contentForCombo);
    }

    protected Object doGetValue() {
        int index = this.combo.getSelectionIndex();
        if (index == -1) {
            ValueNormalizationService valueNormalizationService = (ValueNormalizationService)this.property.service(ValueNormalizationService.class);
            String value = valueNormalizationService.normalize(this.combo.getText());
            if (value.length() > 0) {
                return value;
            }
            return null;
        }
        return this.combo.getItem(index);
    }

    protected Control createControl(Composite parent) {
        CCombo comboBox = (CCombo)super.createControl(parent);
        comboBox.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 16) {
                    TextPart nextTextPart = TraverseUtil.getNextTextPartInSameNode(DiagramComboBoxCellEditor.this.textPart);
                    if (nextTextPart == null) {
                        List sortedNodes = DiagramComboBoxCellEditor.this.getSortedNodes();
                        nextTextPart = TraverseUtil.getTextPartInNextNode(sortedNodes, DiagramComboBoxCellEditor.this.nodePart);
                    }
                    if (nextTextPart != null) {
                        DiagramComboBoxCellEditor.this.pagePart.selectAndDirectEdit((ISapphirePart)nextTextPart);
                    }
                }
            }
        });
        return comboBox;
    }

    private List<DiagramNodePart> getSortedNodes() {
        if (this.sortedNodes == null) {
            this.sortedNodes = TraverseUtil.getSortedNodeParts(this.pagePart);
        }
        return this.sortedNodes;
    }
}

