/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.as.core.server.controllable.subsystems.internal;

import java.io.File;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServerAttributes;
import org.jboss.ide.eclipse.as.core.JBossServerCorePlugin;
import org.jboss.ide.eclipse.as.core.server.IJBossServerRuntime;
import org.jboss.ide.eclipse.as.core.server.internal.v7.LocalJBoss7ServerRuntime;
import org.jboss.ide.eclipse.as.core.util.RuntimeUtils;
import org.jboss.ide.eclipse.as.core.util.ServerUtil;
import org.jboss.tools.as.core.server.controllable.systems.AbstractJBossDeploymentOptionsController;
import org.jboss.tools.as.core.server.controllable.systems.IDeploymentOptionsController;

public class LocalDeploymentOptionsController
extends AbstractJBossDeploymentOptionsController
implements IDeploymentOptionsController {
    @Override
    public String makeGlobal(String original) {
        IPath p = ServerUtil.makeGlobal(this.getServerOrWC().getRuntime(), (IPath)new Path(original));
        return p.toOSString();
    }

    @Override
    public String makeRelative(String original) {
        IPath p = ServerUtil.makeRelative(this.getServerOrWC().getRuntime(), (IPath)new Path(original));
        return p.toOSString();
    }

    @Override
    public String getCurrentDeploymentLocationType() {
        boolean isDepOnly = this.getServerOrWC().getServerType().getId().equals("org.jboss.ide.eclipse.as.systemCopyServer");
        if (isDepOnly) {
            return "custom";
        }
        return this.getServerOrWC().getAttribute("org.jboss.ide.eclipse.as.core.server.deployDirectoryType", "server");
    }

    @Override
    protected String getDeployFolder(String type) {
        String ret = null;
        if (type.equals("custom")) {
            ret = this.getServerOrWC().getAttribute("org.jboss.ide.eclipse.as.core.server.deployDirectory", null);
            boolean isDepOnly = this.getServer().getServerType().getId().equals("org.jboss.ide.eclipse.as.systemCopyServer");
            if (isDepOnly) {
                ret = new Path(ret).makeAbsolute().toOSString();
            }
        }
        if (type.equals("server")) {
            return this.makeRelative(this.getExtendedProperties().getServerDeployLocation());
        }
        if (ret == null || type.equals("metadata")) {
            ret = this.getMetadataDeployLocation(this.getServer());
        }
        return ret;
    }

    @Override
    protected String getTempDeployFolder(String type) {
        if (type.equals("custom")) {
            String ret = this.getServerOrWC().getAttribute("org.jboss.ide.eclipse.as.core.server.tempDeployDirectory", "");
            boolean isDepOnly = this.getServerOrWC().getServerType().getId().equals("org.jboss.ide.eclipse.as.systemCopyServer");
            if (isDepOnly) {
                return new Path(ret).makeAbsolute().toOSString();
            }
            return ret;
        }
        if (type.equals("metadata")) {
            return JBossServerCorePlugin.getServerStateLocation(this.getServer()).append("tempDeploy").makeAbsolute().toString();
        }
        if (type.equals("server")) {
            String ret = null;
            ret = this.isAS7Structure() ? this.getAS7StyleServerTempFolder() : this.getASLessThan7StyleServerTempFolder();
            return this.makeRelative(ret);
        }
        return null;
    }

    protected String getAS7StyleServerTempFolder() {
        IRuntime rt = this.getServer().getRuntime();
        LocalJBoss7ServerRuntime jb7rt = (LocalJBoss7ServerRuntime)((Object)rt.loadAdapter(LocalJBoss7ServerRuntime.class, null));
        IPath p = new Path(jb7rt.getBaseDirectory()).append("tmp");
        return p.toString();
    }

    protected String getASLessThan7StyleServerTempFolder() {
        IJBossServerRuntime jbsrt = RuntimeUtils.getJBossServerRuntime((IServerAttributes)this.getServer());
        String loc = jbsrt.getConfigLocation();
        String config = jbsrt.getJBossConfiguration();
        IPath p = new Path(loc).append(config).append("tmp").append("jbosstoolsTemp");
        return p.toString();
    }

    @Override
    public char getPathSeparatorCharacter() {
        return File.separatorChar;
    }
}

