/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.as.core.server.controllable.subsystems.internal;

import java.text.MessageFormat;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerAttributes;
import org.jboss.ide.eclipse.as.core.JBossServerCorePlugin;
import org.jboss.ide.eclipse.as.core.extensions.events.ServerLogger;
import org.jboss.ide.eclipse.as.core.server.launch.CommandLineLaunchConfigProperties;
import org.jboss.ide.eclipse.as.core.server.launch.LocalCommandLineRunner;
import org.jboss.ide.eclipse.as.core.util.LaunchCommandPreferences;
import org.jboss.ide.eclipse.as.core.util.ThreadUtils;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.AbstractSubsystemController;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.ControllableServerBehavior;
import org.jboss.tools.as.core.server.controllable.systems.ICommandLineShutdownController;

public class CommandLineShutdownController
extends AbstractSubsystemController
implements ICommandLineShutdownController {
    public IStatus canStop() {
        return Status.OK_STATUS;
    }

    public void stop(boolean force) {
        boolean ignoreLaunch = LaunchCommandPreferences.isIgnoreLaunchCommand((IServerAttributes)this.getServer());
        if (ignoreLaunch) {
            ((ControllableServerBehavior)this.getControllableBehavior()).setServerStopping();
            ((ControllableServerBehavior)this.getControllableBehavior()).setServerStopped();
            return;
        }
        this.stopImpl(force);
    }

    protected boolean nextStopRequiresForce() {
        Object o = ((ControllableServerBehavior)this.getControllableBehavior()).getSharedData("DeployableServerBehavior.RequiresForceStop");
        return Boolean.TRUE.equals(o);
    }

    public void stopImpl(boolean force) {
        if (force || this.nextStopRequiresForce() || !this.isServerStarted()) {
            this.forceStop();
            return;
        }
        ((ControllableServerBehavior)this.getControllableBehavior()).setServerStopping();
        this.beforeCommandExecuted();
        IStatus shutdownStatus = this.gracefullStop();
        if (!shutdownStatus.isOK()) {
            this.handleShutdownFailed();
            return;
        }
        this.afterCommandExecuted();
    }

    protected void afterCommandExecuted() {
        ((ControllableServerBehavior)this.getControllableBehavior()).setServerStopped();
    }

    protected IStatus gracefullStop() {
        try {
            String command = this.getShutdownCommand(this.getServer());
            if (command.trim().length() == 0) {
                throw new CoreException((IStatus)new Status(4, "org.jboss.ide.eclipse.as.core", "Unable to stop server: command to run is empty", null));
            }
            return this.executeShutdownCommand(command);
        }
        catch (CoreException ce) {
            Status error = new Status(4, "org.jboss.ide.eclipse.as.core", MessageFormat.format("Could not stop server {0}", this.getServer().getName()), (Throwable)ce);
            ServerLogger.getDefault().log(this.getServer(), (IStatus)error);
            return error;
        }
    }

    protected IStatus executeShutdownCommand(String shutdownCommand) throws CoreException {
        IProcess stopProcess = new LocalCommandLineRunner().launchCommand(shutdownCommand, (IProgressMonitor)new NullProgressMonitor());
        ThreadUtils.sleepWhileRunning((IProcess)stopProcess);
        if (stopProcess.getExitValue() == 0) {
            ((ControllableServerBehavior)this.getControllableBehavior()).setServerStopped();
        } else {
            ((ControllableServerBehavior)this.getControllableBehavior()).setServerStarted();
        }
        return Status.OK_STATUS;
    }

    protected synchronized void forceStop() {
        ControllableServerBehavior beh = (ControllableServerBehavior)this.getControllableBehavior();
        beh.putSharedData("DeployableServerBehavior.RequiresForceStop", (Object)false);
        if (beh != null) {
            IProcess p;
            Object o = beh.getSharedData("AbstractStartJavaServerLaunchDelegate.Process");
            if (o instanceof IProcess && (p = (IProcess)o).canTerminate()) {
                try {
                    p.terminate();
                }
                catch (DebugException de) {
                    JBossServerCorePlugin.log(de);
                }
            }
            beh.setServerStopped();
        }
    }

    protected String getShutdownCommand(IServer server) throws CoreException {
        ILaunchConfiguration config = this.getServer().getLaunchConfiguration(false, (IProgressMonitor)new NullProgressMonitor());
        return new CommandLineLaunchConfigProperties().getShutdownCommand(config, this.getDefaultShutdownCommand(server));
    }

    protected String getDefaultShutdownCommand(IServer server) {
        return "";
    }

    protected boolean isServerStarted() {
        return this.getServer().getServerState() == 2;
    }

    protected void beforeCommandExecuted() {
    }

    protected void handleShutdownFailed() {
        if (this.getServer().getServerState() == 4) {
            return;
        }
        ((ControllableServerBehavior)this.getControllableBehavior()).setServerStarted();
        ((ControllableServerBehavior)this.getControllableBehavior()).putSharedData("DeployableServerBehavior.RequiresForceStop", (Object)true);
    }
}

