/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.core.modules;

import org.eclipse.core.resources.IProject;
import org.eclipse.jst.j2ee.internal.web.deployables.WebDeployableArtifactUtil;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IModuleArtifact;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerUtil;
import org.eclipse.wst.server.core.model.ModuleArtifactAdapterDelegate;
import org.eclipse.wst.server.core.model.ModuleDelegate;
import org.jboss.ide.eclipse.as.core.server.IModuleArtifact2;

public class EarArtifactAdapter
extends ModuleArtifactAdapterDelegate {
    public IModuleArtifact getModuleArtifact(Object obj) {
        if (obj instanceof IProject) {
            IProject p = (IProject)obj;
            IModule[] mods = ServerUtil.getModules((IProject)p);
            int i = 0;
            while (i < mods.length) {
                if (mods[i].getModuleType().getId().equals("jst.ear")) {
                    return this.getArtifactFor(mods[i]);
                }
                ++i;
            }
        }
        return null;
    }

    protected IModuleArtifact getArtifactFor(IModule ear) {
        ModuleDelegate del = (ModuleDelegate)ear.loadAdapter(ModuleDelegate.class, null);
        IModule[] children = del.getChildModules();
        IModuleArtifact tmp = null;
        int i = 0;
        while (i < children.length) {
            String typeId = children[i].getModuleType().getId();
            if (typeId.equals("jst.web") || typeId.equals("wst.web")) {
                tmp = WebDeployableArtifactUtil.getModuleObject((Object)children[i].getProject());
            }
            if (tmp != null) {
                return new EarModuleArtifact(ear, tmp);
            }
            ++i;
        }
        return null;
    }

    public static class EarModuleArtifact
    implements IModuleArtifact2 {
        private IModule earModule;
        private IModuleArtifact childArtifact;

        public EarModuleArtifact(IModule ear, IModuleArtifact child) {
            this.earModule = ear;
            this.childArtifact = child;
        }

        public IModule getModule() {
            return this.earModule;
        }

        public IModuleArtifact getChildArtifact() {
            return this.childArtifact;
        }

        public IModule[] getModuleTree(IServer server) {
            return new IModule[]{this.earModule, this.childArtifact.getModule()};
        }
    }
}

