/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.runtime.v_3_6.internal;

import java.io.File;
import java.lang.reflect.Constructor;
import java.sql.Connection;
import java.util.Collections;
import java.util.Properties;
import org.hibernate.Hibernate;
import org.hibernate.cfg.AnnotationConfiguration;
import org.hibernate.cfg.Configuration;
import org.hibernate.cfg.JDBCMetaDataConfiguration;
import org.hibernate.cfg.JDBCReaderFactory;
import org.hibernate.cfg.NamingStrategy;
import org.hibernate.cfg.Settings;
import org.hibernate.cfg.reveng.DefaultDatabaseCollector;
import org.hibernate.cfg.reveng.DefaultReverseEngineeringStrategy;
import org.hibernate.cfg.reveng.JDBCReader;
import org.hibernate.cfg.reveng.OverrideRepository;
import org.hibernate.cfg.reveng.ReverseEngineeringSettings;
import org.hibernate.cfg.reveng.ReverseEngineeringStrategy;
import org.hibernate.cfg.reveng.TableFilter;
import org.hibernate.cfg.reveng.TableIdentifier;
import org.hibernate.cfg.reveng.dialect.MetaDataDialect;
import org.hibernate.connection.DriverManagerConnectionProvider;
import org.hibernate.console.HibernateConsoleRuntimeException;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.resolver.DialectFactory;
import org.hibernate.ejb.Ejb3Configuration;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.query.HQLQueryPlan;
import org.hibernate.impl.SessionFactoryImpl;
import org.hibernate.mapping.Array;
import org.hibernate.mapping.Bag;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.JoinedSubclass;
import org.hibernate.mapping.List;
import org.hibernate.mapping.ManyToOne;
import org.hibernate.mapping.Map;
import org.hibernate.mapping.OneToMany;
import org.hibernate.mapping.OneToOne;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.PrimaryKey;
import org.hibernate.mapping.PrimitiveArray;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.RootClass;
import org.hibernate.mapping.Set;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.SingleTableSubclass;
import org.hibernate.mapping.Table;
import org.hibernate.proxy.HibernateProxyHelper;
import org.hibernate.tool.hbm2ddl.SchemaExport;
import org.hibernate.tool.hbm2x.ArtifactCollector;
import org.hibernate.tool.hbm2x.Exporter;
import org.hibernate.tool.hbm2x.HibernateMappingGlobalSettings;
import org.hibernate.tool.ide.completion.HQLCodeAssist;
import org.hibernate.util.xpl.ReflectHelper;
import org.hibernate.util.xpl.StringHelper;
import org.jboss.tools.hibernate.runtime.common.IFacade;
import org.jboss.tools.hibernate.runtime.common.IFacadeFactory;
import org.jboss.tools.hibernate.runtime.common.Util;
import org.jboss.tools.hibernate.runtime.spi.IArtifactCollector;
import org.jboss.tools.hibernate.runtime.spi.ICfg2HbmTool;
import org.jboss.tools.hibernate.runtime.spi.IColumn;
import org.jboss.tools.hibernate.runtime.spi.IConfiguration;
import org.jboss.tools.hibernate.runtime.spi.IDatabaseCollector;
import org.jboss.tools.hibernate.runtime.spi.IDialect;
import org.jboss.tools.hibernate.runtime.spi.IEnvironment;
import org.jboss.tools.hibernate.runtime.spi.IExporter;
import org.jboss.tools.hibernate.runtime.spi.IHQLCodeAssist;
import org.jboss.tools.hibernate.runtime.spi.IHQLQueryPlan;
import org.jboss.tools.hibernate.runtime.spi.IHibernateMappingExporter;
import org.jboss.tools.hibernate.runtime.spi.IHibernateMappingGlobalSettings;
import org.jboss.tools.hibernate.runtime.spi.IJDBCReader;
import org.jboss.tools.hibernate.runtime.spi.IMetaDataDialect;
import org.jboss.tools.hibernate.runtime.spi.INamingStrategy;
import org.jboss.tools.hibernate.runtime.spi.IOverrideRepository;
import org.jboss.tools.hibernate.runtime.spi.IPersistentClass;
import org.jboss.tools.hibernate.runtime.spi.IPrimaryKey;
import org.jboss.tools.hibernate.runtime.spi.IProperty;
import org.jboss.tools.hibernate.runtime.spi.IReverseEngineeringSettings;
import org.jboss.tools.hibernate.runtime.spi.IReverseEngineeringStrategy;
import org.jboss.tools.hibernate.runtime.spi.ISchemaExport;
import org.jboss.tools.hibernate.runtime.spi.IService;
import org.jboss.tools.hibernate.runtime.spi.ISessionFactory;
import org.jboss.tools.hibernate.runtime.spi.ISettings;
import org.jboss.tools.hibernate.runtime.spi.ITable;
import org.jboss.tools.hibernate.runtime.spi.ITableFilter;
import org.jboss.tools.hibernate.runtime.spi.ITableIdentifier;
import org.jboss.tools.hibernate.runtime.spi.ITypeFactory;
import org.jboss.tools.hibernate.runtime.spi.IValue;
import org.jboss.tools.hibernate.runtime.v_3_6.internal.FacadeFactoryImpl;
import org.jboss.tools.hibernate.runtime.v_3_6.internal.HibernateMappingExporterExtension;
import org.jboss.tools.hibernate.runtime.v_3_6.internal.OpenMappingUtilsEjb3;
import org.xml.sax.EntityResolver;

public class ServiceImpl
implements IService {
    private IFacadeFactory facadeFactory = new FacadeFactoryImpl();

    public IConfiguration newAnnotationConfiguration() {
        Configuration configuration = new Configuration();
        configuration.setProperty("hibernate.validator.autoregister_listeners", "false");
        configuration.setProperty("hibernate.validator.apply_to_ddl", "false");
        return this.facadeFactory.createConfiguration((Object)configuration);
    }

    public IConfiguration newJpaConfiguration(String entityResolver, String persistenceUnit, java.util.Map<Object, Object> overrides) {
        Ejb3Configuration ejb3Configuration = new Ejb3Configuration();
        if (StringHelper.isNotEmpty((String)entityResolver)) {
            try {
                Class resolver = ReflectHelper.classForName((String)entityResolver, this.getClass());
                Object object = resolver.newInstance();
                ejb3Configuration.setEntityResolver((EntityResolver)object);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                throw new HibernateConsoleRuntimeException((Throwable)e);
            }
        }
        ejb3Configuration.setProperty("hibernate.validator.autoregister_listeners", "false");
        ejb3Configuration.setProperty("hibernate.validator.apply_to_ddl", "false");
        ejb3Configuration.configure(persistenceUnit, overrides);
        AnnotationConfiguration configuration = ejb3Configuration.getHibernateConfiguration();
        return this.facadeFactory.createConfiguration((Object)configuration);
    }

    public IConfiguration newDefaultConfiguration() {
        Configuration target = new Configuration();
        target.setProperty("hibernate.validator.autoregister_listeners", "false");
        target.setProperty("hibernate.validator.apply_to_ddl", "false");
        return this.facadeFactory.createConfiguration((Object)target);
    }

    public IHibernateMappingExporter newHibernateMappingExporter(IConfiguration hcfg, File file) {
        assert (hcfg instanceof IFacade);
        HibernateMappingExporterExtension target = new HibernateMappingExporterExtension(this.facadeFactory, (Configuration)((IFacade)hcfg).getTarget(), file);
        return this.facadeFactory.createHibernateMappingExporter((Object)target);
    }

    public ISchemaExport newSchemaExport(IConfiguration hcfg) {
        ISchemaExport result = null;
        if (hcfg instanceof IFacade) {
            SchemaExport schemaExport = new SchemaExport((Configuration)((IFacade)hcfg).getTarget());
            result = this.facadeFactory.createSchemaExport((Object)schemaExport);
        }
        return result;
    }

    public IHQLCodeAssist newHQLCodeAssist(IConfiguration hcfg) {
        IHQLCodeAssist result = null;
        if (hcfg instanceof IFacade) {
            result = this.facadeFactory.createHQLCodeAssist((Object)new HQLCodeAssist((Configuration)((IFacade)hcfg).getTarget()));
        }
        return result;
    }

    public IConfiguration newJDBCMetaDataConfiguration() {
        JDBCMetaDataConfiguration configuration = new JDBCMetaDataConfiguration();
        return this.facadeFactory.createConfiguration((Object)configuration);
    }

    public IExporter createExporter(String exporterClassName) {
        Exporter exporter = (Exporter)Util.getInstance((String)exporterClassName, (ClassLoader)this.facadeFactory.getClassLoader());
        return this.facadeFactory.createExporter((Object)exporter);
    }

    public IArtifactCollector newArtifactCollector() {
        return this.facadeFactory.createArtifactCollector((Object)new ArtifactCollector());
    }

    public IHQLQueryPlan newHQLQueryPlan(String query, boolean shallow, ISessionFactory sessionFactory) {
        assert (sessionFactory instanceof IFacade);
        SessionFactoryImpl factory = (SessionFactoryImpl)((IFacade)sessionFactory).getTarget();
        java.util.Map enabledFilters = Collections.emptyMap();
        HQLQueryPlan queryPlan = new HQLQueryPlan(query, shallow, enabledFilters, (SessionFactoryImplementor)factory);
        return this.facadeFactory.createHQLQueryPlan((Object)queryPlan);
    }

    public ITypeFactory newTypeFactory() {
        return this.facadeFactory.createTypeFactory();
    }

    public INamingStrategy newNamingStrategy(String strategyClassName) {
        try {
            NamingStrategy ns = (NamingStrategy)ReflectHelper.classForName((String)strategyClassName).newInstance();
            return this.facadeFactory.createNamingStrategy((Object)ns);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException reflectiveOperationException) {
            return null;
        }
    }

    public IOverrideRepository newOverrideRepository() {
        return this.facadeFactory.createOverrideRepository((Object)new OverrideRepository());
    }

    public ITableFilter newTableFilter() {
        return this.facadeFactory.createTableFilter((Object)new TableFilter());
    }

    public IReverseEngineeringSettings newReverseEngineeringSettings(IReverseEngineeringStrategy res) {
        assert (res instanceof IFacade);
        return this.facadeFactory.createReverseEngineeringSettings((Object)new ReverseEngineeringSettings((ReverseEngineeringStrategy)((IFacade)res).getTarget()));
    }

    public IReverseEngineeringStrategy newDefaultReverseEngineeringStrategy() {
        return this.facadeFactory.createReverseEngineeringStrategy((Object)new DefaultReverseEngineeringStrategy());
    }

    public IJDBCReader newJDBCReader(IConfiguration configuration, ISettings settings, IReverseEngineeringStrategy strategy) {
        assert (strategy instanceof IFacade);
        assert (settings instanceof IFacade);
        JDBCReader target = JDBCReaderFactory.newJDBCReader((Properties)configuration.getProperties(), (Settings)((Settings)((IFacade)settings).getTarget()), (ReverseEngineeringStrategy)((ReverseEngineeringStrategy)((IFacade)strategy).getTarget()));
        return this.facadeFactory.createJDBCReader((Object)target);
    }

    public IReverseEngineeringStrategy newReverseEngineeringStrategy(String strategyName, IReverseEngineeringStrategy delegate) {
        assert (delegate instanceof IFacade);
        ReverseEngineeringStrategy target = this.newReverseEngineeringStrategy(strategyName, (ReverseEngineeringStrategy)((IFacade)delegate).getTarget());
        return this.facadeFactory.createReverseEngineeringStrategy((Object)target);
    }

    private ReverseEngineeringStrategy newReverseEngineeringStrategy(String className, ReverseEngineeringStrategy delegate) {
        try {
            Class clazz = ReflectHelper.classForName((String)className);
            Constructor constructor = clazz.getConstructor(ReverseEngineeringStrategy.class);
            return (ReverseEngineeringStrategy)constructor.newInstance(delegate);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            try {
                Class clazz = ReflectHelper.classForName((String)className);
                ReverseEngineeringStrategy rev = (ReverseEngineeringStrategy)clazz.newInstance();
                return rev;
            }
            catch (Exception eq) {
                throw new HibernateConsoleRuntimeException((Throwable)eq);
            }
        }
        catch (Exception e) {
            throw new HibernateConsoleRuntimeException((Throwable)e);
        }
    }

    public String getReverseEngineeringStrategyClassName() {
        return ReverseEngineeringStrategy.class.getName();
    }

    public IDatabaseCollector newDatabaseCollector(IMetaDataDialect metaDataDialect) {
        assert (metaDataDialect instanceof IFacade);
        return this.facadeFactory.createDatabaseCollector((Object)new DefaultDatabaseCollector((MetaDataDialect)((IFacade)metaDataDialect).getTarget()));
    }

    public ICfg2HbmTool newCfg2HbmTool() {
        return this.facadeFactory.createCfg2HbmTool();
    }

    public IProperty newProperty() {
        return this.facadeFactory.createProperty((Object)new Property());
    }

    public ITable newTable(String name) {
        return this.facadeFactory.createTable((Object)new Table(name));
    }

    public IColumn newColumn(String string) {
        return this.facadeFactory.createColumn((Object)new Column(string));
    }

    public IDialect newDialect(Properties properties, Connection connection) {
        Dialect dialect = null;
        dialect = connection == null ? DialectFactory.buildDialect((Properties)properties) : DialectFactory.buildDialect((Properties)properties, (Connection)connection);
        return dialect != null ? this.facadeFactory.createDialect((Object)dialect) : null;
    }

    public Class<?> getDriverManagerConnectionProviderClass() {
        return DriverManagerConnectionProvider.class;
    }

    public IEnvironment getEnvironment() {
        return this.facadeFactory.createEnvironment();
    }

    public IValue newSimpleValue() {
        return this.facadeFactory.createValue((Object)new SimpleValue(null));
    }

    public IValue newPrimitiveArray(IPersistentClass persistentClass) {
        assert (persistentClass instanceof IFacade);
        return this.facadeFactory.createValue((Object)new PrimitiveArray(null, (PersistentClass)((IFacade)persistentClass).getTarget()));
    }

    public IValue newArray(IPersistentClass persistentClass) {
        assert (persistentClass instanceof IFacade);
        return this.facadeFactory.createValue((Object)new Array(null, (PersistentClass)((IFacade)persistentClass).getTarget()));
    }

    public IValue newBag(IPersistentClass persistentClass) {
        assert (persistentClass instanceof IFacade);
        return this.facadeFactory.createValue((Object)new Bag(null, (PersistentClass)((IFacade)persistentClass).getTarget()));
    }

    public IValue newList(IPersistentClass persistentClass) {
        assert (persistentClass instanceof IFacade);
        return this.facadeFactory.createValue((Object)new List(null, (PersistentClass)((IFacade)persistentClass).getTarget()));
    }

    public IValue newMap(IPersistentClass persistentClass) {
        assert (persistentClass instanceof IFacade);
        return this.facadeFactory.createValue((Object)new Map(null, (PersistentClass)((IFacade)persistentClass).getTarget()));
    }

    public IValue newSet(IPersistentClass persistentClass) {
        assert (persistentClass instanceof IFacade);
        return this.facadeFactory.createValue((Object)new Set(null, (PersistentClass)((IFacade)persistentClass).getTarget()));
    }

    public IValue newManyToOne(ITable table) {
        assert (table instanceof IFacade);
        return this.facadeFactory.createValue((Object)new ManyToOne(null, (Table)((IFacade)table).getTarget()));
    }

    public IValue newOneToMany(IPersistentClass persistentClass) {
        assert (persistentClass instanceof IFacade);
        return this.facadeFactory.createValue((Object)new OneToMany(null, (PersistentClass)((IFacade)persistentClass).getTarget()));
    }

    public IValue newOneToOne(IPersistentClass persistentClass) {
        assert (persistentClass instanceof IFacade);
        return this.facadeFactory.createValue((Object)new OneToOne(null, ((PersistentClass)((IFacade)persistentClass).getTarget()).getTable(), (PersistentClass)((IFacade)persistentClass).getTarget()));
    }

    public IPersistentClass newSingleTableSubclass(IPersistentClass persistentClass) {
        assert (persistentClass instanceof IFacade);
        return this.facadeFactory.createPersistentClass((Object)new SingleTableSubclass((PersistentClass)((IFacade)persistentClass).getTarget()));
    }

    public IPersistentClass newJoinedSubclass(IPersistentClass persistentClass) {
        assert (persistentClass instanceof IFacade);
        return this.facadeFactory.createPersistentClass((Object)new JoinedSubclass((PersistentClass)((IFacade)persistentClass).getTarget()));
    }

    public IPersistentClass newSpecialRootClass(IProperty ormElement) {
        return this.facadeFactory.createSpecialRootClass(ormElement);
    }

    public IPersistentClass newRootClass() {
        return this.facadeFactory.createPersistentClass((Object)new RootClass());
    }

    public IPrimaryKey newPrimaryKey() {
        return this.facadeFactory.createPrimaryKey((Object)new PrimaryKey());
    }

    public IHibernateMappingGlobalSettings newHibernateMappingGlobalSettings() {
        return this.facadeFactory.createHibernateMappingGlobalSettings((Object)new HibernateMappingGlobalSettings());
    }

    public ITableIdentifier createTableIdentifier(ITable table) {
        assert (table instanceof IFacade);
        return this.facadeFactory.createTableIdentifier((Object)TableIdentifier.create((Table)((Table)((IFacade)table).getTarget())));
    }

    public ITableIdentifier newTableIdentifier(String catalog, String schema, String name) {
        return this.facadeFactory.createTableIdentifier((Object)new TableIdentifier(catalog, schema, name));
    }

    public boolean isInitialized(Object object) {
        return Hibernate.isInitialized((Object)object);
    }

    public java.util.List<String> getJPAMappingFilePaths(String persistenceUnitName, EntityResolver entityResolver) {
        return OpenMappingUtilsEjb3.enumDocuments(persistenceUnitName, entityResolver);
    }

    public Class<?> getClassWithoutInitializingProxy(Object reflectedObject) {
        return HibernateProxyHelper.getClassWithoutInitializingProxy((Object)reflectedObject);
    }

    public ClassLoader getClassLoader() {
        return ServiceImpl.class.getClassLoader();
    }
}

