/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.jpt.ui.internal.mapping.details;

import java.util.ArrayList;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jpt.common.ui.internal.widgets.DialogPane;
import org.eclipse.jpt.common.ui.internal.widgets.ValidatingDialog;
import org.eclipse.jpt.common.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.StaticListValueModel;
import org.eclipse.jpt.common.utility.internal.transformer.AbstractTransformer;
import org.eclipse.jpt.common.utility.model.value.ListValueModel;
import org.eclipse.jpt.common.utility.model.value.ModifiablePropertyValueModel;
import org.eclipse.jpt.common.utility.transformer.Transformer;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.jpa.ui.details.JptJpaUiDetailsMessages;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.jboss.tools.hibernate.jpt.ui.internal.mapping.details.AddQueryStateObject;
import org.jboss.tools.hibernate.jpt.ui.internal.mapping.details.HibernateUIMappingMessages;

public class HibernateAddQueryDialog
extends ValidatingDialog<AddQueryStateObject> {
    public static final String NAMED_QUERY = "namedQuery";
    public static final String NAMED_NATIVE_QUERY = "namedNativeQuery";
    private boolean hibernateOnly;
    private PersistenceUnit pUnit;

    public HibernateAddQueryDialog(Shell parent, PersistenceUnit pUnit, boolean hibernateOnly, ResourceManager resourceManager) {
        super(parent, resourceManager, JptJpaUiDetailsMessages.ADD_QUERY_DIALOG_TITLE);
        this.pUnit = pUnit;
        this.hibernateOnly = hibernateOnly;
    }

    protected AddQueryStateObject buildStateObject() {
        return new AddQueryStateObject(this.pUnit);
    }

    protected String getDescriptionTitle() {
        return JptJpaUiDetailsMessages.ADD_QUERY_DIALOG_DESCRIPTION_TITLE;
    }

    protected String getDescription() {
        return JptJpaUiDetailsMessages.ADD_QUERY_DIALOG_DESCRIPTION;
    }

    protected DialogPane<AddQueryStateObject> buildLayout(Composite container) {
        return new QueryDialogPane(container);
    }

    public void create() {
        super.create();
        QueryDialogPane pane = (QueryDialogPane)this.getPane();
        pane.selectAll();
        this.getButton(0).setEnabled(false);
    }

    public String getName() {
        return ((AddQueryStateObject)this.getSubject()).getName();
    }

    public String getQueryType() {
        return ((AddQueryStateObject)this.getSubject()).getQueryType();
    }

    private class QueryDialogPane
    extends DialogPane<AddQueryStateObject> {
        private Text nameText;

        QueryDialogPane(Composite parent) {
            super(HibernateAddQueryDialog.this.getSubjectHolder(), parent, HibernateAddQueryDialog.this.resourceManager);
        }

        protected void initializeLayout(Composite container) {
            this.addLabel(container, JptJpaUiDetailsMessages.ADD_QUERY_DIALOG_NAME);
            this.nameText = this.addText(container, this.buildNameHolder());
            this.addLabel(container, JptJpaUiDetailsMessages.ADD_QUERY_DIALOG_QUERY_TYPE);
            this.addCombo(container, this.buildQueryTypeListHolder(), this.buildQueryTypeHolder(), this.buildStringConverter(), null);
        }

        protected ListValueModel<String> buildQueryTypeListHolder() {
            ArrayList<String> queryTypes = new ArrayList<String>();
            if (!HibernateAddQueryDialog.this.hibernateOnly) {
                queryTypes.add(HibernateAddQueryDialog.NAMED_QUERY);
                queryTypes.add(HibernateAddQueryDialog.NAMED_NATIVE_QUERY);
            }
            queryTypes.add("hibernateNamedQuery");
            queryTypes.add("hibernateNamedNativeQuery");
            return new StaticListValueModel(queryTypes);
        }

        private Transformer<String, String> buildStringConverter() {
            return new AbstractTransformer<String, String>(){

                protected String transform_(String value) {
                    if (value == HibernateAddQueryDialog.NAMED_QUERY) {
                        return JptJpaUiDetailsMessages.ADD_QUERY_DIALOG_NAMED_QUERY;
                    }
                    if (value == HibernateAddQueryDialog.NAMED_NATIVE_QUERY) {
                        return JptJpaUiDetailsMessages.ADD_QUERY_DIALOG_NAMED_NATIVE_QUERY;
                    }
                    if (value == "hibernateNamedQuery") {
                        return HibernateUIMappingMessages.HibernateAddQueryDialog_hibernateNamedQuery;
                    }
                    if (value == "hibernateNamedNativeQuery") {
                        return HibernateUIMappingMessages.HibernateAddQueryDialog_hibernateNamedNativeQuery;
                    }
                    return value;
                }
            };
        }

        private ModifiablePropertyValueModel<String> buildNameHolder() {
            return new PropertyAspectAdapter<AddQueryStateObject, String>(this.getSubjectHolder(), new String[]{"nameProperty"}){

                protected String buildValue_() {
                    return ((AddQueryStateObject)((Object)this.subject)).getName();
                }

                protected void setValue_(String value) {
                    ((AddQueryStateObject)((Object)this.subject)).setName(value);
                }
            };
        }

        private ModifiablePropertyValueModel<String> buildQueryTypeHolder() {
            return new PropertyAspectAdapter<AddQueryStateObject, String>(this.getSubjectHolder(), new String[]{"queryTypeProperty"}){

                protected String buildValue_() {
                    return ((AddQueryStateObject)((Object)this.subject)).getQueryType();
                }

                protected void setValue_(String value) {
                    ((AddQueryStateObject)((Object)this.subject)).setQueryType(value);
                }
            };
        }

        void selectAll() {
            this.nameText.selectAll();
        }
    }
}

