/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards;

import java.io.InputStream;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.jar.Manifest;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.ui.wizards.JavaProjectNature;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.pde.internal.core.ClasspathComputer;
import org.eclipse.pde.internal.core.natures.PDE;
import org.eclipse.pde.internal.core.project.PDEProject;
import org.eclipse.pde.internal.core.util.CoreUtility;
import org.eclipse.pde.internal.ui.wizards.Activator;
import org.eclipse.ui.wizards.datatransfer.ProjectConfigurator;

public class BundleProjectConfigurator
implements ProjectConfigurator {
    public boolean canConfigure(IProject project, Set<IPath> ignoredDirectories, IProgressMonitor monitor) {
        IFile manifestFile = PDEProject.getManifest((IProject)project);
        if (manifestFile != null && manifestFile.exists()) {
            for (IPath ignoredDirectory : ignoredDirectories) {
                if (!ignoredDirectory.isPrefixOf(manifestFile.getLocation())) continue;
                return false;
            }
        }
        return this.hasOSGiManifest((IContainer)project);
    }

    public IWizard getConfigurationWizard() {
        return null;
    }

    public void configure(IProject project, Set<IPath> ignoredDirectories, IProgressMonitor monitor) {
        if (PDE.hasPluginNature((IProject)project)) {
            return;
        }
        try {
            CoreUtility.addNatureToProject((IProject)project, (String)"org.eclipse.pde.PluginNature", (IProgressMonitor)monitor);
            if (project.hasNature("org.eclipse.jdt.core.javanature")) {
                return;
            }
            IFile buildPropertiesFile = PDEProject.getBuildProperties((IProject)project);
            Properties buildProperties = new Properties();
            if (buildPropertiesFile.exists()) {
                InputStream stream = buildPropertiesFile.getContents();
                buildProperties.load(stream);
                stream.close();
            }
            boolean hasSourceFolder = false;
            for (String entry : buildProperties.stringPropertyNames()) {
                hasSourceFolder |= entry.startsWith("src.") || entry.startsWith("source.");
            }
            if (!hasSourceFolder) {
                return;
            }
            CoreUtility.addNatureToProject((IProject)project, (String)"org.eclipse.jdt.core.javanature", (IProgressMonitor)monitor);
            IJavaProject javaProject = JavaCore.create((IProject)project);
            HashSet<IClasspathEntry> classpath = new HashSet<IClasspathEntry>();
            for (Map.Entry<Object, Object> entry : buildProperties.entrySet()) {
                String entryKey = (String)entry.getKey();
                if (entryKey.startsWith("src.") || entryKey.startsWith("source.")) {
                    String[] stringArray = ((String)entry.getValue()).split(",");
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IFolder folder;
                        String token = stringArray[n2];
                        if ((token = token.trim()).endsWith("/")) {
                            token = token.substring(0, token.length() - 1);
                        }
                        if (token != null && token.length() > 0 && !token.equals(".") && (folder = project.getFolder(token)).exists()) {
                            classpath.add(JavaCore.newSourceEntry((IPath)folder.getFullPath()));
                        }
                        ++n2;
                    }
                    continue;
                }
                if (!entryKey.equals("output..")) continue;
                javaProject.setOutputLocation(project.getFolder(((String)entry.getValue()).trim()).getFullPath(), monitor);
            }
            classpath.add(JavaRuntime.getDefaultJREContainerEntry());
            classpath.add(ClasspathComputer.createContainerEntry());
            javaProject.setRawClasspath(classpath.toArray(new IClasspathEntry[classpath.size()]), monitor);
        }
        catch (Exception ex) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.jboss.tools.playground.easymport.pde", ex.getMessage(), (Throwable)ex));
        }
    }

    public boolean shouldBeAnEclipseProject(IContainer container, IProgressMonitor monitor) {
        return this.hasOSGiManifest(container);
    }

    private boolean hasOSGiManifest(IContainer container) {
        try {
            IFile manifestResource = container.getFile((IPath)new Path("META-INF/MANIFEST.MF"));
            if (manifestResource.exists()) {
                Manifest manifest = new Manifest();
                InputStream stream = manifestResource.getContents();
                manifest.read(stream);
                stream.close();
                return manifest.getMainAttributes().getValue("Bundle-SymbolicName") != null;
            }
        }
        catch (Exception ex) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.jboss.tools.playground.easymport.pde", ex.getMessage(), (Throwable)ex));
        }
        return false;
    }

    public Set<IFolder> getDirectoriesToIgnore(IProject project, IProgressMonitor monitor) {
        HashSet<IFolder> res = new HashSet<IFolder>();
        res.addAll(new JavaProjectNature().getDirectoriesToIgnore(project, monitor));
        try {
            IFile buildPropertiesFile = PDEProject.getBuildProperties((IProject)project);
            Properties buildProperties = new Properties();
            if (buildPropertiesFile.exists()) {
                InputStream stream = buildPropertiesFile.getContents();
                buildProperties.load(stream);
                stream.close();
            }
            for (Map.Entry<Object, Object> entry : buildProperties.entrySet()) {
                String entryKey = (String)entry.getKey();
                if (!entryKey.startsWith("src.") && !entryKey.startsWith("source.") && !entryKey.startsWith("bin.") && !entryKey.startsWith("output.")) continue;
                String[] stringArray = ((String)entry.getValue()).split(",");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IFolder folder;
                    String token = stringArray[n2];
                    if ((token = token.trim()).endsWith("/")) {
                        token = token.substring(0, token.length() - 1);
                    }
                    if (token != null && token.length() > 0 && !token.equals(".") && (folder = project.getFolder(token)).exists()) {
                        res.add(folder);
                    }
                    ++n2;
                }
            }
        }
        catch (Exception ex) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.jboss.tools.playground.easymport.pde", ex.getMessage(), (Throwable)ex));
        }
        return res;
    }
}

