/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cdi.internal.core.impl.definition;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.IPath;
import org.jboss.tools.cdi.internal.core.impl.Excluded;
import org.jboss.tools.cdi.internal.core.impl.definition.XMLNodeReference;
import org.jboss.tools.cdi.xml.beans.model.CDIBeansConstants;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.filesystems.impl.FileAnyImpl;
import org.jboss.tools.common.model.filesystems.impl.FolderImpl;
import org.jboss.tools.common.text.INodeReference;

public class BeansXMLDefinition
implements CDIBeansConstants {
    private IPath path;
    private Collection<INodeReference> typeAlternatives = new ArrayList<INodeReference>();
    private Collection<INodeReference> stereotypeAlternatives = new ArrayList<INodeReference>();
    private Collection<INodeReference> decorators = new ArrayList<INodeReference>();
    private Collection<INodeReference> interceptors = new ArrayList<INodeReference>();
    private Collection<Excluded> excluded = new ArrayList<Excluded>();

    public void setBeansXML(XModelObject beansXML) {
        if (beansXML.getModelEntity().getName().startsWith("FileCDIBeans")) {
            XModelObject scan;
            XModelObject alternativesObject;
            XModelObject decoratorsObject;
            int n;
            XModelObject interceptorsObject;
            FileAnyImpl f;
            if (beansXML instanceof FileAnyImpl && (f = (FileAnyImpl)beansXML).getParent() instanceof FolderImpl) {
                ((FolderImpl)f.getParent()).waitForUpdate();
                ((FolderImpl)f.getParent()).update();
            }
            if ((interceptorsObject = beansXML.getChildByPath("Interceptors")) != null) {
                XModelObject[] cs;
                XModelObject[] xModelObjectArray = cs = interceptorsObject.getChildren();
                n = cs.length;
                int n2 = 0;
                while (n2 < n) {
                    XModelObject o = xModelObjectArray[n2];
                    this.interceptors.add(new XMLNodeReference(o, "class"));
                    ++n2;
                }
            }
            if ((decoratorsObject = beansXML.getChildByPath("Decorators")) != null) {
                XModelObject[] cs;
                XModelObject[] xModelObjectArray = cs = decoratorsObject.getChildren();
                int n3 = cs.length;
                n = 0;
                while (n < n3) {
                    XModelObject o = xModelObjectArray[n];
                    this.decorators.add(new XMLNodeReference(o, "class"));
                    ++n;
                }
            }
            if ((alternativesObject = beansXML.getChildByPath("Alternatives")) != null) {
                XModelObject[] cs;
                XModelObject[] xModelObjectArray = cs = alternativesObject.getChildren("CDIClass");
                int n4 = cs.length;
                int n5 = 0;
                while (n5 < n4) {
                    XModelObject o = xModelObjectArray[n5];
                    this.typeAlternatives.add(new XMLNodeReference(o, "class"));
                    ++n5;
                }
                xModelObjectArray = cs = alternativesObject.getChildren("CDIStereotype");
                n4 = cs.length;
                n5 = 0;
                while (n5 < n4) {
                    XModelObject o = xModelObjectArray[n5];
                    this.stereotypeAlternatives.add(new XMLNodeReference(o, "stereotype"));
                    ++n5;
                }
            }
            if ((scan = beansXML.getChildByPath("Weld Scan")) != null) {
                this.loadScan(scan);
            }
            if ((scan = beansXML.getChildByPath("Scan")) != null) {
                this.loadScan(scan);
            }
        }
    }

    void loadScan(XModelObject scan) {
        XModelObject[] cs;
        XModelObject[] xModelObjectArray = cs = scan.getChildren();
        int n = cs.length;
        int n2 = 0;
        while (n2 < n) {
            String name;
            XModelObject c = xModelObjectArray[n2];
            if ("exclude".equals(c.getAttributeValue("element type")) && (name = c.getAttributeValue("name")) != null && !name.startsWith("!")) {
                XModelObject[] cs2;
                Excluded excluded = new Excluded(this.path);
                excluded.setFilter(name);
                XModelObject[] xModelObjectArray2 = cs2 = c.getChildren();
                int n3 = cs2.length;
                int n4 = 0;
                while (n4 < n3) {
                    XModelObject c2 = xModelObjectArray2[n4];
                    String name2 = c2.getAttributeValue("name");
                    String t2 = c2.getAttributeValue("element type");
                    if ("if-class-available".equals(t2)) {
                        if (name2.startsWith("!")) {
                            excluded.addNotAvailableType(name2.substring(1));
                        } else {
                            excluded.addAvailableType(name2);
                        }
                    } else if ("if-class-not-available".equals(t2)) {
                        excluded.addNotAvailableType(name2);
                    }
                    ++n4;
                }
                this.excluded.add(excluded);
            }
            ++n2;
        }
    }

    public void setPath(IPath path) {
        this.path = path;
    }

    public IPath getPath() {
        return this.path;
    }

    public Collection<INodeReference> getTypeAlternatives() {
        return this.typeAlternatives;
    }

    public Collection<INodeReference> getStereotypeAlternatives() {
        return this.stereotypeAlternatives;
    }

    public Collection<INodeReference> getDecorators() {
        return this.decorators;
    }

    public Collection<INodeReference> getInterceptors() {
        return this.interceptors;
    }

    public Collection<Excluded> getExcluded() {
        return this.excluded;
    }
}

