/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cdi.internal.core.impl.definition;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.jboss.tools.cdi.core.CDICorePlugin;
import org.jboss.tools.cdi.core.IRootDefinitionContext;
import org.jboss.tools.cdi.core.extension.IDefinitionContextExtension;
import org.jboss.tools.cdi.internal.core.impl.AnnotationDeclaration;
import org.jboss.tools.cdi.internal.core.impl.definition.AbstractTypeDefinition;
import org.jboss.tools.cdi.internal.core.impl.definition.AnnotationHelper;
import org.jboss.tools.cdi.internal.core.impl.definition.AnnotationMemberDefinition;
import org.jboss.tools.common.java.IAnnotationDeclaration;

public class AnnotationDefinition
extends AbstractTypeDefinition {
    public static final int NON_RELEVANT = 0;
    public static final int BASIC = 1;
    public static final int CDI = 2;
    public static final int QUALIFIER = 4;
    public static final int STEREOTYPE = 8;
    public static final int INTERCEPTOR_BINDING = 16;
    public static final int SCOPE = 32;
    public static final int EXTENDED = 1024;
    protected int kind = 0;
    protected Object extendedKind = null;
    List<AnnotationMemberDefinition> methods = new ArrayList<AnnotationMemberDefinition>();

    public void setKind(int kind) {
        this.kind = kind;
    }

    public void setExtendedKind(Object s) {
        this.extendedKind = s;
        this.kind |= 0x400;
    }

    public int getKind() {
        return this.kind;
    }

    public boolean hasExtendedKind(Object kind) {
        return this.extendedKind != null && this.extendedKind.equals(kind);
    }

    public List<AnnotationMemberDefinition> getMethods() {
        return this.methods;
    }

    @Override
    protected void init(IType contextType, IRootDefinitionContext context, int flags) throws CoreException {
        super.init(contextType, context, flags);
        if (this.annotations.isEmpty()) {
            return;
        }
        this.revalidateKind(context);
    }

    public void revalidateKind(IRootDefinitionContext context) {
        boolean newHasMembers;
        boolean hasMembers = (this.kind & 4) > 0 || (this.kind & 0x10) > 0 || this.kind == 1024;
        this.kind = 0;
        HashMap<String, AnnotationDeclaration> ds = new HashMap<String, AnnotationDeclaration>();
        for (IAnnotationDeclaration a : this.annotations) {
            if (!(a instanceof AnnotationDeclaration)) continue;
            AnnotationDeclaration aa = (AnnotationDeclaration)a;
            String typeName = aa.getTypeName();
            ds.put(typeName, aa);
        }
        if (ds.containsKey("javax.inject.Scope") || ds.containsKey("javax.enterprise.context.NormalScope")) {
            this.kind = 32;
        }
        if (ds.containsKey("javax.enterprise.inject.Stereotype")) {
            this.kind |= 8;
        }
        if (ds.containsKey("javax.inject.Qualifier")) {
            this.kind |= 4;
        }
        if (ds.containsKey("javax.interceptor.InterceptorBinding")) {
            this.kind |= 0x10;
        }
        if (this.kind == 0) {
            Set<IDefinitionContextExtension> es = context.getExtensions();
            for (IDefinitionContextExtension e : es) {
                e.computeAnnotationKind(this);
                if (this.kind == 1024) break;
            }
        }
        if (this.kind == 0) {
            if (AnnotationHelper.BASIC_ANNOTATION_TYPES.contains(this.qualifiedName)) {
                this.kind = 1;
            } else if (AnnotationHelper.CDI_ANNOTATION_TYPES.contains(this.qualifiedName)) {
                this.kind = 2;
            }
        }
        boolean bl = newHasMembers = (this.kind & 4) > 0 || (this.kind & 0x10) > 0 || this.kind == 1024;
        if (newHasMembers != hasMembers) {
            this.methods.clear();
            try {
                this.initMemberDefinitions(this.type, context);
            }
            catch (CoreException e) {
                CDICorePlugin.getDefault().logError(e);
            }
        }
    }

    void initMemberDefinitions(IType contextType, IRootDefinitionContext context) throws CoreException {
        IMethod[] ms = this.getType().getMethods();
        int i = 0;
        while (i < ms.length) {
            AnnotationMemberDefinition m = new AnnotationMemberDefinition();
            m.setAnnotationDefinition(this);
            m.setMethod(ms[i], context, 0);
            if (m.isCDIAnnotated()) {
                this.methods.add(m);
            }
            ++i;
        }
    }

    public AnnotationDeclaration getInheritedAnnotation() {
        return this.getAnnotation("java.lang.annotation.Inherited");
    }
}

