/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cdi.internal.core.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jboss.tools.cdi.internal.core.impl.Excluded;
import org.jboss.tools.common.text.INodeReference;

public class BeansXMLData {
    private Collection<INodeReference> interceptors = new ArrayList<INodeReference>();
    private Collection<INodeReference> decorators = new ArrayList<INodeReference>();
    private Collection<INodeReference> stereotypeAlternatives = new ArrayList<INodeReference>();
    private Collection<INodeReference> typeAlternatives = new ArrayList<INodeReference>();
    private Set<String> interceptorTypes = new HashSet<String>();
    private Set<String> decoratorTypes = new HashSet<String>();
    private Set<String> stereotypeAlternativeTypes = new HashSet<String>();
    private Set<String> typeAlternativeTypes = new HashSet<String>();
    private Collection<Excluded> excluded = new ArrayList<Excluded>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clean() {
        BeansXMLData beansXMLData = this;
        synchronized (beansXMLData) {
            this.interceptors.clear();
            this.decorators.clear();
            this.stereotypeAlternatives.clear();
            this.typeAlternatives.clear();
            this.interceptorTypes.clear();
            this.decoratorTypes.clear();
            this.stereotypeAlternativeTypes.clear();
            this.typeAlternativeTypes.clear();
            this.excluded.clear();
        }
    }

    public Collection<INodeReference> getInterceptors() {
        return this.interceptors;
    }

    public Collection<INodeReference> getDecorators() {
        return this.decorators;
    }

    public Collection<INodeReference> getStereotypeAlternatives() {
        return this.stereotypeAlternatives;
    }

    public Collection<INodeReference> getTypeAlternatives() {
        return this.typeAlternatives;
    }

    public Collection<String> getInterceptorTypes() {
        return this.interceptorTypes;
    }

    public Collection<String> getDecoratorTypes() {
        return this.decoratorTypes;
    }

    public Collection<String> getStereotypeAlternativeTypes() {
        return this.stereotypeAlternativeTypes;
    }

    public Collection<String> getTypeAlternativeTypes() {
        return this.typeAlternativeTypes;
    }

    public Collection<Excluded> getExcluded() {
        return this.excluded;
    }

    public synchronized void addInterceptor(INodeReference r) {
        this.interceptors.add(r);
        if (r.getValue() != null) {
            this.interceptorTypes.add(r.getValue());
        }
    }

    public synchronized void addDecorator(INodeReference r) {
        this.decorators.add(r);
        if (r.getValue() != null) {
            this.decoratorTypes.add(r.getValue());
        }
    }

    public synchronized void addStereotypeAlternative(INodeReference r) {
        this.stereotypeAlternatives.add(r);
        if (r.getValue() != null) {
            this.stereotypeAlternativeTypes.add(r.getValue());
        }
    }

    public synchronized void addTypeAlternative(INodeReference r) {
        this.typeAlternatives.add(r);
        if (r.getValue() != null) {
            this.typeAlternativeTypes.add(r.getValue());
        }
    }

    public synchronized void addExcluded(Collection<Excluded> e) {
        this.excluded.addAll(e);
    }
}

