/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.xml;

import javax.xml.namespace.QName;
import org.eclipse.sapphire.LocalizableText;
import org.eclipse.sapphire.Text;

public abstract class XmlNamespaceResolver {
    @Text(value="Could not resolve namespace for {0} node name.")
    private static LocalizableText couldNotResolveNamespace;

    static {
        LocalizableText.init(XmlNamespaceResolver.class);
    }

    public abstract String resolve(String var1);

    public final QName createQualifiedName(String name) {
        String prefix = "";
        String localName = null;
        int colon = name.indexOf(58);
        if (colon == -1) {
            localName = name;
        } else {
            prefix = name.substring(0, colon);
            localName = name.substring(colon + 1);
        }
        String namespace = this.resolve(prefix);
        if (prefix.length() != 0 && (namespace == null || namespace.length() == 0)) {
            String msg = couldNotResolveNamespace.format(new Object[]{name});
            throw new IllegalArgumentException(msg);
        }
        return new QName(namespace, localName, prefix);
    }
}

