/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.jdt.ui.buildpath.dialog;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;
import org.jboss.tools.common.jdt.ui.JDTExtUIActivator;
import org.jboss.tools.common.jdt.ui.buildpath.dialog.IMaterializeLibraryWarningFactory;
import org.jboss.tools.common.jdt.ui.buildpath.dialog.MaterializeLibraryWarningFactory;

public class MaterializeLibraryDialog
extends TitleAreaDialog {
    private static final String SOURCE_PROPERTY = "SOURCE_PROPERTY";
    private static final String FILENAME_PROPERTY = "FILENAME_PROPERTY";
    private IContainer libFolder;
    private Map<IClasspathEntry, String> classpathEntryPaths;
    private Map<IPath, String> selectedClasspathEntryPaths;
    private IClasspathContainer containerToMaterialize;
    private final String libName;
    private Image jarImage;
    private Image projectImage;
    private Text libfolderText;
    private CheckboxTableViewer classpathEntriesViewer;
    private Button keepSourceBtn;
    private boolean keepSources;
    private IMaterializeLibraryWarningFactory warningfactory;
    private Label warningImg;
    private Label warningLabel;

    public MaterializeLibraryDialog(Shell shell, IProject project, IClasspathContainer containerToMaterialize, String defaultLib) {
        super(shell);
        this.setShellStyle(super.getShellStyle() | 0x10);
        this.libName = containerToMaterialize.getDescription();
        IPath folderPath = project.getFullPath().append(defaultLib);
        this.libFolder = ResourcesPlugin.getWorkspace().getRoot().getFolder(folderPath);
        this.containerToMaterialize = containerToMaterialize;
        this.warningfactory = new MaterializeLibraryWarningFactory();
        this.initClasspathEntryPaths();
    }

    private void initClasspathEntryPaths() {
        IClasspathEntry[] cpEntries = this.containerToMaterialize.getClasspathEntries();
        this.classpathEntryPaths = new LinkedHashMap<IClasspathEntry, String>(cpEntries.length);
        IClasspathEntry[] iClasspathEntryArray = cpEntries;
        int n = cpEntries.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry entry = iClasspathEntryArray[n2];
            if (entry.getEntryKind() == 1 && entry.getPath() != null || entry.getEntryKind() == 2) {
                IPath sourceFilePath = entry.getPath();
                String fileName = sourceFilePath.lastSegment();
                this.classpathEntryPaths.put(entry, fileName);
            }
            ++n2;
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Copy Classpath Libraries");
    }

    private void initImages() {
        this.jarImage = JDTExtUIActivator.getJarIcon();
        this.projectImage = JDTExtUIActivator.getProjectIcon();
    }

    protected Control createDialogArea(Composite parent) {
        this.initImages();
        this.setTitle("Copy JAR files from " + this.libName);
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setEnabled(true);
        GridLayout layout = new GridLayout(3, false);
        layout.marginLeft = 12;
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)new GridData(1808));
        String message = NLS.bind((String)"Copy selected JAR files from {0} to the destination folder.", (Object)this.libName);
        String warning = this.warningfactory.getWarning(this.containerToMaterialize);
        if (warning != null) {
            this.displayWarning(container, warning);
        }
        this.setMessage(message);
        Label libFolderLabel = new Label(container, 0);
        libFolderLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        libFolderLabel.setText("Destination folder");
        this.libfolderText = new Text(container, 2048);
        this.libfolderText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.libfolderText.setEditable(true);
        this.libfolderText.setText(this.libFolder.getFullPath().toPortableString());
        this.libfolderText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                MaterializeLibraryDialog.this.validate();
            }
        });
        this.addSelectFolderButton(container);
        this.displayClasspathEntriesTable(container);
        return area;
    }

    private void displayWarning(Composite container, String warning) {
        Composite composite = new Composite(container, 0);
        GridDataFactory.fillDefaults().align(16384, 0x1000000).span(3, 1).applyTo((Control)composite);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(composite);
        this.warningImg = new Label(composite, 0x1000000);
        this.warningImg.setImage(JFaceResources.getImage((String)"dialog_messasge_warning_image"));
        GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)this.warningImg);
        this.warningLabel = new Label(composite, 0);
        this.warningLabel.setText(warning);
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)this.warningLabel);
    }

    private void addSelectFolderButton(Composite container) {
        Button button = new Button(container, 0);
        button.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
        button.setText("Select Folder");
        button.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ContainerSelectionDialog dialog = new ContainerSelectionDialog(MaterializeLibraryDialog.this.getShell(), MaterializeLibraryDialog.getLibFolderFromText(MaterializeLibraryDialog.this.libfolderText.getText()), true, "Select Destination Folder");
                dialog.setTitle("Container Selection");
                dialog.open();
                Object[] result = dialog.getResult();
                if (result != null && result[0] instanceof IPath) {
                    MaterializeLibraryDialog.this.libfolderText.setText(((IPath)result[0]).toPortableString());
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    public boolean close() {
        if (this.jarImage != null) {
            this.jarImage.dispose();
        }
        if (this.projectImage != null) {
            this.projectImage.dispose();
        }
        return super.close();
    }

    private void displayClasspathEntriesTable(Composite container) {
        GridData gd = new GridData(4, 4, true, true, 2, 4);
        gd.heightHint = 500;
        gd.widthHint = 550;
        this.classpathEntriesViewer = CheckboxTableViewer.newCheckList((Composite)container, (int)67586);
        Table table = this.classpathEntriesViewer.getTable();
        table.setFocus();
        table.setLayoutData((Object)gd);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        TableColumn emptyColumn = new TableColumn(table, 0);
        emptyColumn.setWidth(20);
        TableViewerColumn sourceColumn = new TableViewerColumn((TableViewer)this.classpathEntriesViewer, 0);
        sourceColumn.getColumn().setText("Source ");
        sourceColumn.getColumn().setWidth(299);
        TableViewerColumn destinationColumn = new TableViewerColumn((TableViewer)this.classpathEntriesViewer, 0);
        destinationColumn.getColumn().setText("Copy as...");
        destinationColumn.getColumn().setWidth(248);
        this.classpathEntriesViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.classpathEntriesViewer.setLabelProvider((IBaseLabelProvider)new ClasspathEntryLabelProvider());
        this.classpathEntriesViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                MaterializeLibraryDialog.this.refresh();
            }
        });
        this.classpathEntriesViewer.setInput(this.classpathEntryPaths.entrySet());
        this.classpathEntriesViewer.setAllChecked(true);
        this.addSelectionButton(container, "Select All", true);
        this.addSelectionButton(container, "Deselect All", false);
        this.addResetButton(container, "Reset");
        this.keepSourceBtn = this.addCheckButton(container, "Keep source attachments", this.keepSources);
        this.keepSourceBtn.setToolTipText("Source attachment paths may contain absolute paths");
        this.addTableListeners();
    }

    private Button addCheckButton(Composite container, String label, boolean selected) {
        Button checkBtn = new Button(container, 32);
        checkBtn.setText(label);
        checkBtn.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 2, 1));
        checkBtn.setSelection(selected);
        return checkBtn;
    }

    private void addTableListeners() {
        this.addCellEditors();
    }

    protected void addCellEditors() {
        this.classpathEntriesViewer.setColumnProperties(new String[]{"EMPTY", SOURCE_PROPERTY, FILENAME_PROPERTY});
        TextCellEditor ce = new TextCellEditor((Composite)this.classpathEntriesViewer.getTable());
        CellEditor[] cellEditorArray = new CellEditor[3];
        cellEditorArray[1] = ce;
        cellEditorArray[2] = ce;
        CellEditor[] editors = cellEditorArray;
        this.classpathEntriesViewer.setCellEditors(editors);
        this.classpathEntriesViewer.setCellModifier((ICellModifier)new FileNameCellModifier());
    }

    public Map<IPath, String> getSelectedClasspathEntryPaths() {
        return this.selectedClasspathEntryPaths;
    }

    public IContainer getLibFolder() {
        return this.libFolder;
    }

    public boolean isKeepSources() {
        return this.keepSources;
    }

    private static IContainer getLibFolderFromText(String text) {
        String portablePath = text.replaceAll("\\\\", "/");
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        Path path = new Path(portablePath);
        if (path.segmentCount() == 1) {
            return workspaceRoot.getProject(path.segment(0));
        }
        if (path.segmentCount() > 1) {
            return ResourcesPlugin.getWorkspace().getRoot().getFolder((IPath)path);
        }
        return null;
    }

    protected void okPressed() {
        if (!this.validate()) {
            return;
        }
        String dialogWarning = this.warningfactory.getDialogWarning(this.containerToMaterialize);
        if (dialogWarning != null) {
            String[] buttonLabels = new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL};
            MessageDialog dialog = new MessageDialog(this.getShell(), this.getShell().getText(), null, dialogWarning, 4, buttonLabels, 0);
            if (dialog.open() == 1) {
                return;
            }
        }
        this.libFolder = MaterializeLibraryDialog.getLibFolderFromText(this.libfolderText.getText());
        this.keepSources = this.keepSourceBtn.getSelection();
        super.okPressed();
    }

    private boolean validate() {
        boolean valid;
        boolean bl = valid = this.validateLibFolder() && this.validateEntries();
        if (valid) {
            this.setErrorMessage(null);
        }
        return valid;
    }

    private boolean validateLibFolder() {
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IContainer folder = MaterializeLibraryDialog.getLibFolderFromText(this.libfolderText.getText());
        if (folder == null || workspaceRoot.equals((Object)folder)) {
            this.setErrorMessage("You must select a project destination to copy classpath entries");
            return false;
        }
        String ancestorPath = folder.getFullPath().segment(0);
        IResource ancestor = workspaceRoot.findMember(ancestorPath);
        if (ancestor == null || !ancestor.exists()) {
            this.setErrorMessage(String.valueOf(ancestorPath) + " does not exist ");
            return false;
        }
        return true;
    }

    private boolean validateEntries() {
        Object[] selection = this.classpathEntriesViewer.getCheckedElements();
        this.selectedClasspathEntryPaths = new LinkedHashMap<IPath, String>(selection.length);
        Object[] objectArray = selection;
        int n = selection.length;
        int n2 = 0;
        while (n2 < n) {
            String name;
            Object o = objectArray[n2];
            Map.Entry entry = (Map.Entry)o;
            if (((IClasspathEntry)entry.getKey()).getEntryKind() == 1 && !this.checkValidName(name = (String)entry.getValue())) {
                this.setErrorMessage(String.valueOf(name) + " is not a valid file name");
                return false;
            }
            this.selectedClasspathEntryPaths.put(((IClasspathEntry)entry.getKey()).getPath(), (String)entry.getValue());
            ++n2;
        }
        Set<String> duplicates = this.findDuplicates(this.selectedClasspathEntryPaths.values());
        if (!duplicates.isEmpty()) {
            this.setErrorMessage("Duplicate entries found : " + duplicates.toString());
            return false;
        }
        return true;
    }

    private Set<String> findDuplicates(Collection<String> values) {
        HashSet<String> uniqueNames = new HashSet<String>(values.size());
        HashSet<String> duplicateNames = new HashSet<String>();
        for (String name : values) {
            if (uniqueNames.add(name)) continue;
            duplicateNames.add(name);
        }
        return duplicateNames;
    }

    private Button addSelectionButton(Composite container, String label, final boolean ischecked) {
        Button button = new Button(container, 0);
        button.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
        button.setText(label);
        button.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                MaterializeLibraryDialog.this.classpathEntriesViewer.setAllChecked(ischecked);
                MaterializeLibraryDialog.this.refresh();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        return button;
    }

    private Button addResetButton(Composite container, String label) {
        Button button = new Button(container, 0);
        button.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
        button.setText(label);
        button.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                MaterializeLibraryDialog.this.initClasspathEntryPaths();
                MaterializeLibraryDialog.this.classpathEntriesViewer.setInput(MaterializeLibraryDialog.this.classpathEntryPaths.entrySet());
                MaterializeLibraryDialog.this.classpathEntriesViewer.setAllChecked(true);
                MaterializeLibraryDialog.this.refresh();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        return button;
    }

    protected void refresh() {
        this.classpathEntriesViewer.refresh();
    }

    public boolean checkValidName(String name) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IStatus result = workspace.validateName(name, 1);
        if (!result.isOK()) {
            return false;
        }
        return !name.contains("\\") && (name.endsWith(".jar") || name.endsWith(".zip"));
    }

    private class ClasspathEntryLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private static final int SOURCE_COLUMN = 1;
        private static final int FILENAME_COLUMN = 2;

        private ClasspathEntryLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            Map.Entry entry = (Map.Entry)element;
            StringBuilder text = new StringBuilder();
            if (entry != null) {
                if (columnIndex == 1) {
                    text.append(((IClasspathEntry)entry.getKey()).getPath().lastSegment());
                } else if (columnIndex == 2) {
                    text.append((String)entry.getValue());
                }
            }
            return text.toString();
        }

        public Image getColumnImage(Object element, int columnIndex) {
            Image img = null;
            if (columnIndex > 0) {
                Map.Entry entry = (Map.Entry)element;
                img = ((IClasspathEntry)entry.getKey()).getEntryKind() == 1 ? MaterializeLibraryDialog.this.jarImage : MaterializeLibraryDialog.this.projectImage;
            }
            return img;
        }
    }

    private class FileNameCellModifier
    implements ICellModifier {
        private FileNameCellModifier() {
        }

        public boolean canModify(Object element, String property) {
            Map.Entry entry = (Map.Entry)element;
            return ((IClasspathEntry)entry.getKey()).getEntryKind() == 1 && (MaterializeLibraryDialog.FILENAME_PROPERTY.equals(property) || MaterializeLibraryDialog.SOURCE_PROPERTY.equals(property));
        }

        public Object getValue(Object element, String property) {
            Map.Entry entry = (Map.Entry)element;
            if (property.equals(MaterializeLibraryDialog.SOURCE_PROPERTY)) {
                return ((IClasspathEntry)entry.getKey()).getPath().toOSString();
            }
            if (property.equals(MaterializeLibraryDialog.FILENAME_PROPERTY)) {
                return entry.getValue();
            }
            return "";
        }

        public void modify(Object element, String property, Object value) {
            TableItem item;
            Map.Entry entry;
            if (property.equals(MaterializeLibraryDialog.FILENAME_PROPERTY) && ((IClasspathEntry)(entry = (Map.Entry)(item = (TableItem)element).getData()).getKey()).getEntryKind() == 1) {
                String name = value.toString();
                entry.setValue(name);
                MaterializeLibraryDialog.this.validate();
                MaterializeLibraryDialog.this.classpathEntriesViewer.refresh();
            }
        }
    }
}

