/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.explorer.platform.engine.transformer;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.wst.ws.internal.datamodel.Element;
import org.eclipse.wst.ws.internal.datamodel.Rel;
import org.eclipse.wst.ws.internal.explorer.platform.datamodel.TreeElement;
import org.eclipse.wst.ws.internal.explorer.platform.engine.transformer.CurrentNodeSelectionTransformer;
import org.eclipse.wst.ws.internal.explorer.platform.engine.transformer.ITransformer;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.Controller;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.Node;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.NodeManager;

public class NodeIdTransformer
implements ITransformer {
    protected Controller controller;

    public NodeIdTransformer(Controller controller) {
        this.controller = controller;
    }

    public Hashtable normalize(Hashtable properties) {
        int numRelationships;
        Vector<String> rels = new Vector<String>();
        try {
            int nodeId = Integer.parseInt((String)properties.get("nodeId"));
            NodeManager nodeManager = this.controller.getCurrentPerspective().getNodeManager();
            Node rootNode = nodeManager.getRootNode();
            Node node = nodeManager.getNode(nodeId);
            int depth = 0;
            if (node != null) {
                depth = node.getNodeDepth();
            }
            while (rels.size() < depth && node != null && node != rootNode) {
                Node parentNode = node.getParent();
                TreeElement element = node.getTreeElement();
                Rel rel = this.getRel((Element)parentNode.getTreeElement(), (Element)element);
                StringBuffer relValue = new StringBuffer(rel.getName());
                relValue.append("#");
                relValue.append(element.getName());
                rels.insertElementAt(relValue.toString(), 0);
                node = parentNode;
            }
        }
        catch (NumberFormatException numberFormatException) {}
        if ((numRelationships = rels.size()) == 1) {
            properties.put("relationshipId", rels.get(0).toString());
        } else if (numRelationships > 1) {
            properties.put("relationshipId", rels.toArray(new String[0]));
        }
        return properties;
    }

    private Rel getRel(Element sourceElement, Element targetElement) {
        Enumeration rels = sourceElement.getRels();
        while (rels.hasMoreElements()) {
            Rel rel = (Rel)rels.nextElement();
            Enumeration targetElements = rel.getTargetElements();
            while (targetElements.hasMoreElements()) {
                if (targetElements.nextElement() != targetElement) continue;
                return rel;
            }
        }
        return null;
    }

    public Hashtable deNormalize(Hashtable properties) {
        NodeManager nodeManager = this.controller.getCurrentPerspective().getNodeManager();
        Node node = nodeManager.getRootNode();
        Object value = properties.get("relationshipId");
        String[] relationships = null;
        if (value instanceof String[]) {
            relationships = (String[])value;
        } else if (value != null) {
            relationships = new String[]{value.toString()};
        }
        if (relationships != null) {
            int i = 0;
            while (i < relationships.length) {
                String localname;
                int index = relationships[i].indexOf("#");
                if (index == -1) {
                    return this.deNormalizeAsSelectedNode(properties);
                }
                String rel = index != -1 ? relationships[i].substring(0, index) : relationships[i];
                String string = localname = index != -1 ? relationships[i].substring(index + 1, relationships[i].length()) : null;
                if (localname == null) {
                    return this.deNormalizeAsSelectedNode(properties);
                }
                if ((node = this.getNode(node, rel, localname)) == null) {
                    return this.deNormalizeAsSelectedNode(properties);
                }
                ++i;
            }
            properties.put("nodeId", String.valueOf(node.getNodeId()));
            return properties;
        }
        return this.deNormalizeAsSelectedNode(properties);
    }

    private Hashtable deNormalizeAsSelectedNode(Hashtable properties) {
        return new CurrentNodeSelectionTransformer(this.controller).deNormalize(properties);
    }

    private Node getNode(Node parent, String rel, String localname) {
        TreeElement parentElement = parent.getTreeElement();
        Enumeration e = parentElement.getElements(rel);
        while (e.hasMoreElements()) {
            Element element = (Element)e.nextElement();
            if (!localname.equals(element.getName())) continue;
            return parent.getChildNode((TreeElement)element);
        }
        return null;
    }
}

